/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.AIs.ShipSystems;

import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ShipCommand;
import com.fs.starfarer.api.combat.ShipSystemAIScript;
import com.fs.starfarer.api.combat.ShipSystemAPI;
import com.fs.starfarer.api.combat.ShipwideAIFlags;
import com.fs.starfarer.api.util.Misc;
import org.lazywizard.lazylib.MathUtils;
import org.lazywizard.lazylib.VectorUtils;
import org.lazywizard.lazylib.combat.AIUtils;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class Neutrino_AdvancedDiveBombAI
implements ShipSystemAIScript {
    private ShipAPI ship;
    private CombatEngineAPI engine;
    private ShipSystemAPI system;
    private ShipwideAIFlags flags;
    private float timer = 5.0f;
    private boolean isFiring = false;
    private boolean isBombing = false;
    private boolean missed = false;
    private float bombingTime;
    private float bombingTimer;
    private float bombingRange;
    private float firingRange;
    private float payloadSpeed;
    private float bombingSpeed;
    private float missedTimer;
    private float missedTime;
    private static final float flighSpeedError = 5.0f;
    private static final float aimingError = 1.0f;
    private static final float damping = 0.1f;
    private boolean alwaysAcc = false;

    public void init(ShipAPI ship, ShipSystemAPI system, ShipwideAIFlags flags, CombatEngineAPI engine) {
        this.ship = ship;
        this.engine = engine;
        this.system = system;
        this.flags = flags;
        switch (ship.getHullSpec().getHullId()) {
            case "neutrino_schwarzgeist": {
                this.payloadSpeed = ship.getMutableStats().getMissileMaxSpeedBonus().computeEffective(450.0f);
                this.bombingTimer = 1.0f;
                this.bombingTime = 1.0f;
                this.bombingRange = 2000.0f;
                this.firingRange = 800.0f;
                this.bombingSpeed = ship.getMutableStats().getMaxSpeed().getModifiedValue();
                this.alwaysAcc = true;
                break;
            }
            case "neutrino_drache": {
                this.payloadSpeed = ship.getMutableStats().getMissileMaxSpeedBonus().computeEffective(50.0f);
                this.payloadSpeed += ship.getMutableStats().getMaxSpeed().getModifiedValue();
                this.bombingTimer = 0.5f;
                this.bombingTime = 0.5f;
                this.bombingRange = 2000.0f;
                this.firingRange = 400.0f;
                this.bombingSpeed = ship.getMutableStats().getMaxSpeed().getModifiedValue();
                this.alwaysAcc = true;
                break;
            }
        }
    }

    public void advance(float amount, Vector2f missileDangerDir, Vector2f collisionDangerDir, ShipAPI target) {
        if (this.engine == null) {
            return;
        }
        if (this.engine.isPaused()) {
            return;
        }
        if (!this.ship.getShipAI().needsRefit() && target != null && target.isAlive() && !target.isHulk() && Misc.getDistance((Vector2f)this.ship.getLocation(), (Vector2f)target.getLocation()) < this.bombingRange) {
            this.isBombing = true;
        }
        if (!this.system.isActive() && this.isBombing) {
            this.ship.useSystem();
        } else if (this.system.isActive() && !this.isBombing) {
            this.timer -= amount;
            if (this.timer <= 0.0f) {
                this.ship.useSystem();
            }
        } else {
            this.timer = 5.0f;
        }
        if (this.isBombing) {
            Vector2f targetLoc;
            Vector2f lead;
            Vector2f shipLoc = this.ship.getLocation();
            if (target == null || !target.isAlive() || target.isHulk()) {
                this.isBombing = false;
            }
            if ((lead = AIUtils.getBestInterceptPoint((Vector2f)shipLoc, (float)this.payloadSpeed, (Vector2f)(targetLoc = target.getLocation()), (Vector2f)target.getVelocity())) == null) {
                this.isBombing = false;
            } else {
                this.ship.giveCommand(ShipCommand.SELECT_GROUP, (Object)lead, 0);
                this.ship.getMouseTarget().set((ReadableVector2f)new Vector2f((ReadableVector2f)lead));
                float aimAngle = MathUtils.getShortestRotation((float)this.ship.getFacing(), (float)VectorUtils.getAngle((Vector2f)shipLoc, (Vector2f)lead));
                int Thrust = 0;
                int Turn = 0;
                int Strafe = 0;
                float angularVel = this.ship.getAngularVelocity();
                float angularAcc = this.ship.getMutableStats().getTurnAcceleration().getModifiedValue();
                if (angularAcc != 0.0f) {
                    float TTS = Math.abs(angularVel) / angularAcc;
                    if (Math.abs(aimAngle) < 1.0f) {
                        if (aimAngle < 0.0f) {
                            int n = Turn = aimAngle + 0.5f * angularVel * TTS < 0.0f ? 1 : -1;
                        }
                        if (aimAngle > 0.0f) {
                            Turn = aimAngle + 0.5f * angularVel * TTS > 0.0f ? -1 : 1;
                        }
                    } else {
                        Turn = (int)Math.signum(-aimAngle);
                        if (Math.abs(angularVel) < angularAcc * 0.1f) {
                            Turn = 0;
                            this.ship.setAngularVelocity(angularVel * 0.1f);
                        }
                    }
                }
                Vector2f absMVDev = Vector2f.sub((Vector2f)((Vector2f)VectorUtils.getDirectionalVector((Vector2f)shipLoc, (Vector2f)lead).scale(this.bombingSpeed)), (Vector2f)this.ship.getVelocity(), null);
                Vector2f relMVDev = VectorUtils.rotate((Vector2f)absMVDev, (float)(-this.ship.getFacing()), (Vector2f)new Vector2f());
                if (relMVDev.y > 5.0f) {
                    Strafe = 1;
                }
                if (relMVDev.y < -5.0f) {
                    Strafe = -1;
                }
                if (this.alwaysAcc) {
                    Thrust = 1;
                } else {
                    if (relMVDev.x > 5.0f) {
                        Thrust = 1;
                    }
                    if (relMVDev.x < -5.0f) {
                        Thrust = -1;
                    }
                }
                if (Thrust == 1) {
                    this.ship.giveCommand(ShipCommand.ACCELERATE, (Object)lead, 0);
                }
                if (Thrust == -1) {
                    this.ship.giveCommand(ShipCommand.ACCELERATE_BACKWARDS, (Object)lead, 0);
                }
                if (Turn == 1) {
                    this.ship.giveCommand(ShipCommand.TURN_RIGHT, (Object)lead, 0);
                }
                if (Turn == -1) {
                    this.ship.giveCommand(ShipCommand.TURN_LEFT, (Object)lead, 0);
                }
                if (Strafe == 1) {
                    this.ship.giveCommand(ShipCommand.STRAFE_LEFT, (Object)lead, 0);
                }
                if (Strafe == -1) {
                    this.ship.giveCommand(ShipCommand.STRAFE_RIGHT, (Object)lead, 0);
                }
                if (Math.abs(aimAngle) < 1.0f && Math.abs(relMVDev.y) < 5.0f && Misc.getDistance((Vector2f)shipLoc, (Vector2f)targetLoc) - Misc.getTargetingRadius((Vector2f)shipLoc, (CombatEntityAPI)target, (boolean)false) <= this.firingRange) {
                    this.isFiring = true;
                }
                if (this.isFiring) {
                    this.bombingTimer -= amount;
                    if (this.bombingTimer < 0.0f) {
                        this.bombingTimer = this.bombingTime;
                        this.isBombing = false;
                        this.isFiring = false;
                        this.ship.getShipAI().forceCircumstanceEvaluation();
                    }
                }
            }
        }
    }
}

