/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.AIs.ShipSystems;

import com.fs.starfarer.api.combat.BeamAPI;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.DamagingProjectileAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ShipSystemAIScript;
import com.fs.starfarer.api.combat.ShipSystemAPI;
import com.fs.starfarer.api.combat.ShipwideAIFlags;
import com.fs.starfarer.api.util.IntervalUtil;
import data.scripts.plugins.Neutrino_LocalData;
import java.util.List;
import org.lazywizard.lazylib.MathUtils;
import org.lazywizard.lazylib.combat.AIUtils;
import org.lwjgl.util.vector.Vector2f;

public class Neutrino_GuardianShieldAI
implements ShipSystemAIScript {
    private static final String KEY = "Neutrino_LocalData";
    CombatEngineAPI engine;
    private ShipAPI ship;
    private ShipAPI drone;
    private ShipSystemAPI system;
    private ShipwideAIFlags flags;
    private final IntervalUtil tracker = new IntervalUtil(0.3f, 0.5f);

    public void init(ShipAPI ship, ShipSystemAPI system, ShipwideAIFlags flags, CombatEngineAPI engine) {
        this.engine = engine;
        this.ship = ship;
        this.system = system;
        this.flags = flags;
    }

    public void advance(float amount, Vector2f missileDangerDir, Vector2f collisionDangerDir, ShipAPI target) {
        if (this.engine == null) {
            return;
        }
        if (this.engine.isPaused()) {
            return;
        }
        if (this.drone == null) {
            Neutrino_LocalData.LocalData localData = (Neutrino_LocalData.LocalData)this.engine.getCustomData().get(KEY);
            this.drone = localData.guardianShieldMap.get(this.ship);
            return;
        }
        if (!this.drone.isAlive() && this.ship.isAlive()) {
            return;
        }
        this.tracker.advance(amount);
        if (this.tracker.intervalElapsed()) {
            boolean shipInDanger;
            boolean bl = shipInDanger = this.ship.getHullLevel() < 0.15f;
            if (this.drone.getFluxTracker().getFluxLevel() > 0.96f && !shipInDanger) {
                this.systemOff();
                return;
            }
            List allies = AIUtils.getNearbyAllies((CombatEntityAPI)this.ship, (float)1500.0f);
            for (ShipAPI ally : allies) {
                if (ally.getAIFlags() == null || !ally.getAIFlags().hasFlag(ShipwideAIFlags.AIFlags.HAS_INCOMING_DAMAGE) && !ally.getAIFlags().hasFlag(ShipwideAIFlags.AIFlags.NEEDS_HELP)) continue;
                this.systemOn();
                return;
            }
            List enemies = AIUtils.getNearbyEnemies((CombatEntityAPI)this.ship, (float)2000.0f);
            for (ShipAPI enemy : enemies) {
                if (enemy.getAIFlags() != null && enemy.getAIFlags().hasFlag(ShipwideAIFlags.AIFlags.NEEDS_HELP) || enemy.isRetreating()) continue;
                this.systemOn();
                return;
            }
            List projectiles = this.engine.getProjectiles();
            for (DamagingProjectileAPI proj : projectiles) {
                if (proj.getOwner() == this.ship.getOwner() || !(MathUtils.getDistance((CombatEntityAPI)this.ship, (CombatEntityAPI)proj) > 1500.0f)) continue;
                this.systemOn();
                return;
            }
            List beams = this.engine.getBeams();
            for (BeamAPI beam : beams) {
                if (beam.getSource().getOwner() == this.ship.getOwner() || !MathUtils.isWithinRange((CombatEntityAPI)this.ship, (Vector2f)beam.getTo(), (float)1500.0f)) continue;
                this.systemOn();
                return;
            }
            this.systemOff();
        }
    }

    private void systemOn() {
        if (AIUtils.canUseSystemThisFrame((ShipAPI)this.ship) && !this.system.isOn()) {
            this.ship.useSystem();
        }
    }

    private void systemOff() {
        if (this.system.isOn()) {
            this.ship.useSystem();
        }
    }
}

