/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.AIs.ShipSystems;

import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ShipSystemAIScript;
import com.fs.starfarer.api.combat.ShipSystemAPI;
import com.fs.starfarer.api.combat.ShipwideAIFlags;
import com.fs.starfarer.api.combat.WeaponAPI;
import com.fs.starfarer.api.util.IntervalUtil;
import java.util.List;
import org.lazywizard.lazylib.MathUtils;
import org.lazywizard.lazylib.VectorUtils;
import org.lazywizard.lazylib.combat.AIUtils;
import org.lwjgl.util.vector.Vector2f;

public class Neutrino_PhaseMissileSystemAI
implements ShipSystemAIScript {
    private ShipAPI ship;
    private CombatEngineAPI engine;
    private ShipSystemAPI system;
    private final IntervalUtil tracker = new IntervalUtil(0.3f, 0.5f);
    private float dmg = 0.0f;
    private float maxFiringRange = 2250.0f;
    private static final float minFiringRange = 0.0f;
    private static final float selfFluxThreshold = 0.5f;
    private static final float selfFluxMaxThreshold = 0.9f;

    public void init(ShipAPI ship, ShipSystemAPI system, ShipwideAIFlags flags, CombatEngineAPI engine) {
        this.ship = ship;
        this.engine = engine;
        this.system = system;
        List weapons = ship.getAllWeapons();
        if (!weapons.isEmpty()) {
            for (WeaponAPI weapon : weapons) {
                if (weapon.getType() != WeaponAPI.WeaponType.SYSTEM) continue;
                this.maxFiringRange = weapon.getRange() * 0.9f;
                this.dmg += 1625.0f * (ship.getMutableStats().getMissileWeaponDamageMult().getModifiedValue() + 1.0f);
            }
        }
    }

    public void advance(float amount, Vector2f missileDangerDir, Vector2f collisionDangerDir, ShipAPI target) {
        if (this.engine == null) {
            return;
        }
        if (this.engine.isPaused()) {
            return;
        }
        this.tracker.advance(amount);
        if (this.tracker.intervalElapsed()) {
            float fluxFractionPerUse;
            float fluxLevel;
            float fluxLevelAfterUse;
            boolean targetIsVulnerable;
            if (!AIUtils.canUseSystemThisFrame((ShipAPI)this.ship)) {
                return;
            }
            if (target == null || !target.isAlive() || target.isFighter() || target.isDrone() || target == this.ship || target.getOwner() == this.ship.getOwner() || target.getPhaseCloak() != null && target.getPhaseCloak().isActive()) {
                return;
            }
            float targetDistance = MathUtils.getDistance((CombatEntityAPI)this.ship, (CombatEntityAPI)target);
            if (targetDistance > this.maxFiringRange) {
                return;
            }
            float absTargetDirection = Math.abs(MathUtils.getShortestRotation((float)this.ship.getFacing(), (float)VectorUtils.getAngle((Vector2f)this.ship.getLocation(), (Vector2f)target.getLocation())));
            if (absTargetDirection > 90.0f) {
                return;
            }
            boolean bl = targetIsVulnerable = target.getFluxTracker().isOverloadedOrVenting() && (target.getFluxTracker().getOverloadTimeRemaining() > 5.0f || target.getFluxTracker().getTimeToVent() > 5.0f);
            if (!targetIsVulnerable && targetDistance < 0.0f) {
                return;
            }
            float fluxThreshold = 0.5f;
            if (targetIsVulnerable) {
                fluxThreshold = 0.9f;
            }
            if ((fluxLevelAfterUse = (fluxLevel = this.ship.getFluxTracker().getFluxLevel()) + (fluxFractionPerUse = this.system.getFluxPerUse() / this.ship.getFluxTracker().getMaxFlux())) > fluxThreshold) {
                return;
            }
            int ammo = this.system.getAmmo();
            if (ammo == 3) {
                this.ship.useSystem();
                this.ship.getAIFlags().setFlag(ShipwideAIFlags.AIFlags.DO_NOT_VENT);
                return;
            }
            if (ammo == 2 && Math.random() < 0.1) {
                this.ship.useSystem();
                this.ship.getAIFlags().setFlag(ShipwideAIFlags.AIFlags.DO_NOT_VENT);
                return;
            }
            if (targetIsVulnerable || target.getShield() == null && target.getHitpoints() < 2.0f * this.dmg) {
                this.ship.useSystem();
                this.ship.getAIFlags().setFlag(ShipwideAIFlags.AIFlags.DO_NOT_VENT);
            }
        }
    }
}

