/*
 * Decompiled with CFR 0.152.
 */
package data.scripts;

import com.fs.starfarer.api.BaseModPlugin;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.PluginPick;
import com.fs.starfarer.api.campaign.CampaignPlugin;
import com.fs.starfarer.api.combat.AutofireAIPlugin;
import com.fs.starfarer.api.combat.DroneLauncherShipSystemAPI;
import com.fs.starfarer.api.combat.MissileAIPlugin;
import com.fs.starfarer.api.combat.MissileAPI;
import com.fs.starfarer.api.combat.ShipAIPlugin;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.WeaponAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.impl.campaign.shared.SharedData;
import data.scripts.AIs.Missiles.Neutrino_AdvancedTorpedoAI;
import data.scripts.AIs.Missiles.Neutrino_JavelinTorpedoAI;
import data.scripts.AIs.Missiles.Neutrino_PhotonTorpedoAI;
import data.scripts.AIs.Missiles.Neutrino_UnstablePhotonAI;
import data.scripts.AIs.Ships.Neutrino_NoAI;
import data.scripts.world.neutrinoGen;
import data.scripts.world.neutrinoGenAfterProgen;
import exerelin.campaign.SectorManager;
import org.dark.shaders.light.LightData;
import org.dark.shaders.util.ShaderLib;

public class NCModPlugin
extends BaseModPlugin {
    private static final String neutrino_advancedtorpedo_ID = "neutrino_advancedtorpedocase";
    private static final String neutrino_photon_torpedo_ID = "neutrino_photon_torpedo";
    private static final String neutrino_lightphoton_torpedo_ID = "neutrino_lightphoton_torpedo";
    private static final String neutrino_javelintorpedo_ID = "neutrino_javelintorpedo";
    private static final String neutrino_unstable_photon_ID = "neutrino_unstable_photon";
    private static final String neutrino_split_photon1_ID = "neutrino_split_photon1";
    private static final String neutrino_split_photon2_ID = "neutrino_split_photon2";
    private static final String neutrino_split_final_ID = "neutrino_split_final";
    private static final String neutrino_photongun_ID = "neutrino_photongun";
    private static final String neutrino_guardianshield_ID = "neutrino_guardianshield";
    private static final String neutrino_adv_torpedo_payload1_ID = "neutrino_adv_torpedo_payload1";
    private static final String neutrino_adv_torpedo_payload2_ID = "neutrino_adv_torpedo_payload2";
    private static final String neutrino_adv_torpedo_payload3_ID = "neutrino_adv_torpedo_payload3";
    public static boolean SSPExists = false;
    public static boolean TemplarsExists = false;
    public static boolean ExerlinExists = false;

    public void onApplicationLoad() {
        try {
            Global.getSettings().getScriptClassLoader().loadClass("org.dark.shaders.util.ShaderLib");
        }
        catch (ClassNotFoundException ex) {
            return;
        }
        try {
            Global.getSettings().getScriptClassLoader().loadClass("data.scripts.TEMModPlugin");
            TemplarsExists = true;
        }
        catch (ClassNotFoundException ex) {
            // empty catch block
        }
        try {
            Global.getSettings().getScriptClassLoader().loadClass("data.scripts.SSPModPlugin");
            SSPExists = true;
        }
        catch (ClassNotFoundException ex) {
            // empty catch block
        }
        try {
            Global.getSettings().getScriptClassLoader().loadClass("exerelin.campaign.SectorManager");
            ExerlinExists = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        ShaderLib.init();
        LightData.readLightDataCSV((String)"data/lights/neutrino_bling.csv");
    }

    public PluginPick<MissileAIPlugin> pickMissileAI(MissileAPI missile, ShipAPI launchingShip) {
        switch (missile.getProjectileSpecId()) {
            case "neutrino_advancedtorpedocase": {
                return new PluginPick((Object)new Neutrino_AdvancedTorpedoAI(missile, launchingShip), CampaignPlugin.PickPriority.MOD_SPECIFIC);
            }
            case "neutrino_lightphoton_torpedo": 
            case "neutrino_photon_torpedo": 
            case "neutrino_photongun": {
                return new PluginPick((Object)new Neutrino_PhotonTorpedoAI(missile, launchingShip), CampaignPlugin.PickPriority.MOD_SPECIFIC);
            }
            case "neutrino_javelintorpedo": {
                if (launchingShip == null || !launchingShip.getVariant().getHullMods().contains("eccm")) break;
                return new PluginPick((Object)new Neutrino_JavelinTorpedoAI(missile, launchingShip), CampaignPlugin.PickPriority.MOD_SPECIFIC);
            }
            case "neutrino_unstable_photon": 
            case "neutrino_split_photon1": 
            case "neutrino_split_photon2": 
            case "neutrino_split_final": 
            case "neutrino_adv_torpedo_payload1": 
            case "neutrino_adv_torpedo_payload2": 
            case "neutrino_adv_torpedo_payload3": {
                return new PluginPick((Object)new Neutrino_UnstablePhotonAI(missile, launchingShip), CampaignPlugin.PickPriority.MOD_SPECIFIC);
            }
        }
        return null;
    }

    public PluginPick<ShipAIPlugin> pickShipAI(FleetMemberAPI member, ShipAPI ship) {
        switch (ship.getHullSpec().getHullId()) {
            case "neutrino_guardianshield": {
                return new PluginPick((Object)new Neutrino_NoAI(), CampaignPlugin.PickPriority.MOD_SPECIFIC);
            }
        }
        return null;
    }

    public PluginPick<AutofireAIPlugin> pickWeaponAutofireAI(WeaponAPI weapon) {
        return null;
    }

    public PluginPick<ShipAIPlugin> pickDroneAI(ShipAPI drone, ShipAPI mothership, DroneLauncherShipSystemAPI system) {
        String id = drone.getHullSpec().getHullId();
        if (id.equals("neutrino_aegis")) {
            return new PluginPick((Object)new Neutrino_NoAI(), CampaignPlugin.PickPriority.MOD_SPECIFIC);
        }
        return null;
    }

    public void onNewGame() {
        boolean haveNexerelin = Global.getSettings().getModManager().isModEnabled("nexerelin");
        if (!haveNexerelin || SectorManager.getCorvusMode()) {
            new neutrinoGen().generate(Global.getSector());
        }
        SharedData.getData().getPersonBountyEventData().addParticipatingFaction("neutrinocorp");
    }

    public void onNewGameAfterProcGen() {
        boolean haveNexerelin = Global.getSettings().getModManager().isModEnabled("nexerelin");
        if (!haveNexerelin || SectorManager.getCorvusMode()) {
            new neutrinoGenAfterProgen().generate(Global.getSector());
        }
    }
}

