/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.campaign.submarkets;

import com.fs.starfarer.api.EveryFrameScript;
import com.fs.starfarer.api.GameState;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.Script;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.CargoStackAPI;
import com.fs.starfarer.api.campaign.CoreUIAPI;
import com.fs.starfarer.api.campaign.RepLevel;
import com.fs.starfarer.api.campaign.SubmarketPlugin;
import com.fs.starfarer.api.campaign.econ.SubmarketAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.fleet.FleetMemberType;
import com.fs.starfarer.api.impl.campaign.submarkets.BaseSubmarketPlugin;
import com.fs.starfarer.api.util.Highlights;
import com.fs.starfarer.api.util.IntervalUtil;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import java.util.List;

public class Neutrino_AbandonShipyard
extends BaseSubmarketPlugin {
    private boolean playerPaidToUnlock = false;

    public String getBuyVerb() {
        return "Retrieve";
    }

    public SubmarketPlugin.DialogOption[] getDialogOptions(CoreUIAPI ui) {
        if (this.canPlayerAccess() && this.canPlayerAffordUnlock()) {
            return new SubmarketPlugin.DialogOption[]{new SubmarketPlugin.DialogOption("Access", new Script(){

                public void run() {
                    CampaignFleetAPI playerFleet = Global.getSector().getPlayerFleet();
                    playerFleet.getCargo().removeSupplies((float)Neutrino_AbandonShipyard.this.getUnlockCost());
                    Neutrino_AbandonShipyard.this.playerPaidToUnlock = true;
                    Global.getSector().addScript((EveryFrameScript)new BuildUnsung(Neutrino_AbandonShipyard.this.submarket));
                }
            }), new SubmarketPlugin.DialogOption("Leave", null)};
        }
        return new SubmarketPlugin.DialogOption[]{new SubmarketPlugin.DialogOption("Leave", null)};
    }

    public String getDialogText(CoreUIAPI ui) {
        if (this.canPlayerAccess()) {
            if (this.canPlayerAffordUnlock()) {
                return "After a quick scan you find the abandoned Neutrino autonomous shipyard is still functional. You connect it using Neutrino secure-comms and it reports a unique one-run UAC is already installed and that a ship is already under construction. The progress is 98% but requires " + this.getUnlockCost() + " more supplies and " + this.getBuildTime() + " days to finish.";
            }
            return "After a quick scan you find the abandoned Neutrino autonomous shipyard is still functional. You connect it using Neutrino secure-comms and it reports a unique one-run UAC is already installed and that a ship is already under construction. The progress is 98% but requires " + this.getUnlockCost() + " more supplies and " + this.getBuildTime() + " days to finish. But you don't have enough supplies yet.";
        }
        return "After a quick scan you find the abandoned Neutrino autonomous shipyard is still functional and a large unidentified ship is nearing completion. The station is requesting a Neutrino secure-comm to connect with of which you do not possess.";
    }

    public Highlights getDialogTextHighlights(CoreUIAPI ui) {
        Highlights h = new Highlights();
        h.setText(new String[]{"" + this.getUnlockCost()});
        if (this.canPlayerAffordUnlock()) {
            h.setColors(new Color[]{Misc.getHighlightColor()});
        } else {
            h.setColors(new Color[]{Misc.getNegativeHighlightColor()});
        }
        return h;
    }

    public String getIllegalTransferText(CargoStackAPI stack, SubmarketPlugin.TransferAction action) {
        return "";
    }

    public SubmarketPlugin.OnClickAction getOnClickAction(CoreUIAPI ui) {
        if (this.playerPaidToUnlock) {
            return SubmarketPlugin.OnClickAction.OPEN_SUBMARKET;
        }
        if (Neutrino_AbandonShipyard.checkData()) {
            this.playerPaidToUnlock = true;
            return SubmarketPlugin.OnClickAction.OPEN_SUBMARKET;
        }
        return SubmarketPlugin.OnClickAction.SHOW_TEXT_DIALOG;
    }

    public String getSellVerb() {
        return "Leave";
    }

    public float getTariff() {
        return 0.0f;
    }

    public String getTooltipAppendix(CoreUIAPI ui) {
        return null;
    }

    public Highlights getTooltipAppendixHighlights(CoreUIAPI ui) {
        return null;
    }

    public void init(SubmarketAPI submarket) {
        super.init(submarket);
        Global.getSector().addScript((EveryFrameScript)new CheckUnsung(submarket));
    }

    public boolean isEnabled(CoreUIAPI ui) {
        return true;
    }

    public boolean isFreeTransfer() {
        return true;
    }

    public void setPlayerPaidToUnlock(boolean playerPaidToUnlock) {
        this.playerPaidToUnlock = playerPaidToUnlock;
    }

    public boolean isIllegalOnSubmarket(CargoStackAPI stack, SubmarketPlugin.TransferAction action) {
        return action == SubmarketPlugin.TransferAction.PLAYER_SELL;
    }

    public boolean isIllegalOnSubmarket(String commodityId, SubmarketPlugin.TransferAction action) {
        return action == SubmarketPlugin.TransferAction.PLAYER_SELL;
    }

    public boolean isIllegalOnSubmarket(FleetMemberAPI member, SubmarketPlugin.TransferAction action) {
        return action == SubmarketPlugin.TransferAction.PLAYER_SELL;
    }

    public boolean isParticipatesInEconomy() {
        return false;
    }

    public void updateCargoPrePlayerInteraction() {
    }

    private boolean canPlayerAffordUnlock() {
        CampaignFleetAPI playerFleet = Global.getSector().getPlayerFleet();
        int supplies = (int)playerFleet.getCargo().getSupplies();
        return supplies >= this.getUnlockCost();
    }

    private boolean canPlayerAccess() {
        return Global.getSector().getFaction("neutrinocorp").getRelationshipLevel("player") == RepLevel.COOPERATIVE;
    }

    private int getUnlockCost() {
        return 4000;
    }

    private int getBuildTime() {
        return 30;
    }

    private static boolean checkData() {
        Object Unsung_builded = Global.getSector().getPersistentData().get("Unsung_builded");
        if (Unsung_builded == null) {
            Global.getSector().getPersistentData().put("Unsung_builded", false);
            return false;
        }
        return (Boolean)Unsung_builded;
    }

    private static void setData(boolean builded) {
        Global.getSector().getPersistentData().put("Unsung_builded", builded);
    }

    private static class CheckUnsung
    implements EveryFrameScript {
        IntervalUtil interval = new IntervalUtil(1.0f, 1.0f);
        SubmarketAPI submarket;

        CheckUnsung(SubmarketAPI submarket) {
            this.submarket = submarket;
        }

        public void advance(float amount) {
            GameState gameState = Global.getCurrentState();
            Global.getCurrentState();
            if (gameState.equals((Object)GameState.COMBAT)) {
                return;
            }
            this.interval.advance(amount);
            if (this.interval.intervalElapsed()) {
                CampaignFleetAPI playerFleet = Global.getSector().getPlayerFleet();
                List members = playerFleet.getFleetData().getMembersListCopy();
                for (FleetMemberAPI member : members) {
                    if (!member.getHullId().contentEquals("neutrino_unsung")) continue;
                    Neutrino_AbandonShipyard.setData(true);
                }
            }
        }

        public boolean isDone() {
            return Neutrino_AbandonShipyard.checkData();
        }

        public boolean runWhilePaused() {
            return true;
        }
    }

    private static class BuildUnsung
    implements EveryFrameScript {
        protected float buildTimer = 30.0f;
        SubmarketAPI submarket;

        BuildUnsung(SubmarketAPI submarket) {
            this.submarket = submarket;
        }

        public void advance(float amount) {
            float days = Global.getSector().getClock().convertToDays(amount);
            this.buildTimer -= days;
            if (this.buildTimer <= 0.0f) {
                this.buildTimer = 0.0f;
                this.submarket.getCargo().addMothballedShip(FleetMemberType.SHIP, "neutrino_unsung_Hull", null);
                this.submarket.getCargo().addWeapons("neutrino_phasedarray", 2);
                Neutrino_AbandonShipyard.setData(true);
                Global.getSector().getCampaignUI().addMessage("You got a fading signal through Neutrino secure-comm that inform you your build is complete.");
            }
        }

        public boolean isDone() {
            return Neutrino_AbandonShipyard.checkData();
        }

        public boolean runWhilePaused() {
            return false;
        }
    }
}

