/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.plugins;

import com.fs.graphics.anim.Animation;
import com.fs.graphics.particle.BaseParticle;
import com.fs.graphics.particle.DynamicParticleGroup;
import com.fs.graphics.particle.GenericTextureParticle;
import com.fs.graphics.particle.SmoothParticle;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.BaseEveryFrameCombatPlugin;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.ViewportAPI;
import com.fs.starfarer.combat.CombatEngine;
import com.fs.starfarer.renderers.fx.DetailedSmokeParticle;
import java.awt.Color;
import org.lwjgl.util.vector.Vector2f;

public class ExtraParticlePlugin
extends BaseEveryFrameCombatPlugin {
    public static DynamicParticleGroup ExtraParticleGroup = new DynamicParticleGroup(1000000);
    private static final float offScreenDist = 200.0f;

    public void init(CombatEngineAPI engine) {
        CombatEngine e = (CombatEngine)engine;
        e.addAnimation((Animation)ExtraParticleGroup);
    }

    public void renderInWorldCoords(ViewportAPI viewport) {
        ExtraParticleGroup.render(0.0f, 0.0f);
    }

    public static void addExtraHitParticle(Vector2f loc, Vector2f vel, float size, float brightness, float duration, Color color) {
        if (!Global.getCombatEngine().getViewport().isNearViewport(loc, 200.0f)) {
            return;
        }
        GenericTextureParticle generictextureparticle = new GenericTextureParticle("graphics/fx/hit_glow.png", new Color(color.getRed(), color.getGreen(), color.getBlue(), (int)(brightness * 255.0f)), size, size, 0.0f);
        generictextureparticle.setBlendFunc(770, 1);
        generictextureparticle.setPos(loc.x, loc.y);
        generictextureparticle.setVel(vel.x, vel.y);
        generictextureparticle.setMaxAge(duration);
        ExtraParticleGroup.add((BaseParticle)generictextureparticle);
    }

    public static void addExtraSmoothParticle(Vector2f loc, Vector2f vel, float size, float brightness, float duration, Color color) {
        if (!Global.getCombatEngine().getViewport().isNearViewport(loc, 200.0f)) {
            return;
        }
        SmoothParticle smoothparticle = new SmoothParticle(color, size);
        smoothparticle.setMaxAge(duration);
        smoothparticle.setPos(loc.x, loc.y);
        smoothparticle.setVel(vel.x, vel.y);
        ExtraParticleGroup.add((BaseParticle)smoothparticle);
    }

    public static void addExtraSmokeParticle(Vector2f loc, Vector2f vel, float size, float opacity, float duration, Color color) {
        if (!Global.getCombatEngine().getViewport().isNearViewport(loc, 200.0f)) {
            return;
        }
        DetailedSmokeParticle detailedsmokeparticle = new DetailedSmokeParticle(color, size, size * 1.25f);
        detailedsmokeparticle.setAngle((float)Math.random() * 360.0f);
        detailedsmokeparticle.setRotationSpeed((float)Math.random() * 140.0f - 70.0f);
        detailedsmokeparticle.setMaxAge(duration);
        detailedsmokeparticle.setPos(loc.x, loc.y);
        detailedsmokeparticle.setVel(vel.x, vel.y);
        detailedsmokeparticle.setRampUpPeriod(0.5f * (float)Math.random());
        ExtraParticleGroup.add((BaseParticle)detailedsmokeparticle);
    }
}

