/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.plugins;

import com.fs.starfarer.api.GameState;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.ArmorGridAPI;
import com.fs.starfarer.api.combat.BaseEveryFrameCombatPlugin;
import com.fs.starfarer.api.combat.BeamAPI;
import com.fs.starfarer.api.combat.CollisionClass;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.DamageType;
import com.fs.starfarer.api.combat.DamagingProjectileAPI;
import com.fs.starfarer.api.combat.MissileAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ShipSystemAPI;
import com.fs.starfarer.api.combat.ViewportAPI;
import com.fs.starfarer.api.input.InputEventAPI;
import com.fs.starfarer.api.mission.FleetSide;
import com.fs.starfarer.api.util.IntervalUtil;
import com.fs.starfarer.combat.entities.MovingRay;
import data.hullmods.NeutrinoNeutroniumPlating;
import data.scripts.plugins.Neutrino_ExtraParticlePlugin;
import data.scripts.plugins.Neutrino_LocalData;
import data.scripts.util.Neutrino_CollisionUtilsEX;
import data.scripts.weapons.NeutAntiPhotonBeamEffect;
import java.awt.Color;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.dark.shaders.distortion.DistortionAPI;
import org.dark.shaders.distortion.DistortionShader;
import org.dark.shaders.distortion.WaveDistortion;
import org.dark.shaders.light.LightAPI;
import org.dark.shaders.light.LightShader;
import org.dark.shaders.light.StandardLight;
import org.lazywizard.lazylib.MathUtils;
import org.lazywizard.lazylib.combat.entities.AnchoredEntity;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class Neutrino_EveryFrameCombatPlugin
extends BaseEveryFrameCombatPlugin {
    private CombatEngineAPI engine;
    private final Vector2f zero = new Vector2f(0.0f, 0.0f);
    private static final String KEY = "Neutrino_LocalData";
    private static boolean paused = false;
    private static final float phaseFadeTime = 2.0f;
    private final IntervalUtil flashInterval = new IntervalUtil(0.1f, 0.1f);
    private static final String neutrino_phase_missile_ID = "neutrino_phase_missile";
    private static final String neutrino_super_phase_missile_ID = "neutrino_super_phase_missile";
    private static final String neutrino_phase_missile_payload_ID = "neutrino_phase_missile2";
    private static final String neutrino_sapper_missile_ID = "neutrino_sapper_missile";
    private static final String neutrino_heavypulsar_shot_ID = "neutrino_heavypulsar_shot";
    private static final String neutrino_pulsar_shot_ID = "neutrino_pulsar_shot";
    private static final String neutrino_magnetar_shot_ID = "neutrino_magnetar_shot";
    private static final String neutrino_quasar_shot_ID = "neutrino_quasar_shot";
    private static final String neutrino_guardianshield_ID = "neutrino_guardianshield";
    private static final String neutrino_aegis_ID = "neutrino_aegis";
    private static final String neutrino_colossus_ID = "neutrino_colossus";
    private Map<DamagingProjectileAPI, Vector2f> neutrino_pulsar_shot_relative_velocity;
    private Map<DamagingProjectileAPI, Vector2f> neutrino_pulsar_shot_fading_loc;

    public void advance(float amount, List<InputEventAPI> events) {
        NeutrinoNeutroniumPlating.PowerAromr powerAromr;
        if (this.engine == null) {
            return;
        }
        Neutrino_LocalData.LocalData localData = (Neutrino_LocalData.LocalData)this.engine.getCustomData().get(KEY);
        ViewportAPI cv = this.engine.getViewport();
        if (!this.engine.isPaused()) {
            List projectiles;
            paused = false;
            List ships = this.engine.getShips();
            ArrayList<ShipAPI> toCheck = new ArrayList<ShipAPI>();
            if (!ships.isEmpty()) {
                for (ShipAPI ship : ships) {
                    switch (ship.getHullSpec().getHullId()) {
                        case "neutrino_colossus": {
                            Object shieldShip = localData.guardianShieldMap.get(ship);
                            if (shieldShip != null || ship.getChildModulesCopy().isEmpty()) break;
                            shieldShip = (ShipAPI)ship.getChildModulesCopy().get(0);
                            localData.guardianShieldMap.put(ship, (ShipAPI)shieldShip);
                            break;
                        }
                        case "neutrino_aegis": {
                            toCheck.add(ship);
                            if (ship.isHulk() || ship.getShield().isOff()) {
                                ship.setCollisionClass(CollisionClass.FIGHTER);
                                ship.setCollisionRadius(45.0f);
                                break;
                            }
                            if (!ship.getShield().isOn()) break;
                            ship.setCollisionRadius(200.0f);
                            break;
                        }
                        case "neutrino_guardianshield": {
                            toCheck.add(ship);
                            if (ship.isHulk() || ship.getShield().isOff()) {
                                ship.setCollisionClass(CollisionClass.FIGHTER);
                                ship.setCollisionRadius(45.0f);
                            } else if (ship.getShield().isOn()) {
                                ship.setCollisionRadius(1500.0f);
                            }
                            if (!ship.getFluxTracker().isOverloaded() || !(Math.random() < 0.1)) break;
                            this.engine.applyDamage((CombatEntityAPI)ship, ship.getLocation(), MathUtils.getRandomNumberInRange((float)0.0f, (float)100.0f), DamageType.ENERGY, 0.0f, true, true, (Object)ship);
                        }
                    }
                }
            }
            if (!localData.guardianShieldMap.isEmpty()) {
                for (ShipAPI mothership : localData.guardianShieldMap.keySet()) {
                    ShipAPI drone = localData.guardianShieldMap.get(mothership);
                    ShipSystemAPI system = mothership.getSystem();
                    if (mothership.isAlive() && drone.isAlive()) {
                        if (system.isOn()) {
                            drone.getShield().toggleOn();
                        } else {
                            drone.getShield().toggleOff();
                        }
                        drone.setShipTarget(mothership.getShipTarget());
                        drone.getLocation().set((ReadableVector2f)mothership.getLocation());
                        drone.setFacing(mothership.getFacing());
                        continue;
                    }
                    if (mothership.isAlive() || !drone.isAlive()) continue;
                    this.engine.applyDamage((CombatEntityAPI)drone, drone.getLocation(), drone.getMaxHitpoints() * 2.0f, DamageType.OTHER, 0.0f, true, true, (Object)drone);
                }
            }
            if (!(projectiles = this.engine.getProjectiles()).isEmpty()) {
                for (DamagingProjectileAPI proj : projectiles) {
                    if (proj.didDamage() && proj.getCollisionClass() != CollisionClass.NONE && proj.getDamageTarget() instanceof ShipAPI && toCheck.contains(proj.getDamageTarget())) {
                        this.engine.removeEntity((CombatEntityAPI)proj);
                        continue;
                    }
                    String projSpecId = proj.getProjectileSpecId();
                    this.flashInterval.advance(amount);
                    if (projSpecId != null) {
                        switch (projSpecId) {
                            case "neutrino_phase_missile": 
                            case "neutrino_phase_missile2": 
                            case "neutrino_super_phase_missile": {
                                this.phaseMissileEffect(proj, amount);
                                break;
                            }
                            case "neutrino_sapper_missile": {
                                Vector2f vel = proj.getVelocity();
                                if (vel.equals((Object)this.zero)) break;
                                vel.normalise(vel);
                                float mod = Math.max(50.0f + proj.getSource().getMutableStats().getMissileMaxSpeedBonus().computeEffective(700.0f) - proj.getSource().getMutableStats().getMissileMaxSpeedBonus().computeEffective(300.0f) * proj.getElapsed(), 50.0f);
                                vel.scale(mod);
                                break;
                            }
                            case "neutrino_heavypulsar_shot": 
                            case "neutrino_pulsar_shot": 
                            case "neutrino_magnetar_shot": 
                            case "neutrino_quasar_shot": {
                                Vector2f random;
                                float particlesPerSec;
                                Vector2f VVel;
                                if (proj.didDamage()) break;
                                MovingRay m = (MovingRay)proj;
                                if (proj.isFading()) {
                                    // empty if block
                                }
                                if (this.neutrino_pulsar_shot_relative_velocity.containsKey(proj)) {
                                    VVel = this.neutrino_pulsar_shot_relative_velocity.get(proj);
                                } else {
                                    VVel = MathUtils.getPointOnCircumference(null, (float)1.0f, (float)(proj.getFacing() + 90.0f));
                                    VVel.scale(Vector2f.dot((Vector2f)proj.getVelocity(), (Vector2f)VVel));
                                    this.neutrino_pulsar_shot_relative_velocity.put(proj, VVel);
                                }
                                float speed = proj.getVelocity().length();
                                float bright = Math.min(proj.getDamageAmount() / proj.getBaseDamageAmount(), 1.0f);
                                if (projSpecId.equals(neutrino_magnetar_shot_ID)) {
                                    particlesPerSec = 200.0f * amount;
                                    while (Math.random() < (double)particlesPerSec) {
                                        random = MathUtils.getRandomPointOnLine((Vector2f)m.getFrom(), (Vector2f)m.getTo());
                                        Neutrino_ExtraParticlePlugin.AddParticlesEx(1, 1, true, random, 0.0f, proj.getFacing(), 10.0f, VVel, 0.0f, speed * 0.03f, 1, 2, bright, bright, 0.4f, 0.6f, new Color(1.0f, 1.0f, 1.0f, bright));
                                        particlesPerSec -= 1.0f;
                                    }
                                } else if (projSpecId.equals(neutrino_pulsar_shot_ID)) {
                                    particlesPerSec = 1500.0f * amount;
                                    while (Math.random() < (double)particlesPerSec) {
                                        random = MathUtils.getRandomPointOnLine((Vector2f)m.getFrom(), (Vector2f)m.getTo());
                                        Neutrino_ExtraParticlePlugin.AddParticlesEx(1, 1, true, random, 1.0f, proj.getFacing(), 10.0f, VVel, 0.0f, speed * 0.03f, 2, 3, bright, bright, 0.5f, 0.8f, new Color(1.0f, 1.0f, 1.0f, bright));
                                        particlesPerSec -= 1.0f;
                                    }
                                } else {
                                    particlesPerSec = 3000.0f * amount;
                                    while (Math.random() < (double)particlesPerSec) {
                                        random = MathUtils.getRandomPointOnLine((Vector2f)m.getFrom(), (Vector2f)m.getTo());
                                        Neutrino_ExtraParticlePlugin.AddParticlesEx(1, 1, true, random, 2.0f, proj.getFacing(), 10.0f, VVel, 0.0f, speed * 0.03f, 3, 5, bright, bright, 0.5f, 0.8f, new Color(1.0f, 1.0f, 1.0f, bright));
                                        particlesPerSec -= 1.0f;
                                    }
                                }
                                break;
                            }
                        }
                    }
                }
            }
            List beams = this.engine.getBeams();
            if (!toCheck.isEmpty() && !beams.isEmpty()) {
                for (BeamAPI beam : beams) {
                    if (!(beam.getBrightness() > 0.0f)) continue;
                    Vector2f closest = null;
                    float closestDist = Float.MAX_VALUE;
                    for (ShipAPI shipToCheck : toCheck) {
                        if (beam.getSource().getOwner() == shipToCheck.getOwner()) continue;
                        Vector2f tmp = Neutrino_CollisionUtilsEX.getShipCollisionPoint(beam.getFrom(), beam.getTo(), shipToCheck);
                        if (closest == null) {
                            closest = tmp;
                            continue;
                        }
                        if (tmp == null || !(MathUtils.getDistance((Vector2f)tmp, (Vector2f)beam.getFrom()) < closestDist)) continue;
                        closest = tmp;
                        closestDist = MathUtils.getDistance((Vector2f)tmp, (Vector2f)beam.getFrom());
                    }
                    if (closest == null) continue;
                    beam.getTo().set(closest);
                }
            }
            for (BeamAPI beam : localData.antiPhotonAimData.keySet()) {
                NeutAntiPhotonBeamEffect.separatelyAimBeam SAB = localData.antiPhotonAimData.get(beam);
                float aimOffset = SAB.getCurrAimOffset();
                if (aimOffset != SAB.getTargetAimOffset()) {
                    float trun = SAB.getTurnRate() * amount;
                    float targetAimOffset = SAB.getTargetAimOffset();
                    float diff = aimOffset - targetAimOffset;
                    aimOffset = Math.abs(diff) < trun ? targetAimOffset : (aimOffset += Math.copySign(trun, -diff));
                    SAB.setCurrAimOffset(aimOffset);
                }
                beam.getTo().set((ReadableVector2f)MathUtils.getPointOnCircumference((Vector2f)beam.getFrom(), (float)MathUtils.getDistance((Vector2f)beam.getFrom(), (Vector2f)beam.getTo()), (float)(SAB.getWeapon().getCurrAngle() + aimOffset)));
            }
        } else if (this.engine.isPaused() && !paused && this.engine.getFleetManager(FleetSide.ENEMY).getTaskManager(false).isInFullRetreat()) {
            if (!localData.powerAromrState.isEmpty()) {
                for (ShipAPI ship : localData.powerAromrState.keySet()) {
                    int j;
                    int i;
                    ArmorGridAPI armorGrid = ship.getArmorGrid();
                    NeutrinoNeutroniumPlating.PowerAromr powerAromr2 = localData.powerAromrState.get(ship);
                    if (!powerAromr2.active) {
                        for (i = 0; i < powerAromr2.x; ++i) {
                            for (j = 0; j < powerAromr2.y; ++j) {
                                powerAromr2.armorValueWithoutPlating[i][j] = Math.min(armorGrid.getArmorValue(i, j), powerAromr2.maxArmorPerCell - powerAromr2.maxPowerArmorPerCell);
                            }
                        }
                    }
                    for (i = 0; i < powerAromr2.x; ++i) {
                        for (j = 0; j < powerAromr2.y; ++j) {
                            armorGrid.setArmorValue(i, j, Math.min(powerAromr2.maxArmorPerCell, Math.max(0.0f, powerAromr2.armorValueWithoutPlating[i][j]) + powerAromr2.maxPowerArmorPerCell));
                        }
                    }
                    powerAromr2.justPaused = true;
                }
            }
            paused = true;
        }
        ShipAPI playerShip = Global.getCombatEngine().getPlayerShip();
        if (Global.getCurrentState() == GameState.COMBAT && playerShip != null && !playerShip.isHulk() && (powerAromr = localData.powerAromrState.get(playerShip)) != null) {
            BigDecimal b;
            if (powerAromr.active) {
                float armorPercent = powerAromr.extarArmor / powerAromr.maxExtarArmor * 100.0f;
                b = new BigDecimal(armorPercent);
                String armorPercentS = b.setScale(1, RoundingMode.HALF_UP).toString();
                if ("100.0".equals(armorPercentS)) {
                    armorPercentS = "100";
                }
                String data = "integrity at " + armorPercentS + "%";
                this.engine.maintainStatusForPlayerShip((Object)"NeutroniumPlatingStatus1", "graphics/neut/icons/hullsys/neutrino_NeutroniumPlating_StatusIcon.png", "Neutronium Plating", data, false);
                if (playerShip.getFluxTracker().isVenting()) {
                    this.engine.maintainStatusForPlayerShip((Object)"NeutroniumPlatingStatus2", "graphics/neut/icons/hullsys/neutrino_NeutroniumPlating_StatusIcon.png", "Neutronium Plating", "Plating Resistance lowered due to venting", true);
                }
            } else {
                float timeRemain = (powerAromr.resetThreshold - powerAromr.extarArmor) / powerAromr.extarArmorRegenPerSec;
                b = new BigDecimal(timeRemain);
                String timeRemainS = b.setScale(2, RoundingMode.HALF_UP).toString();
                String data = "restore in " + timeRemainS + " seconds";
                this.engine.maintainStatusForPlayerShip((Object)"NeutroniumPlatingStatus1", "", "Neutronium Plating", data, true);
                if (playerShip.getFluxTracker().isOverloaded()) {
                    this.engine.maintainStatusForPlayerShip((Object)"NeutroniumPlatingStatus2", "", "Neutronium Plating", "plating collapsed due to overloaded", true);
                }
            }
        }
    }

    private void phaseMissileEffect(DamagingProjectileAPI proj, float amount) {
        float elapsed = proj.getElapsed();
        Vector2f loc = proj.getLocation();
        MissileAPI missile = (MissileAPI)proj;
        switch (proj.getProjectileSpecId()) {
            case "neutrino_phase_missile": 
            case "neutrino_super_phase_missile": {
                missile.getSpriteAPI().setAlphaMult(Math.min(elapsed * 0.02f, 0.1f));
                float maxFlightTime = missile.getMaxFlightTime();
                if (this.flashInterval.intervalElapsed()) {
                    Vector2f.add((Vector2f)loc, (Vector2f)MathUtils.getRandomPointInCircle(null, (float)5.0f), (Vector2f)loc);
                }
                if (elapsed < amount) {
                    float dis = proj.getSource().getCollisionRadius() + MathUtils.getRandomNumberInRange((float)50.0f, (float)200.0f);
                    Vector2f mov = MathUtils.getRandomPointOnCircumference(null, (float)dis);
                    Vector2f.add((Vector2f)loc, (Vector2f)mov, (Vector2f)loc);
                    WaveDistortion wave = new WaveDistortion();
                    wave.setLocation(loc);
                    wave.setIntensity(25.0f);
                    wave.setLifetime(0.5f);
                    wave.setSize(15.0f);
                    wave.fadeOutIntensity(0.25f);
                    DistortionShader.addDistortion((DistortionAPI)wave);
                    StandardLight light = new StandardLight();
                    light.setLocation(loc);
                    light.setColor(new Color(255, 175, 255, 50));
                    light.setSize(10.0f);
                    light.setIntensity(1.0f);
                    light.fadeOut(0.25f);
                    LightShader.addLight((LightAPI)light);
                }
                if (!(maxFlightTime - elapsed < 2.0f)) break;
                missile.getSpriteAPI().setAlphaMult(Math.min(Math.max(maxFlightTime - elapsed, 0.0f) / 2.0f * 0.1f, MathUtils.getRandomNumberInRange((float)0.0f, (float)0.1f)));
                break;
            }
            case "neutrino_phase_missile2": {
                if (elapsed < amount) {
                    Vector2f zero = new Vector2f();
                    WaveDistortion wave = new WaveDistortion();
                    wave.setLocation(loc);
                    wave.setIntensity(50.0f);
                    wave.setLifetime(0.5f);
                    wave.setSize(50.0f);
                    wave.fadeOutIntensity(0.25f);
                    DistortionShader.addDistortion((DistortionAPI)wave);
                    StandardLight light = new StandardLight();
                    light.attachTo((CombatEntityAPI)proj);
                    light.setLocation(loc);
                    light.setColor(new Color(255, 175, 255, 50));
                    light.setSize(30.0f);
                    light.setIntensity(0.2f);
                    light.fadeOut(0.3f);
                    LightShader.addLight((LightAPI)light);
                    Global.getSoundPlayer().playSound("system_phase_cloak_collision", 1.0f, 1.0f, loc, zero);
                    Global.getSoundPlayer().playSound("neutrino_lightlaunch", 0.5f, 0.5f, loc, zero);
                    Vector2f randomPoint = MathUtils.getRandomPointOnCircumference((Vector2f)loc, (float)5.0f);
                    AnchoredEntity anchor1 = new AnchoredEntity((CombatEntityAPI)proj, randomPoint);
                    this.engine.spawnEmpArc(proj.getSource(), loc, (CombatEntityAPI)anchor1, (CombatEntityAPI)anchor1, DamageType.ENERGY, 0.0f, 0.0f, 50.0f, null, 2.0f, new Color(51, 37, 51, 100), new Color(255, 0, 255, 0));
                }
                if (!(elapsed <= 1.0f)) break;
                missile.getSpriteAPI().setAlphaMult(elapsed);
                if (!this.flashInterval.intervalElapsed()) break;
                Vector2f randomPoint = MathUtils.getRandomPointOnCircumference((Vector2f)loc, (float)5.0f);
                AnchoredEntity anchor1 = new AnchoredEntity((CombatEntityAPI)proj, randomPoint);
                this.engine.spawnEmpArc(proj.getSource(), loc, (CombatEntityAPI)anchor1, (CombatEntityAPI)anchor1, DamageType.ENERGY, 0.0f, 0.0f, 50.0f, null, 2.0f, new Color(51, 37, 51, 100), new Color(255, 0, 255, 0));
            }
        }
    }

    public void init(CombatEngineAPI engine) {
        this.engine = engine;
        this.neutrino_pulsar_shot_relative_velocity = new WeakHashMap<DamagingProjectileAPI, Vector2f>(250);
        this.neutrino_pulsar_shot_fading_loc = new WeakHashMap<DamagingProjectileAPI, Vector2f>(250);
    }
}

