/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.plugins;

import com.fs.graphics.anim.Animation;
import com.fs.graphics.particle.BaseParticle;
import com.fs.graphics.particle.DynamicParticleGroup;
import com.fs.graphics.particle.GenericTextureParticle;
import com.fs.graphics.particle.SmoothParticle;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.BaseEveryFrameCombatPlugin;
import com.fs.starfarer.api.combat.BeamAPI;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.ViewportAPI;
import com.fs.starfarer.combat.CombatEngine;
import com.fs.starfarer.renderers.fx.DetailedSmokeParticle;
import java.awt.Color;
import org.dark.shaders.util.ShaderLib;
import org.lazywizard.lazylib.FastTrig;
import org.lazywizard.lazylib.MathUtils;
import org.lazywizard.lazylib.VectorUtils;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class Neutrino_ExtraParticlePlugin
extends BaseEveryFrameCombatPlugin {
    public static DynamicParticleGroup ExtraParticleGroup = new DynamicParticleGroup(100000);
    private static final Vector2f zero = new Vector2f(0.0f, 0.0f);
    private static final float offScreenDist = 200.0f;

    public void init(CombatEngineAPI engine) {
        CombatEngine e = (CombatEngine)engine;
        e.addAnimation((Animation)ExtraParticleGroup);
    }

    public void renderInWorldCoords(ViewportAPI viewport) {
        ExtraParticleGroup.render(0.0f, 0.0f);
    }

    public static void addExtraHitParticle(Vector2f loc, Vector2f vel, float size, float brightness, float duration, Color color) {
        GenericTextureParticle generictextureparticle = new GenericTextureParticle("graphics/fx/hit_glow.png", new Color(color.getRed(), color.getGreen(), color.getBlue(), (int)(brightness * 255.0f)), size, size, 0.0f);
        generictextureparticle.setBlendFunc(770, 1);
        generictextureparticle.setPos(loc.x, loc.y);
        generictextureparticle.setVel(vel.x, vel.y);
        generictextureparticle.setMaxAge(duration);
        ExtraParticleGroup.add((BaseParticle)generictextureparticle);
    }

    public static void addExtraSmoothParticle(Vector2f loc, Vector2f vel, float size, float brightness, float duration, Color color) {
        SmoothParticle smoothparticle = new SmoothParticle(color, size);
        smoothparticle.setMaxAge(duration);
        smoothparticle.setPos(loc.x, loc.y);
        smoothparticle.setVel(vel.x, vel.y);
        ExtraParticleGroup.add((BaseParticle)smoothparticle);
    }

    public static void addExtraSmokeParticle(Vector2f loc, Vector2f vel, float size, float opacity, float duration, Color color) {
        DetailedSmokeParticle detailedsmokeparticle = new DetailedSmokeParticle(color, size, size * 1.25f);
        detailedsmokeparticle.setAngle((float)Math.random() * 360.0f);
        detailedsmokeparticle.setRotationSpeed((float)Math.random() * 140.0f - 70.0f);
        detailedsmokeparticle.setMaxAge(duration);
        detailedsmokeparticle.setPos(loc.x, loc.y);
        detailedsmokeparticle.setVel(vel.x, vel.y);
        detailedsmokeparticle.setRampUpPeriod(0.5f * (float)Math.random());
        ExtraParticleGroup.add((BaseParticle)detailedsmokeparticle);
    }

    public static void AddParticlesEx(int hitParticleCount, int smoothParticleCount, int smokeParticleCount, boolean randomCounts, Vector2f loc, float radius, float facing, float spread, Vector2f relativeVel, float minSpeed, float maxSpeed, int minSize, int maxSize, float minBrightness, float maxBrightness, float minDuration, float maxDuration, Color color) {
        float duration;
        float brightness;
        int size;
        Vector2f vel;
        Vector2f randomLoc;
        int i;
        if (!ShaderLib.isOnScreen((Vector2f)loc, (float)200.0f)) {
            return;
        }
        if (randomCounts) {
            hitParticleCount = MathUtils.getRandomNumberInRange((int)0, (int)hitParticleCount);
            smoothParticleCount = MathUtils.getRandomNumberInRange((int)0, (int)smoothParticleCount);
            smokeParticleCount = MathUtils.getRandomNumberInRange((int)0, (int)smokeParticleCount);
        }
        minBrightness = Math.max(minBrightness, 0.0f);
        maxBrightness = Math.min(1.0f, maxBrightness);
        for (i = 0; i < hitParticleCount; ++i) {
            randomLoc = radius == 0.0f ? loc : MathUtils.getRandomPointInCircle((Vector2f)loc, (float)radius);
            vel = MathUtils.getPointOnCircumference((Vector2f)relativeVel, (float)MathUtils.getRandomNumberInRange((float)minSpeed, (float)maxSpeed), (float)MathUtils.clampAngle((float)MathUtils.getRandomNumberInRange((float)(facing - spread), (float)(facing + spread))));
            size = MathUtils.getRandomNumberInRange((int)minSize, (int)maxSize);
            brightness = MathUtils.getRandomNumberInRange((float)minBrightness, (float)maxBrightness);
            duration = MathUtils.getRandomNumberInRange((float)minDuration, (float)maxDuration);
            GenericTextureParticle generictextureparticle = new GenericTextureParticle("graphics/fx/hit_glow.png", new Color(color.getRed(), color.getGreen(), color.getBlue(), (int)(brightness * 255.0f)), (float)size, (float)size, 0.0f);
            generictextureparticle.setBlendFunc(770, 1);
            generictextureparticle.setPos(randomLoc.x, randomLoc.y);
            generictextureparticle.setVel(vel.x, vel.y);
            generictextureparticle.setMaxAge(duration);
            ExtraParticleGroup.add((BaseParticle)generictextureparticle);
        }
        for (i = 0; i < smoothParticleCount; ++i) {
            randomLoc = radius == 0.0f ? loc : MathUtils.getRandomPointInCircle((Vector2f)loc, (float)radius);
            vel = MathUtils.getPointOnCircumference((Vector2f)relativeVel, (float)MathUtils.getRandomNumberInRange((float)minSpeed, (float)maxSpeed), (float)MathUtils.clampAngle((float)MathUtils.getRandomNumberInRange((float)(facing - spread), (float)(facing + spread))));
            size = MathUtils.getRandomNumberInRange((int)minSize, (int)maxSize);
            brightness = MathUtils.getRandomNumberInRange((float)minBrightness, (float)maxBrightness);
            duration = MathUtils.getRandomNumberInRange((float)minDuration, (float)maxDuration);
            SmoothParticle smoothparticle = new SmoothParticle(color, (float)size);
            smoothparticle.setMaxAge(duration);
            smoothparticle.setPos(randomLoc.x, randomLoc.y);
            smoothparticle.setVel(vel.x, vel.y);
            ExtraParticleGroup.add((BaseParticle)smoothparticle);
        }
        for (i = 0; i < smokeParticleCount; ++i) {
            randomLoc = radius == 0.0f ? loc : MathUtils.getRandomPointInCircle((Vector2f)loc, (float)radius);
            vel = MathUtils.getPointOnCircumference((Vector2f)relativeVel, (float)MathUtils.getRandomNumberInRange((float)minSpeed, (float)maxSpeed), (float)MathUtils.clampAngle((float)MathUtils.getRandomNumberInRange((float)(facing - spread), (float)(facing + spread))));
            size = MathUtils.getRandomNumberInRange((int)minSize, (int)maxSize);
            brightness = MathUtils.getRandomNumberInRange((float)minBrightness, (float)maxBrightness);
            duration = MathUtils.getRandomNumberInRange((float)minDuration, (float)maxDuration);
            DetailedSmokeParticle detailedsmokeparticle = new DetailedSmokeParticle(color, (float)size, (float)size * 1.25f);
            detailedsmokeparticle.setAngle((float)Math.random() * 360.0f);
            detailedsmokeparticle.setRotationSpeed((float)Math.random() * 140.0f - 70.0f);
            detailedsmokeparticle.setMaxAge(duration);
            detailedsmokeparticle.setPos(randomLoc.x, randomLoc.y);
            detailedsmokeparticle.setVel(vel.x, vel.y);
            detailedsmokeparticle.setRampUpPeriod(0.5f * (float)Math.random());
            ExtraParticleGroup.add((BaseParticle)detailedsmokeparticle);
        }
    }

    public static void AddParticlesEx(int count, int type, boolean randomCounts, Vector2f loc, float radius, float facing, float spread, Vector2f relativeVel, float minSpeed, float maxSpeed, int minSize, int maxSize, float minBrightness, float maxBrightness, float minDuration, float maxDuration, Color color) {
        int hitParticleCount = 0;
        int smoothParticleCount = 0;
        int smokeParticleCount = 0;
        switch (type) {
            case 1: {
                hitParticleCount = count;
                break;
            }
            case 2: {
                smoothParticleCount = count;
                break;
            }
            case 3: {
                smokeParticleCount = count;
            }
        }
        Neutrino_ExtraParticlePlugin.AddParticlesEx(hitParticleCount, smoothParticleCount, smokeParticleCount, randomCounts, loc, radius, facing, spread, relativeVel, minSpeed, maxSpeed, minSize, maxSize, minBrightness, maxBrightness, minDuration, maxDuration, color);
    }

    public static void AddParticlesEx(int count, int type, boolean randomCounts, Vector2f loc, float radius, float facing, float spread, float minSpeed, float maxSpeed, int minSize, int maxSize, float minBrightness, float maxBrightness, float minDuration, float maxDuration, Color color) {
        Neutrino_ExtraParticlePlugin.AddParticlesEx(count, type, randomCounts, loc, radius, facing, spread, zero, minSpeed, maxSpeed, minSize, maxSize, minBrightness, maxBrightness, minDuration, maxDuration, color);
    }

    public static void AddParticlesOnSegmentEx(Vector2f start, Vector2f end, float density, int type, boolean randomDensity, float radius, float spread, Vector2f relativeVel, float minSpeed, float maxSpeed, int minSize, int maxSize, float minBrightness, float maxBrightness, float minDuration, float maxDuration, Color color) {
        if (!ShaderLib.isOnScreen((Vector2f)start, (Vector2f)end, (float)200.0f)) {
            return;
        }
        float dist = MathUtils.getDistance((Vector2f)start, (Vector2f)end);
        float times = dist * density / 100.0f;
        float facing = VectorUtils.getAngle((Vector2f)start, (Vector2f)end);
        int i = 0;
        while ((float)i < times) {
            Neutrino_ExtraParticlePlugin.AddParticlesEx(1, type, randomDensity, MathUtils.getRandomPointOnLine((Vector2f)start, (Vector2f)end), radius, facing, spread, relativeVel, minSpeed, maxSpeed, minSize, maxSize, minBrightness, maxBrightness, minDuration, maxDuration, color);
            ++i;
        }
    }

    public static void AddParticlesOnSegmentEx(Vector2f start, Vector2f end, float density, int type, boolean randomDensity, float radius, float spread, float minSpeed, float maxSpeed, int minSize, int maxSize, float minBrightness, float maxBrightness, float minDuration, float maxDuration, Color color) {
        Neutrino_ExtraParticlePlugin.AddParticlesOnSegmentEx(start, end, density, type, randomDensity, radius, spread, zero, minSpeed, maxSpeed, minSize, maxSize, minBrightness, maxBrightness, minDuration, maxDuration, color);
    }

    public static void ParticleBeamPathEx(BeamAPI beam, float density, int type, boolean randomDensity, float radius, float spread, Vector2f relativeVel, float angularVel, float minSpeed, float maxSpeed, int minSize, int maxSize, float minBrightness, float maxBrightness, float minDuration, float maxDuration, Color color) {
        Vector2f to = beam.getTo();
        Vector2f from = beam.getFrom();
        Neutrino_ExtraParticlePlugin.ParticlesRayEx(from, to, density, type, randomDensity, radius, spread, relativeVel, angularVel, minSpeed, maxSpeed, minSize, maxSize, minBrightness, maxBrightness, minDuration, maxDuration, color, true);
    }

    public static void ParticlesRayEx(Vector2f start, Vector2f end, float density, int type, boolean randomDensity, float radius, float spread, Vector2f relativeVel, float angularVel, float minSpeed, float maxSpeed, int minSize, int maxSize, float minBrightness, float maxBrightness, float minDuration, float maxDuration, Color color, boolean sureEnd) {
        CombatEngineAPI engine = Global.getCombatEngine();
        if (!ShaderLib.isOnScreen((Vector2f)start, (Vector2f)end, (float)200.0f)) {
            return;
        }
        Vector2f startToEnd = Vector2f.sub((Vector2f)end, (Vector2f)start, null);
        float dist = startToEnd.length();
        if (dist == 0.0f) {
            return;
        }
        float times = dist * density / 100.0f;
        float facing = VectorUtils.getFacing((Vector2f)startToEnd);
        Vector2f AVModule = new Vector2f();
        startToEnd.normalise();
        if (angularVel != 0.0f) {
            AVModule = MathUtils.getPointOnCircumference(null, (float)1.0f, (float)(facing + 90.0f + angularVel));
            AVModule.scale((float)FastTrig.sin((double)Math.toRadians(angularVel)) / Global.getCombatEngine().getElapsedInLastFrame());
        }
        int i = 0;
        while ((float)i < times) {
            float randomDist = MathUtils.getRandomNumberInRange((float)0.0f, (float)dist);
            Vector2f point = MathUtils.getPointOnCircumference((Vector2f)start, (float)randomDist, (float)facing);
            if (radius > 0.0f) {
                point = MathUtils.getRandomPointInCircle((Vector2f)point, (float)radius);
            }
            Vector2f vel = new Vector2f((ReadableVector2f)relativeVel);
            if (angularVel != 0.0f) {
                Vector2f angVel = new Vector2f((ReadableVector2f)AVModule);
                angVel.scale(randomDist);
                Vector2f.add((Vector2f)vel, (Vector2f)angVel, (Vector2f)vel);
            }
            vel = MathUtils.getPointOnCircumference((Vector2f)vel, (float)MathUtils.getRandomNumberInRange((float)minSpeed, (float)maxSpeed), (float)MathUtils.clampAngle((float)MathUtils.getRandomNumberInRange((float)(facing - spread), (float)(facing + spread))));
            int size = MathUtils.getRandomNumberInRange((int)minSize, (int)maxSize);
            float brightness = MathUtils.getRandomNumberInRange((float)minBrightness, (float)maxBrightness);
            float duration = MathUtils.getRandomNumberInRange((float)minDuration, (float)maxDuration);
            if (sureEnd) {
                float speedModule = Vector2f.dot((Vector2f)vel, (Vector2f)startToEnd);
                if (speedModule > 0.0f) {
                    duration = Math.min(duration, (dist - randomDist) / speedModule);
                } else if (speedModule < 0.0f) {
                    duration = Math.min(duration, randomDist / -speedModule);
                }
            }
            switch (type) {
                case 1: {
                    engine.addHitParticle(point, vel, (float)size, brightness, duration, color);
                    break;
                }
                case 2: {
                    engine.addSmoothParticle(point, vel, (float)size, brightness, duration, color);
                    break;
                }
                case 3: {
                    engine.addSmokeParticle(point, vel, (float)size, brightness, duration, color);
                }
            }
            ++i;
        }
    }
}

