/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.plugins;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.BaseEveryFrameCombatPlugin;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.ViewportAPI;
import com.fs.starfarer.api.graphics.SpriteAPI;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import org.lazywizard.lazylib.FastTrig;
import org.lazywizard.lazylib.MathUtils;
import org.lazywizard.lazylib.VectorUtils;
import org.lwjgl.util.vector.Vector2f;

public class Neutrino_FakeBeamPlugin
extends BaseEveryFrameCombatPlugin {
    private static final List<FakeBeam> FAKEBEAMS = new ArrayList<FakeBeam>();
    private final List<FakeBeam> toRemove = new ArrayList<FakeBeam>();

    public void init(CombatEngineAPI engine) {
        FAKEBEAMS.clear();
    }

    public void renderInWorldCoords(ViewportAPI view) {
        CombatEngineAPI engine = Global.getCombatEngine();
        if (engine == null) {
            return;
        }
        if (!FAKEBEAMS.isEmpty()) {
            float amount = engine.isPaused() ? 0.0f : engine.getElapsedInLastFrame();
            for (FakeBeam fakeBeam : FAKEBEAMS) {
                float fadeIn = fakeBeam.getFadeInTimer();
                float liveTime = fakeBeam.getDurationTimer();
                float fadeOut = fakeBeam.getFadeOutTimer();
                float opacity = 0.0f;
                if (fadeIn > 0.0f) {
                    fakeBeam.setFadeInTimer(fadeIn -= amount);
                    opacity = (float)FastTrig.cos((double)((double)(fadeIn / fakeBeam.getFadeInDuration()) * 1.5707963267948966));
                } else if (liveTime > 0.0f) {
                    fakeBeam.setDurationTimer(liveTime -= amount);
                    opacity = 1.0f;
                } else if (fadeOut > 0.0f) {
                    fakeBeam.setFadeOutTimer(fadeOut -= amount);
                    opacity = (float)FastTrig.sin((double)((double)(fadeOut / fakeBeam.getFadeOutDuration()) * 1.5707963267948966));
                } else {
                    this.toRemove.add(fakeBeam);
                    continue;
                }
                this.render(fakeBeam.getSprite(), fakeBeam.getColor(), fakeBeam.getWidth() * opacity, fakeBeam.getLength(), fakeBeam.getAngleToRender(), opacity, fakeBeam.getCenter());
            }
            if (!this.toRemove.isEmpty()) {
                FAKEBEAMS.removeAll(this.toRemove);
                this.toRemove.clear();
            }
        }
    }

    private void render(SpriteAPI sprite, Color color, float width, float height, float angle, float opacity, Vector2f center) {
        if (color != null) {
            sprite.setColor(color);
        }
        sprite.setAlphaMult(opacity);
        sprite.setSize(height, width);
        sprite.setAdditiveBlend();
        sprite.setAngle(angle);
        sprite.renderAtCenter(center.x, center.y);
    }

    public static FakeBeam renderFakeBeam(Vector2f form, Vector2f to, float width, float duration, float fadeInDuration, float fadeOutDuration, SpriteAPI beamSprite, Color beamColor) {
        FakeBeam fakeBeam = new FakeBeam();
        if (beamSprite != null) {
            fakeBeam.setSprite(beamSprite);
        }
        fakeBeam.setColor(beamColor);
        fakeBeam.setForm(form);
        fakeBeam.setTo(to);
        fakeBeam.setWidth(width);
        fakeBeam.setDuration(duration);
        fakeBeam.setFadeInDuration(fadeInDuration);
        fakeBeam.setFadeOutDuration(fadeOutDuration);
        FAKEBEAMS.add(fakeBeam);
        return fakeBeam;
    }

    public static FakeBeam renderFakeBeam(Vector2f form, Vector2f to, float width, float duration, SpriteAPI beamSprite, Color beamColor) {
        return Neutrino_FakeBeamPlugin.renderFakeBeam(form, to, width, duration - 0.5f, 0.25f, 0.25f, beamSprite, beamColor);
    }

    public static FakeBeam renderFakeBeam(Vector2f form, float length, float aim, float width, float duration, float fadeInDuration, float fadeOutDuration, SpriteAPI beamSprite, Color beamColor) {
        Vector2f to = MathUtils.getPointOnCircumference((Vector2f)form, (float)length, (float)aim);
        return Neutrino_FakeBeamPlugin.renderFakeBeam(form, to, width, duration, fadeInDuration, fadeOutDuration, beamSprite, beamColor);
    }

    public static FakeBeam renderFakeBeam(Vector2f form, float length, float aim, float width, float duration, SpriteAPI beamSprite, Color beamColor) {
        Vector2f to = MathUtils.getPointOnCircumference((Vector2f)form, (float)length, (float)aim);
        return Neutrino_FakeBeamPlugin.renderFakeBeam(form, to, width, duration, beamSprite, beamColor);
    }

    public static class FakeBeam {
        protected SpriteAPI beamSprite = Global.getSettings().getSprite("graphics/fx/beamcore.png");
        protected Color beamColor = Color.white;
        protected float width = 0.0f;
        protected float length = 0.0f;
        protected float angleForRender = 0.0f;
        protected float duration = 0.0f;
        protected float durationTimer = 0.0f;
        protected float fadeInDuration = 0.0f;
        protected float fadeInTimer = 0.0f;
        protected float fadeOutDuration = 0.0f;
        protected float fadeOutTimer = 0.0f;
        protected Vector2f centerLoc = null;
        protected Vector2f form = null;
        protected Vector2f to = null;

        public void setSprite(SpriteAPI beamSprite) {
            this.beamSprite = beamSprite;
        }

        public SpriteAPI getSprite() {
            return this.beamSprite;
        }

        public void setColor(Color beamColor) {
            this.beamColor = beamColor;
        }

        public Color getColor() {
            return this.beamColor;
        }

        public void setWidth(float width) {
            this.width = width;
        }

        public float getWidth() {
            return this.width;
        }

        public void setLength(float length) {
            this.length = length;
            if (this.form != null) {
                this.setTo(MathUtils.getPointOnCircumference((Vector2f)this.form, (float)length, (float)this.angleForRender));
            }
        }

        public float getLength() {
            return this.length;
        }

        public void setCurrAngle(float currAngle) {
            if (this.form != null) {
                this.setTo(MathUtils.getPointOnCircumference((Vector2f)this.form, (float)this.length, (float)currAngle));
            }
        }

        public float getCurrAngle() {
            return this.angleForRender;
        }

        public float getAngleToRender() {
            return this.angleForRender;
        }

        public void setDuration(float duration) {
            this.duration = duration;
            this.durationTimer = duration;
        }

        public float getDuration() {
            return this.duration;
        }

        public void setDurationTimer(float durationTimer) {
            this.durationTimer = durationTimer;
        }

        public float getDurationTimer() {
            return this.durationTimer;
        }

        public void setFadeInDuration(float fadeInDuration) {
            this.fadeInDuration = fadeInDuration;
            this.fadeInTimer = fadeInDuration;
        }

        public float getFadeInDuration() {
            return this.fadeInDuration;
        }

        public void setFadeInTimer(float fadeInTimer) {
            this.fadeInTimer = fadeInTimer;
        }

        public float getFadeInTimer() {
            return this.fadeInTimer;
        }

        public void setFadeOutDuration(float fadeOutDuration) {
            this.fadeOutDuration = fadeOutDuration;
            this.fadeOutTimer = fadeOutDuration;
        }

        public float getFadeOutDuration() {
            return this.fadeOutDuration;
        }

        public void setFadeOutTimer(float fadeOutTimer) {
            this.fadeOutTimer = fadeOutTimer;
        }

        public float getFadeOutTimer() {
            return this.fadeOutTimer;
        }

        public void setForm(Vector2f form) {
            this.form = form;
            if (this.form != null && this.to != null) {
                this.centerLoc = MathUtils.getMidpoint((Vector2f)this.form, (Vector2f)this.to);
                this.length = MathUtils.getDistance((Vector2f)form, (Vector2f)this.to);
                this.angleForRender = VectorUtils.getAngle((Vector2f)form, (Vector2f)this.to);
            }
        }

        public Vector2f getForm() {
            return this.form;
        }

        public void setTo(Vector2f to) {
            this.to = to;
            if (this.to != null && this.form != null) {
                this.centerLoc = MathUtils.getMidpoint((Vector2f)this.form, (Vector2f)this.to);
                this.length = MathUtils.getDistance((Vector2f)this.form, (Vector2f)to);
                this.angleForRender = VectorUtils.getAngle((Vector2f)this.form, (Vector2f)to);
            }
        }

        public Vector2f getTo() {
            return this.to;
        }

        public void setCenter(Vector2f center) {
            this.centerLoc = center;
        }

        public Vector2f getCenter() {
            return this.centerLoc;
        }
    }
}

