/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.util;

import com.fs.starfarer.api.combat.CombatEntityAPI;
import org.lazywizard.lazylib.VectorUtils;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class AdvForce {
    public static void applyMomentum(CombatEntityAPI entity, Vector2f pointOfImpact, Vector2f direction, float momentum, boolean elasticCollision) {
        if (direction.lengthSquared() == 0.0f) {
            return;
        }
        momentum *= 100.0f;
        float mass = Math.max(1.0f, entity.getMass());
        Vector2f BPtoMC = Vector2f.sub((Vector2f)entity.getLocation(), (Vector2f)pointOfImpact, null);
        Vector2f forceV = new Vector2f();
        direction.normalise(forceV);
        forceV.scale(momentum);
        BPtoMC.normalise(BPtoMC);
        BPtoMC.scale(Vector2f.dot((Vector2f)forceV, (Vector2f)BPtoMC) / mass);
        if (elasticCollision) {
            Vector2f.add((Vector2f)BPtoMC, (Vector2f)entity.getVelocity(), (Vector2f)entity.getVelocity());
        } else {
            direction = new Vector2f((ReadableVector2f)forceV);
            direction.scale(1.0f / mass);
            Vector2f.add((Vector2f)direction, (Vector2f)entity.getVelocity(), (Vector2f)entity.getVelocity());
        }
        float angularAcc = VectorUtils.getCrossProduct((Vector2f)forceV, (Vector2f)BPtoMC) / (0.5f * mass * entity.getCollisionRadius() * entity.getCollisionRadius());
        angularAcc = (float)Math.toDegrees(angularAcc);
        if (elasticCollision) {
            entity.setAngularVelocity(entity.getAngularVelocity() + angularAcc);
        } else {
            entity.setAngularVelocity(entity.getAngularVelocity() - angularAcc);
        }
    }
}

