/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.util;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.BoundsAPI;
import com.fs.starfarer.api.combat.CollisionClass;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.ShieldAPI;
import org.lazywizard.lazylib.MathUtils;
import org.lazywizard.lazylib.VectorUtils;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class AnchoredMovingEntity
implements CombatEntityAPI {
    protected Vector2f relativeVelocity;
    protected Vector2f location;
    protected Vector2f relativeLocation;
    protected CombatEntityAPI anchor;
    protected float timeStamp;
    protected float relativeDistance;
    protected float relativeAngle;
    protected float angle;
    protected float TET = Global.getCombatEngine().getTotalElapsedTime(false);

    public AnchoredMovingEntity(CombatEntityAPI anchor, Vector2f location, Vector2f relativeVelocity) {
        this.reanchor(anchor, location, relativeVelocity);
    }

    public void reanchor(CombatEntityAPI newAnchor, Vector2f newLocation, Vector2f newRelativeVelocity) {
        this.relativeDistance = MathUtils.getDistance((Vector2f)newAnchor.getLocation(), (Vector2f)newLocation);
        this.angle = newAnchor.getFacing();
        this.relativeAngle = MathUtils.clampAngle((float)(VectorUtils.getAngle((Vector2f)newAnchor.getLocation(), (Vector2f)newLocation) - newAnchor.getFacing()));
        this.anchor = newAnchor;
        this.relativeVelocity = newRelativeVelocity;
        this.timeStamp = this.TET;
    }

    public void rotateRelativeVelocity() {
        if (this.anchor.getFacing() != this.angle) {
            VectorUtils.rotate((Vector2f)this.relativeVelocity, (float)MathUtils.getShortestRotation((float)this.angle, (float)this.anchor.getFacing()), (Vector2f)this.relativeVelocity);
            this.angle = this.anchor.getFacing();
        }
    }

    public void setLocation(Vector2f location) {
        this.reanchor(this.anchor, location, this.relativeVelocity);
    }

    public Vector2f getLocation() {
        Vector2f toReturn = new Vector2f((ReadableVector2f)this.anchor.getLocation());
        if (this.timeStamp != this.TET) {
            this.rotateRelativeVelocity();
            Vector2f variation = new Vector2f((ReadableVector2f)this.relativeVelocity);
            variation.scale(this.TET - this.timeStamp);
            Vector2f.add((Vector2f)toReturn, (Vector2f)variation, (Vector2f)toReturn);
        }
        return toReturn;
    }

    public void setVelocity(Vector2f velocity) {
        this.reanchor(this.anchor, this.location, velocity);
    }

    public Vector2f getVelocity() {
        this.rotateRelativeVelocity();
        return Vector2f.add((Vector2f)this.anchor.getVelocity(), (Vector2f)this.relativeVelocity, null);
    }

    public float getFacing() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setFacing(float facing) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public float getAngularVelocity() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setAngularVelocity(float angVel) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public int getOwner() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setOwner(int owner) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public float getCollisionRadius() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public CollisionClass getCollisionClass() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setCollisionClass(CollisionClass collisionClass) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public float getMass() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setMass(float mass) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public BoundsAPI getExactBounds() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public ShieldAPI getShield() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public float getHullLevel() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public float getHitpoints() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public float getMaxHitpoints() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setCollisionRadius(float radius) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

