/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.util;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.ArmorGridAPI;
import com.fs.starfarer.api.combat.BoundsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.combat.entities.Ship;
import java.awt.Color;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class Neutrino_ArmorEX {
    private static final Map<String, Integer> countedInBoundArmor = new HashMap<String, Integer>(100);
    private static final Map<String, Integer> countedValidArmor = new HashMap<String, Integer>(100);
    private static final Map<String, boolean[][]> inBoundArmorCells = new HashMap<String, boolean[][]>(100);
    private static final Map<String, boolean[][]> validArmorCells = new HashMap<String, boolean[][]>(100);

    public static int getValidArmorCellCount(ShipAPI ship) {
        String id = ship.getHullSpec().getHullId();
        if (countedValidArmor.containsKey(id)) {
            return countedValidArmor.get(id);
        }
        Neutrino_ArmorEX.validArmorCellCheck(ship);
        return countedValidArmor.get(id);
    }

    public static int getInBoundArmorCellCount(ShipAPI ship) {
        String id = ship.getHullSpec().getHullId();
        if (countedInBoundArmor.containsKey(id)) {
            return countedInBoundArmor.get(id);
        }
        Neutrino_ArmorEX.inBoundArmorCellCheck(ship);
        return countedInBoundArmor.get(id);
    }

    public static boolean[][] validArmorCellCheck(ShipAPI ship) {
        String id = ship.getHullSpec().getHullId();
        if (validArmorCells.containsKey(id)) {
            return validArmorCells.get(id);
        }
        ArmorGridAPI armorGrid = ship.getArmorGrid();
        if (armorGrid.getGrid() == null) {
            return null;
        }
        int count = 0;
        int x = armorGrid.getGrid().length;
        int y = armorGrid.getGrid()[0].length;
        boolean[][] valid = new boolean[x][y];
        boolean[][] inBounds = Neutrino_ArmorEX.inBoundArmorCellCheck(ship);
        for (int i = 0; i < x; ++i) {
            block1: for (int j = 0; j < y; ++j) {
                for (int a = -2; a < 3; ++a) {
                    if (i + a < 0 || i + a > x - 1) continue;
                    for (int b = -2; b < 3; ++b) {
                        if (Math.abs(a * b) == 4 || j + b < 0 || j + b > y - 1 || !inBounds[i + a][j + b]) continue;
                        valid[i][j] = true;
                        ++count;
                        continue block1;
                    }
                }
            }
        }
        validArmorCells.put(id, valid);
        countedValidArmor.put(id, count);
        return valid;
    }

    public static boolean[][] inBoundArmorCellCheck(ShipAPI ship) {
        int i;
        String id = ship.getHullSpec().getHullId();
        if (inBoundArmorCells.containsKey(id)) {
            return inBoundArmorCells.get(id);
        }
        ArmorGridAPI armorGrid = ship.getArmorGrid();
        if (armorGrid.getGrid() == null) {
            return null;
        }
        int count = 0;
        int x = armorGrid.getGrid().length;
        int y = armorGrid.getGrid()[0].length;
        boolean[][] inBound = new boolean[x][y];
        int left = armorGrid.getLeftOf();
        int below = armorGrid.getBelow();
        float size = armorGrid.getCellSize();
        List segmentsToCheck = ship.getExactBounds().getSegments();
        Vector2f loc = ship.getLocation();
        float facing = ship.getFacing();
        ship.getExactBounds().update(new Vector2f(0.0f, 0.0f), 90.0f);
        ArrayList<Vector2f> points = new ArrayList<Vector2f>(segmentsToCheck.size() + 1);
        float xMin = 0.0f;
        float xMax = 0.0f;
        float yMin = 0.0f;
        float yMax = 0.0f;
        for (i = 0; i < segmentsToCheck.size(); ++i) {
            BoundsAPI.SegmentAPI segment = (BoundsAPI.SegmentAPI)segmentsToCheck.get(i);
            Vector2f point = new Vector2f((ReadableVector2f)segment.getP1());
            points.add(point);
            xMin = xMin < point.x ? xMin : point.x;
            xMax = xMax > point.x ? xMax : point.x;
            yMin = yMin < point.y ? yMin : point.y;
            float f = yMax = yMax > point.y ? yMax : point.y;
            if (i != segmentsToCheck.size() - 1) continue;
            point = new Vector2f((ReadableVector2f)segment.getP2());
            points.add(point);
            xMin = xMin < point.x ? xMin : point.x;
            xMax = xMax > point.x ? xMax : point.x;
            yMin = yMin < point.y ? yMin : point.y;
            yMax = yMax > point.y ? yMax : point.y;
        }
        ship.getExactBounds().update(loc, facing);
        for (i = 0; i < x; ++i) {
            float xL = (float)(i - left) * size;
            float xR = xL + size;
            for (int j = 0; j < y; ++j) {
                float yB = (float)(j - below) * size;
                float yA = yB + size;
                boolean result = false;
                Rectangle2D.Float rectangle = new Rectangle2D.Float();
                rectangle.setRect(xL, yB, size, size);
                float xC = (xL + xR) / 2.0f;
                float yC = (yA + yB) / 2.0f;
                int a = 0;
                int b = points.size() - 1;
                while (a < points.size()) {
                    if (rectangle.intersectsLine(((Vector2f)points.get((int)a)).x, ((Vector2f)points.get((int)a)).y, ((Vector2f)points.get((int)b)).x, ((Vector2f)points.get((int)b)).y)) {
                        result = true;
                        break;
                    }
                    if (((Vector2f)points.get((int)a)).y > yC != ((Vector2f)points.get((int)b)).y > yC && xC < (((Vector2f)points.get((int)b)).x - ((Vector2f)points.get((int)a)).x) * (yC - ((Vector2f)points.get((int)a)).y) / (((Vector2f)points.get((int)b)).y - ((Vector2f)points.get((int)a)).y) + ((Vector2f)points.get((int)b)).x) {
                        result = !result;
                    }
                    b = a++;
                }
                inBound[i][j] = result;
                if (!inBound[i][j]) continue;
                ++count;
            }
        }
        inBoundArmorCells.put(id, inBound);
        countedInBoundArmor.put(id, count);
        return inBound;
    }

    public static Vector2f getCellLocation(ShipAPI ship, float x, float y) {
        float cellSize = ship.getArmorGrid().getCellSize();
        Vector2f cellLoc = new Vector2f();
        float theta = (float)((double)((ship.getFacing() - 90.0f) / 360.0f) * (Math.PI * 2));
        cellLoc.x = (float)((double)(x -= (float)ship.getArmorGrid().getLeftOf()) * Math.cos(theta) - (double)(y -= (float)ship.getArmorGrid().getBelow()) * Math.sin(theta)) * cellSize + ship.getLocation().x;
        cellLoc.y = (float)((double)x * Math.sin(theta) + (double)y * Math.cos(theta)) * cellSize + ship.getLocation().y;
        return cellLoc;
    }

    public static Vector2f getCellCentreLocation(ShipAPI ship, float x, float y) {
        return Neutrino_ArmorEX.getCellLocation(ship, x + 0.5f, y + 0.5f);
    }

    public static void armorDebuging(ShipAPI ship, float amount) {
        ArmorGridAPI armorGrid = ship.getArmorGrid();
        int x = armorGrid.getGrid().length;
        int y = armorGrid.getGrid()[0].length;
        boolean[][] vc = Neutrino_ArmorEX.validArmorCellCheck(ship);
        boolean[][] ib = Neutrino_ArmorEX.inBoundArmorCellCheck(ship);
        Global.getCombatEngine().addSmoothParticle(ship.getLocation(), new Vector2f(0.0f, 0.0f), 15.0f, 1.0f, amount, Color.green);
        Ship s = (Ship)ship;
        s.setRenderBounds(true);
        for (int i = 0; i < x; ++i) {
            for (int j = 0; j < y; ++j) {
                Vector2f point = Neutrino_ArmorEX.getCellLocation(ship, i, j);
                if (ib[i][j]) {
                    Global.getCombatEngine().addSmoothParticle(point, new Vector2f(0.0f, 0.0f), 15.0f, 1.0f, amount, Color.cyan);
                    continue;
                }
                if (vc[i][j]) {
                    Global.getCombatEngine().addSmoothParticle(point, new Vector2f(0.0f, 0.0f), 15.0f, 1.0f, amount, Color.yellow);
                    continue;
                }
                Global.getCombatEngine().addSmoothParticle(point, new Vector2f(0.0f, 0.0f), 15.0f, 1.0f, amount, Color.RED);
            }
        }
    }
}

