/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.util;

import com.fs.starfarer.api.combat.CollisionClass;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.ShieldAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import java.awt.geom.Line2D;
import org.lazywizard.lazylib.CollisionUtils;
import org.lazywizard.lazylib.MathUtils;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class Neutrino_CollisionUtilsEX {
    public static Vector2f getShipCollisionPoint(Vector2f segStart, Vector2f segEnd, ShipAPI ship, boolean accurateShieldEdgeTest) {
        float circleRadius;
        if (ship.getCollisionClass() == CollisionClass.NONE) {
            return null;
        }
        ShieldAPI shield = ship.getShield();
        if (shield == null || shield.isOff()) {
            return CollisionUtils.getCollisionPoint((Vector2f)segStart, (Vector2f)segEnd, (CombatEntityAPI)ship);
        }
        Vector2f circleCenter = shield.getLocation();
        Vector2f tmp1 = Neutrino_CollisionUtilsEX.getCollisionPointOnCircle(segStart, segEnd, circleCenter, circleRadius = shield.getRadius());
        if (tmp1 != null) {
            if (shield.isWithinArc(tmp1)) {
                return tmp1;
            }
            boolean hit = false;
            Vector2f tmp = new Vector2f((ReadableVector2f)segEnd);
            Vector2f hullHit = CollisionUtils.getCollisionPoint((Vector2f)segStart, (Vector2f)segEnd, (CombatEntityAPI)ship);
            if (hullHit != null) {
                tmp = hullHit;
                hit = true;
            }
            if (accurateShieldEdgeTest) {
                Vector2f shieldEdge2;
                Vector2f tmp3;
                Vector2f shieldEdge1 = MathUtils.getPointOnCircumference((Vector2f)circleCenter, (float)circleRadius, (float)MathUtils.clampAngle((float)(shield.getFacing() + shield.getActiveArc() / 2.0f)));
                Vector2f tmp2 = CollisionUtils.getCollisionPoint((Vector2f)segStart, (Vector2f)tmp, (Vector2f)circleCenter, (Vector2f)shieldEdge1);
                if (tmp2 != null) {
                    tmp = tmp2;
                    hit = true;
                }
                if ((tmp3 = CollisionUtils.getCollisionPoint((Vector2f)segStart, (Vector2f)tmp, (Vector2f)circleCenter, (Vector2f)(shieldEdge2 = MathUtils.getPointOnCircumference((Vector2f)circleCenter, (float)circleRadius, (float)MathUtils.clampAngle((float)(shield.getFacing() - shield.getActiveArc() / 2.0f)))))) != null) {
                    tmp = tmp3;
                    hit = true;
                }
            }
            return hit ? tmp : null;
        }
        return null;
    }

    public static Vector2f getShipCollisionPoint(Vector2f segStart, Vector2f segEnd, ShipAPI ship) {
        return Neutrino_CollisionUtilsEX.getShipCollisionPoint(segStart, segEnd, ship, false);
    }

    public static Vector2f getCollisionPointOnCircle(Vector2f segStart, Vector2f segEnd, Vector2f circleCenter, float circleRadius) {
        if (segStart.equals((Object)segEnd)) {
            return null;
        }
        Vector2f startToEnd = Vector2f.sub((Vector2f)segEnd, (Vector2f)segStart, null);
        Vector2f startToCenter = Vector2f.sub((Vector2f)circleCenter, (Vector2f)segStart, null);
        double ptLineDistSq = (float)Line2D.ptLineDistSq(segStart.x, segStart.y, segEnd.x, segEnd.y, circleCenter.x, circleCenter.y);
        float circleRadiusSq = circleRadius * circleRadius;
        if (startToCenter.lengthSquared() < circleRadiusSq) {
            return segStart;
        }
        if (ptLineDistSq > (double)circleRadiusSq || startToCenter.length() - circleRadius > startToEnd.length()) {
            return null;
        }
        startToEnd.normalise(startToEnd);
        double dist = (double)Vector2f.dot((Vector2f)startToCenter, (Vector2f)startToEnd) - Math.sqrt((double)circleRadiusSq - ptLineDistSq);
        startToEnd.scale((float)dist);
        return Vector2f.add((Vector2f)segStart, (Vector2f)startToEnd, null);
    }

    public static Vector2f getCollisionPointOnCircumference(Vector2f segStart, Vector2f segEnd, Vector2f circleCenter, float circleRadius) {
        double dist;
        Vector2f startToEnd = Vector2f.sub((Vector2f)segEnd, (Vector2f)segStart, null);
        Vector2f startToCenter = Vector2f.sub((Vector2f)circleCenter, (Vector2f)segStart, null);
        double ptLineDistSq = (float)Line2D.ptLineDistSq(segStart.x, segStart.y, segEnd.x, segEnd.y, circleCenter.x, circleCenter.y);
        float circleRadiusSq = circleRadius * circleRadius;
        boolean CoS = false;
        if (startToCenter.lengthSquared() < circleRadiusSq) {
            CoS = true;
        }
        if (ptLineDistSq > (double)circleRadiusSq || startToCenter.length() - circleRadius > startToEnd.length()) {
            return null;
        }
        startToEnd.normalise(startToEnd);
        if (CoS) {
            dist = (double)Vector2f.dot((Vector2f)startToCenter, (Vector2f)startToEnd) + Math.sqrt((double)circleRadiusSq - ptLineDistSq);
            if (dist < (double)startToEnd.length()) {
                return null;
            }
        } else {
            dist = (double)Vector2f.dot((Vector2f)startToCenter, (Vector2f)startToEnd) - Math.sqrt((double)circleRadiusSq - ptLineDistSq);
        }
        startToEnd.scale((float)dist);
        return Vector2f.add((Vector2f)segStart, (Vector2f)startToEnd, null);
    }

    public static Vector2f getShieldCollisionPoint(Vector2f segStart, Vector2f segEnd, ShipAPI ship, boolean ignoreHull, boolean accurateShieldEdgeTest) {
        float circleRadius;
        ShieldAPI shield = ship.getShield();
        if (ship.getCollisionClass() == CollisionClass.NONE || shield == null || shield.isOff()) {
            return null;
        }
        Vector2f circleCenter = shield.getLocation();
        Vector2f tmp1 = Neutrino_CollisionUtilsEX.getCollisionPointOnCircle(segStart, segEnd, circleCenter, circleRadius = shield.getRadius());
        if (tmp1 != null) {
            if (shield.isWithinArc(tmp1)) {
                return tmp1;
            }
            Vector2f tmp = new Vector2f((ReadableVector2f)segEnd);
            boolean hit = false;
            if (accurateShieldEdgeTest) {
                Vector2f shieldEdge2;
                Vector2f tmp3;
                Vector2f shieldEdge1 = MathUtils.getPointOnCircumference((Vector2f)circleCenter, (float)circleRadius, (float)MathUtils.clampAngle((float)(shield.getFacing() + shield.getActiveArc() / 2.0f)));
                Vector2f tmp2 = CollisionUtils.getCollisionPoint((Vector2f)segStart, (Vector2f)tmp, (Vector2f)circleCenter, (Vector2f)shieldEdge1);
                if (tmp2 != null) {
                    tmp = tmp2;
                    hit = true;
                }
                if ((tmp3 = CollisionUtils.getCollisionPoint((Vector2f)segStart, (Vector2f)tmp, (Vector2f)circleCenter, (Vector2f)(shieldEdge2 = MathUtils.getPointOnCircumference((Vector2f)circleCenter, (float)circleRadius, (float)MathUtils.clampAngle((float)(shield.getFacing() - shield.getActiveArc() / 2.0f)))))) != null) {
                    tmp = tmp3;
                    hit = true;
                }
            }
            if (!ignoreHull && CollisionUtils.getCollisionPoint((Vector2f)segStart, (Vector2f)tmp, (CombatEntityAPI)ship) != null) {
                return null;
            }
            return hit ? tmp : null;
        }
        return null;
    }

    public static Vector2f getShieldCollisionPoint(Vector2f segStart, Vector2f segEnd, ShipAPI ship, boolean ignoreHull) {
        return Neutrino_CollisionUtilsEX.getShieldCollisionPoint(segStart, segEnd, ship, ignoreHull, false);
    }
}

