/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.weapons;

import com.fs.starfarer.api.combat.BeamAPI;
import com.fs.starfarer.api.combat.BeamEffectPlugin;
import com.fs.starfarer.api.combat.CollisionClass;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.MissileAPI;
import com.fs.starfarer.api.combat.WeaponAPI;
import com.fs.starfarer.api.util.IntervalUtil;
import data.scripts.plugins.Neutrino_LocalData;
import org.lazywizard.lazylib.MathUtils;
import org.lazywizard.lazylib.VectorUtils;
import org.lwjgl.util.vector.Vector2f;

public class NeutAntiPhotonBeamEffect
implements BeamEffectPlugin {
    private final float maxAimOffset = 3.0f;
    private final float trunRate = 30.0f;
    private final IntervalUtil interval = new IntervalUtil(0.1f, 0.1f);
    private final separatelyAimBeam SAB;
    private static final String KEY = "Neutrino_LocalData";

    public NeutAntiPhotonBeamEffect() {
        this.interval.forceIntervalElapsed();
        this.SAB = new separatelyAimBeam(3.0f, 30.0f);
        this.SAB.setTargetAimOffset(0.0f);
        this.SAB.setCurrAimOffset(0.0f);
    }

    public void advance(float amount, CombatEngineAPI engine, BeamAPI beam) {
        if (engine == null) {
            return;
        }
        Neutrino_LocalData.LocalData localData = (Neutrino_LocalData.LocalData)engine.getCustomData().get(KEY);
        if (engine.isPaused()) {
            return;
        }
        if (beam.getBrightness() > 0.0f) {
            this.interval.advance(amount);
            if (this.interval.intervalElapsed()) {
                WeaponAPI weapon = this.SAB.getWeapon();
                if (weapon == null) {
                    weapon = beam.getWeapon();
                    this.SAB.setWeapon(weapon);
                }
                float closestDist = Float.MAX_VALUE;
                MissileAPI target = (MissileAPI)this.SAB.getTarget();
                float aimOffset = 0.0f;
                if (target != null) {
                    aimOffset = MathUtils.getShortestRotation((float)weapon.getCurrAngle(), (float)VectorUtils.getAngle((Vector2f)beam.getFrom(), (Vector2f)target.getLocation()));
                }
                if (target == null || target.getCollisionClass() == CollisionClass.NONE || target.getOwner() == weapon.getShip().getOwner() || MathUtils.getDistance((Vector2f)beam.getFrom(), (Vector2f)target.getLocation()) > weapon.getRange() || Math.abs(aimOffset) > 3.0f) {
                    aimOffset = Float.MAX_VALUE;
                    for (MissileAPI m : engine.getMissiles()) {
                        float offset;
                        float dist;
                        if (m.getCollisionClass() == CollisionClass.NONE || m.getOwner() == weapon.getShip().getOwner() || (dist = MathUtils.getDistance((Vector2f)beam.getFrom(), (Vector2f)m.getLocation())) > weapon.getRange() || Math.abs(offset = MathUtils.getShortestRotation((float)weapon.getCurrAngle(), (float)VectorUtils.getAngle((Vector2f)beam.getFrom(), (Vector2f)m.getLocation()))) > 3.0f || !(Math.abs(offset) < Math.abs(aimOffset))) continue;
                        closestDist = dist;
                        aimOffset = offset;
                        target = m;
                        if (!(Math.random() < (double)0.1f)) continue;
                        break;
                    }
                }
                this.SAB.setTarget((CombatEntityAPI)target);
                this.SAB.setTargetAimOffset(aimOffset);
                this.SAB.setBeam(beam);
                localData.antiPhotonAimData.put(beam, this.SAB);
            }
        }
    }

    public class separatelyAimBeam {
        protected CombatEntityAPI target;
        protected float turnRate;
        protected float currAimOffset;
        protected float targetAimOffset;
        protected float maxAimOffset;
        protected float dither;
        protected BeamAPI beam;
        protected WeaponAPI weapon;
        protected boolean ditherDirct;

        public separatelyAimBeam(float maxAimOffset, float turnRate) {
            this.turnRate = turnRate;
            this.maxAimOffset = maxAimOffset;
            this.currAimOffset = 0.0f;
            this.target = null;
        }

        public BeamAPI getBeam() {
            return this.beam;
        }

        public void setBeam(BeamAPI beam) {
            this.beam = beam;
        }

        public float getCurrAimOffset() {
            return this.currAimOffset;
        }

        public void setCurrAimOffset(float currAimOffset) {
            this.currAimOffset = currAimOffset;
        }

        public float getMaxAimOffset() {
            return this.maxAimOffset;
        }

        public void setMaxAimOffset(float maxAimOffset) {
            this.maxAimOffset = maxAimOffset;
        }

        public CombatEntityAPI getTarget() {
            return this.target;
        }

        public void setTarget(CombatEntityAPI target) {
            this.target = target;
        }

        public float getTargetAimOffset() {
            return this.targetAimOffset;
        }

        public void setTargetAimOffset(float targetAimOffset) {
            this.targetAimOffset = targetAimOffset;
        }

        public float getTurnRate() {
            return this.turnRate;
        }

        public void setTurnRate(float turnRate) {
            this.turnRate = turnRate;
        }

        public WeaponAPI getWeapon() {
            return this.weapon;
        }

        public void setWeapon(WeaponAPI weapon) {
            this.weapon = weapon;
        }
    }
}

