/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.weapons;

import com.fs.starfarer.api.combat.BeamAPI;
import com.fs.starfarer.api.combat.BeamEffectPlugin;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.WeaponAPI;
import com.fs.starfarer.api.util.IntervalUtil;
import data.scripts.plugins.Neutrino_ExtraParticlePlugin;
import org.lazywizard.lazylib.MathUtils;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class NeutBeamParticleEffect
implements BeamEffectPlugin {
    private Vector2f lastWeaponLoc = new Vector2f();
    private float lastWeaponFacing = Float.NaN;
    private float amountReciprocal = 0.0f;
    private final IntervalUtil interval = new IntervalUtil(0.05f, 0.05f);

    public void advance(float amount, CombatEngineAPI engine, BeamAPI beam) {
        if (engine.isPaused()) {
            return;
        }
        WeaponAPI weapon = beam.getWeapon();
        if (this.lastWeaponFacing != Float.NaN) {
            this.amountReciprocal = 1.0f / amount;
            Vector2f vel = Vector2f.sub((Vector2f)weapon.getLocation(), (Vector2f)this.lastWeaponLoc, null);
            vel.scale(this.amountReciprocal);
            float angularVel = MathUtils.getShortestRotation((float)this.lastWeaponFacing, (float)weapon.getCurrAngle());
            float brightness = beam.getBrightness();
            if (brightness >= 0.5f) {
                this.interval.advance(amount);
                if (this.interval.intervalElapsed()) {
                    float width = beam.getWidth();
                    Neutrino_ExtraParticlePlugin.ParticleBeamPathEx(beam, 3.0f, 1, false, width * 0.3f, 2.0f, vel, angularVel, 200.0f, 300.0f, (int)(width * 0.1f), (int)(width * 0.2f), 0.8f, 1.0f, 0.2f, 0.6f, beam.getCoreColor());
                }
            }
        }
        this.lastWeaponLoc = new Vector2f((ReadableVector2f)weapon.getLocation());
        this.lastWeaponFacing = weapon.getCurrAngle();
    }
}

