/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.weapons;

import com.fs.starfarer.api.combat.BeamAPI;
import com.fs.starfarer.api.combat.BeamEffectPlugin;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.DamageType;
import com.fs.starfarer.api.combat.MissileAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ShipCommand;
import com.fs.starfarer.api.util.IntervalUtil;
import java.awt.Color;
import org.lazywizard.lazylib.MathUtils;
import org.lazywizard.lazylib.VectorUtils;
import org.lwjgl.util.vector.Vector2f;

public class NeutDisruptorEffect
implements BeamEffectPlugin {
    private final IntervalUtil disruptInterval = new IntervalUtil(0.05f, 0.05f);
    private final float disruptChance = 0.15f;
    private final float pushForcemax = 2.0f;
    private final float pushForcemin = 1.0f;
    private final float minTurn = 10.0f;
    private final float slowRate = 0.95f;
    private float timer = 0.0f;

    public void advance(float amount, CombatEngineAPI engine, BeamAPI beam) {
        if (engine.isPaused()) {
            return;
        }
        CombatEntityAPI target = beam.getDamageTarget();
        ShipAPI source = beam.getSource();
        if (beam.getBrightness() >= 0.5f && target != null && target instanceof MissileAPI) {
            MissileAPI hitMissile = (MissileAPI)target;
            float missileTurnAcc = hitMissile.getTurnAcceleration();
            boolean noguided = false;
            if (missileTurnAcc == 0.0f || hitMissile.isFading()) {
                noguided = true;
            }
            float TurnAcc = Math.max(missileTurnAcc, 10.0f);
            float MaxTurn = Math.max(hitMissile.getMaxTurnRate(), 10.0f);
            float AngularV = target.getAngularVelocity();
            Vector2f targetVel = target.getVelocity();
            float missileAimAngle = MathUtils.getShortestRotation((float)VectorUtils.getFacing((Vector2f)targetVel), (float)VectorUtils.getAngle((Vector2f)target.getLocation(), (Vector2f)source.getLocation()));
            targetVel.scale(0.95f);
            if (!noguided && Math.abs(missileAimAngle) < 7.0f) {
                target.setFacing(MathUtils.clampAngle((float)(target.getFacing() + Math.copySign(1.0f, -missileAimAngle))));
            }
            float missiletobeamAng = MathUtils.getShortestRotation((float)target.getFacing(), (float)VectorUtils.getAngle((Vector2f)beam.getTo(), (Vector2f)beam.getFrom()));
            if (MathUtils.getRandomNumberInRange((float)30.0f, (float)120.0f) - Math.abs(missiletobeamAng) > 0.0f) {
                target.setAngularVelocity(Math.copySign(Math.min(Math.abs(AngularV) + TurnAcc * amount, MaxTurn), -missileAimAngle));
                hitMissile.giveCommand(ShipCommand.ACCELERATE);
                hitMissile.giveCommand(-missileAimAngle < 0.0f ? ShipCommand.TURN_RIGHT : ShipCommand.TURN_LEFT);
            }
            this.disruptInterval.advance(beam.getDamage().getDpsDuration());
            this.timer += beam.getDamage().getDpsDuration();
            float finalDisruptChance = this.timer / beam.getWeapon().getDerivedStats().getBurstFireDuration() * 0.15f;
            if (this.disruptInterval.intervalElapsed()) {
                if (Math.random() <= (double)finalDisruptChance) {
                    engine.spawnEmpArc(source, target.getLocation(), target, target, DamageType.ENERGY, hitMissile.getMaxHitpoints() * 0.25f, 1.0f, 5.0f, null, 0.0f, Color.red, Color.red);
                }
                if (Math.random() <= (double)finalDisruptChance) {
                    hitMissile.flameOut();
                    engine.applyDamage(target, target.getLocation(), hitMissile.getMaxHitpoints() * 0.25f, DamageType.FRAGMENTATION, 0.0f, false, false, (Object)source);
                }
            }
        }
    }
}

