/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.weapons;

import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.EveryFrameWeaponEffectPlugin;
import com.fs.starfarer.api.combat.WeaponAPI;
import java.util.HashMap;
import java.util.Map;

public class NeutPulsarBeamEveryFrameEffect
implements EveryFrameWeaponEffectPlugin {
    private static final Map<WeaponAPI.WeaponSize, Integer> timer = new HashMap<WeaponAPI.WeaponSize, Integer>(3);
    private static final Map<WeaponAPI.WeaponSize, Float> factor;
    private int counter = 0;
    private float cooldownReduce = 0.0f;
    private boolean fired = false;
    private boolean skip = false;

    public void advance(float amount, CombatEngineAPI engine, WeaponAPI weapon) {
        if (weapon.getShip().getOriginalOwner() == -1 || weapon.getShip().isHulk()) {
            return;
        }
        if (!weapon.isFiring() && weapon.getChargeLevel() <= 0.0f) {
            if (this.skip || weapon.getCooldownRemaining() > 0.0f) {
                this.skip = false;
            } else {
                this.counter = 0;
                this.cooldownReduce = 0.0f;
                this.fired = false;
            }
        } else if (weapon.getChargeLevel() > 0.0f) {
            this.skip = true;
            if (!this.fired && weapon.getCooldownRemaining() > 0.0f) {
                this.counter = 1;
                this.cooldownReduce = weapon.getCooldown() * ((float)this.counter / (float)timer.get(weapon.getSize()).intValue()) * factor.get(weapon.getSize()).floatValue();
                this.fired = true;
            } else if (this.fired && weapon.getCooldownRemaining() != 0.0f && weapon.getCooldownRemaining() <= this.cooldownReduce + amount) {
                weapon.setRemainingCooldownTo(0.0f);
                if (this.counter < timer.get(weapon.getSize())) {
                    ++this.counter;
                    this.cooldownReduce = weapon.getCooldown() * ((float)this.counter / (float)timer.get(weapon.getSize()).intValue()) * factor.get(weapon.getSize()).floatValue();
                }
            }
        }
    }

    static {
        timer.put(WeaponAPI.WeaponSize.SMALL, 6);
        timer.put(WeaponAPI.WeaponSize.MEDIUM, 24);
        timer.put(WeaponAPI.WeaponSize.LARGE, 3);
        factor = new HashMap<WeaponAPI.WeaponSize, Float>(3);
        factor.put(WeaponAPI.WeaponSize.SMALL, Float.valueOf(0.41666666f));
        factor.put(WeaponAPI.WeaponSize.MEDIUM, Float.valueOf(0.6666666f));
        factor.put(WeaponAPI.WeaponSize.LARGE, Float.valueOf(0.41666666f));
    }
}

