/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.weapons;

import com.fs.starfarer.api.AnimationAPI;
import com.fs.starfarer.api.GameState;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.EveryFrameWeaponEffectPlugin;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.WeaponAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;

public class NeutRingEveryFrameEffect
implements EveryFrameWeaponEffectPlugin {
    private final float idleFPS = 10.0f;
    private final float activeFPS = 16.0f;
    private final float froceVentFPSMult = 2.0f;
    private final float deltaFPS = 2.0f;
    private final Color phaseColor = new Color(255, 175, 255, 255);
    private final String id = "Ring";
    private final float ringVentRange = 0.4f;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void advance(float amount, CombatEngineAPI engine, WeaponAPI weapon) {
        ShipAPI ship = weapon.getShip();
        float fluxLevel = ship.getFluxTracker().getFluxLevel();
        float overFluxRatio = 0.0f;
        if (ship.isPhased() && fluxLevel > 0.6f) {
            overFluxRatio = (fluxLevel + 0.4f - 1.0f) / 0.4f;
            float phaseCostRatio = 1.0f - 2.0f * overFluxRatio;
            ship.getMutableStats().getPhaseCloakUpkeepCostBonus().modifyMult("Ring", phaseCostRatio);
            float moveSlowRatio = Math.max(1.0f - overFluxRatio, 0.05f);
            ship.getMutableStats().getAcceleration().modifyMult("Ring", moveSlowRatio);
            ship.getMutableStats().getDeceleration().modifyMult("Ring", moveSlowRatio);
            ship.getMutableStats().getMaxSpeed().modifyMult("Ring", moveSlowRatio);
            ship.getMutableStats().getTurnAcceleration().modifyMult("Ring", moveSlowRatio);
            ship.getMutableStats().getMaxTurnRate().modifyMult("Ring", moveSlowRatio);
        } else {
            ship.getMutableStats().getPhaseCloakUpkeepCostBonus().unmodifyMult("Ring");
            ship.getMutableStats().getAcceleration().unmodifyMult("Ring");
            ship.getMutableStats().getDeceleration().unmodifyMult("Ring");
            ship.getMutableStats().getMaxSpeed().unmodifyMult("Ring");
            ship.getMutableStats().getTurnAcceleration().unmodifyMult("Ring");
            ship.getMutableStats().getMaxTurnRate().unmodifyMult("Ring");
        }
        AnimationAPI anime = weapon.getAnimation();
        float currentFPS = anime.getFrameRate();
        Color color = Misc.interpolateColor((Color)Color.WHITE, (Color)this.phaseColor, (float)ship.getPhaseCloak().getEffectLevel());
        if (ship.isHulk()) {
            if (!(currentFPS > 0.0f)) return;
            float setFPS = currentFPS - 2.0f * amount;
            if (setFPS < 0.0f) {
                setFPS = 0.0f;
            }
            anime.setFrameRate(setFPS);
            weapon.getSprite().setColor(color);
            return;
        } else if (ship.getPhaseCloak().isActive() && currentFPS < 16.0f * (overFluxRatio * 2.0f)) {
            float setFPS = currentFPS + 2.0f * amount;
            if (setFPS > 16.0f * (overFluxRatio * 2.0f)) {
                setFPS = 16.0f * (overFluxRatio * 2.0f);
            }
            anime.setFrameRate(setFPS);
            weapon.getSprite().setColor(color);
            ShipAPI playerShip = Global.getCombatEngine().getPlayerShip();
            if (Global.getCurrentState() != GameState.COMBAT || playerShip == null || playerShip.isHulk() || playerShip != ship) return;
            Global.getCombatEngine().maintainStatusForPlayerShip((Object)"Ring1", "graphics/neut/icons/hullsys/neutrino_PhaseCloak_StatusIcon.png", "Phase Ring", "Venting hard flux into p-space", false);
            Global.getCombatEngine().maintainStatusForPlayerShip((Object)"Ring2", "graphics/neut/icons/hullsys/neutrino_PhaseCloak_StatusIcon.png", "Phase Ring", "Ship speed reduced", true);
            return;
        } else {
            if (ship.getPhaseCloak().isCoolingDown() || !(currentFPS > 10.0f)) return;
            float setFPS = currentFPS - 2.0f * amount;
            if (setFPS < 10.0f) {
                setFPS = 10.0f;
            }
            anime.setFrameRate(setFPS);
            weapon.getSprite().setColor(color);
        }
    }
}

