/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.weapons;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.BeamAPI;
import com.fs.starfarer.api.combat.BeamEffectPlugin;
import com.fs.starfarer.api.combat.CollisionClass;
import com.fs.starfarer.api.combat.CombatAsteroidAPI;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.CombatEntityAPI;
import com.fs.starfarer.api.combat.DamageType;
import com.fs.starfarer.api.combat.MissileAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.graphics.SpriteAPI;
import com.fs.starfarer.api.util.IntervalUtil;
import data.scripts.NCModPlugin;
import data.scripts.hullmods.TEM_LatticeShield;
import data.scripts.plugins.Neutrino_FakeBeamPlugin;
import data.scripts.util.Neutrino_CollisionUtilsEX;
import data.scripts.util.Neutrino_ParticlesEffectLib;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.dark.shaders.distortion.DistortionAPI;
import org.dark.shaders.distortion.DistortionShader;
import org.dark.shaders.distortion.WaveDistortion;
import org.dark.shaders.light.LightAPI;
import org.dark.shaders.light.LightShader;
import org.dark.shaders.light.StandardLight;
import org.lazywizard.lazylib.CollisionUtils;
import org.lazywizard.lazylib.MathUtils;
import org.lazywizard.lazylib.VectorUtils;
import org.lazywizard.lazylib.combat.CombatUtils;
import org.lazywizard.lazylib.combat.entities.SimpleEntity;
import org.lwjgl.util.vector.ReadableVector2f;
import org.lwjgl.util.vector.Vector2f;

public class NeutSilverLanceEffect
implements BeamEffectPlugin {
    private final SpriteAPI beamSprite = Global.getSettings().getSprite("graphics/fx/beamcore.png");
    private final Color beamColor = Color.white;
    private final Color arcColor = new Color(200, 150, 200, 150);
    private final Color arcFringeColor = new Color(200, 200, 200, 75);
    private final float beamWidth = 12.0f;
    private final float duration = 0.1f;
    private final float fadeIn = 0.01f;
    private final float fadeOut = 0.01f;
    private final float particlesDensity = 5.0f;
    private final float hitSize = 50.0f;
    private final float shieldHitHardFulxRatio = 0.5f;
    private final float baseShieldHitDmg = 900.0f;
    private final float baseExtraHitDmg = 50.0f;
    private final float dmgMultAfterShieldHit = 0.1f;
    private final float baseHullHitDmg = 400.0f;
    private final float subDmg = 50.0f;
    private final float piercingDmgInterval = 15.0f;
    private final float EMPRatio = 0.1f;
    private final float EMPRatioAfterShield = 5.0f;
    private int times = 5;
    private final IntervalUtil firingInterval = new IntervalUtil(0.1f, 0.1f);
    private final Vector2f zero = new Vector2f(0.0f, 0.0f);
    private final List<PiercedEntity> PiercedEntities = new ArrayList<PiercedEntity>();
    private boolean firing = false;
    private boolean runOnce = false;

    public void advance(float amount, CombatEngineAPI engine, BeamAPI beam) {
        if (!this.runOnce) {
            this.firingInterval.forceIntervalElapsed();
            this.runOnce = true;
        }
        if (!this.firing && beam.getWeapon().getChargeLevel() >= 1.0f) {
            this.firing = true;
        }
        if (this.times > 0 && this.firing) {
            this.firingInterval.advance(amount);
            if (this.firingInterval.intervalElapsed()) {
                float mult = beam.getSource().getMutableStats().getBeamWeaponDamageMult().getModifiedValue() * beam.getSource().getMutableStats().getEnergyWeaponDamageMult().getModifiedValue();
                float fullDmg = beam.getWeapon().getDerivedStats().getBurstDamage() * mult / (float)this.times;
                float shieldHitDmg = 900.0f * mult;
                float extraHitDmg = 50.0f * mult;
                float hullHitDmg = 400.0f * mult;
                float dmg = fullDmg;
                ShipAPI source = beam.getSource();
                float range = beam.getWeapon().getRange();
                float facing = beam.getWeapon().getCurrAngle();
                Vector2f beamForm = beam.getWeapon().getLocation();
                Vector2f beamTo = MathUtils.getPointOnCircumference((Vector2f)beamForm, (float)range, (float)facing);
                Vector2f midPoint = MathUtils.getMidpoint((Vector2f)beamForm, (Vector2f)beamTo);
                DamageType damageType = beam.getWeapon().getDamageType();
                for (CombatEntityAPI e : CombatUtils.getEntitiesWithinRange((Vector2f)midPoint, (float)(range / 2.0f))) {
                    PiercedEntity piercedEntity;
                    if (e.getCollisionClass() == CollisionClass.NONE) continue;
                    if (e instanceof ShipAPI) {
                        ShipAPI s = (ShipAPI)e;
                        if (s == source || s.isFighter() && s.getOwner() == source.getOwner() || s.isPhased()) continue;
                        PiercedEntity piercedEntity2 = new PiercedEntity();
                        piercedEntity2.entity = e;
                        if (NCModPlugin.TemplarsExists && s.getVariant().getHullMods().contains("tem_latticeshield") && TEM_LatticeShield.shieldLevel((ShipAPI)s) > 0.0f) {
                            piercedEntity2.isLatticeShield = true;
                            piercedEntity2.shieldHit = piercedEntity2.hullHit = CollisionUtils.getCollisionPoint((Vector2f)beamForm, (Vector2f)beamTo, (CombatEntityAPI)e);
                        }
                        piercedEntity2.shieldHit = Neutrino_CollisionUtilsEX.getShieldCollisionPoint(beamForm, beamTo, s, false);
                        piercedEntity2.hullHit = CollisionUtils.getCollisionPoint((Vector2f)beamForm, (Vector2f)beamTo, (CombatEntityAPI)e);
                        if (piercedEntity2.hullHit == null && piercedEntity2.shieldHit == null) continue;
                        piercedEntity2.exit = CollisionUtils.getCollisionPoint((Vector2f)beamTo, (Vector2f)beamForm, (CombatEntityAPI)e);
                        this.PiercedEntities.add(piercedEntity2);
                    }
                    if (e instanceof CombatAsteroidAPI) {
                        piercedEntity = new PiercedEntity();
                        piercedEntity.entity = e;
                        piercedEntity.hullHit = Neutrino_CollisionUtilsEX.getCollisionPointOnCircle(beamForm, beamTo, e.getLocation(), e.getCollisionRadius());
                        if (piercedEntity.hullHit == null) continue;
                        piercedEntity.exit = Neutrino_CollisionUtilsEX.getCollisionPointOnCircle(beamTo, beamForm, e.getLocation(), e.getCollisionRadius());
                        this.PiercedEntities.add(piercedEntity);
                    }
                    if (!(e instanceof MissileAPI)) continue;
                    piercedEntity = new PiercedEntity();
                    piercedEntity.entity = e;
                    piercedEntity.hullHit = CollisionUtils.getCollisionPoint((Vector2f)beamForm, (Vector2f)beamTo, (CombatEntityAPI)e);
                    if (piercedEntity.hullHit == null) continue;
                    this.PiercedEntities.add(piercedEntity);
                }
                Vector2f tmp = new Vector2f((ReadableVector2f)beamForm);
                boolean end = false;
                if (!this.PiercedEntities.isEmpty()) {
                    if (this.PiercedEntities.size() > 1) {
                        Collections.sort(this.PiercedEntities, new SortByDistance(beamForm));
                    }
                    Vector2f beamDir = Vector2f.sub((Vector2f)beamTo, (Vector2f)beamForm, null);
                    for (PiercedEntity pe : this.PiercedEntities) {
                        if (pe.entity instanceof MissileAPI || pe.entity instanceof CombatAsteroidAPI) {
                            if (Vector2f.dot((Vector2f)beamDir, (Vector2f)Vector2f.sub((Vector2f)pe.hullHit, (Vector2f)tmp, null)) <= 0.0f) continue;
                            hullHitDmg = pe.entity.getMaxHitpoints() < hullHitDmg ? pe.entity.getMaxHitpoints() : hullHitDmg;
                            engine.applyDamage(pe.entity, pe.hullHit, hullHitDmg, damageType, 0.0f, false, true, (Object)source);
                            dmg -= hullHitDmg;
                            continue;
                        }
                        if (!(pe.entity instanceof ShipAPI)) continue;
                        ShipAPI ship = (ShipAPI)pe.entity;
                        float beamDmgMutl = ((ShipAPI)pe.entity).getMutableStats().getBeamDamageTakenMult().getModifiedValue();
                        boolean hitShield = false;
                        float targetShieldDmgFluxRaido = 1.0f;
                        if (pe.shieldHit != null) {
                            if (Vector2f.dot((Vector2f)beamDir, (Vector2f)Vector2f.sub((Vector2f)pe.shieldHit, (Vector2f)tmp, null)) <= 0.0f) continue;
                            Neutrino_FakeBeamPlugin.renderFakeBeam(tmp, pe.shieldHit, 12.0f, 0.1f, 0.01f, 0.01f, this.beamSprite, this.beamColor);
                            Neutrino_ParticlesEffectLib.AddParticlesOnSegment(tmp, pe.shieldHit, 5.0f, 2, false, 1.0f, 30.0f, 10.0f, 50.0f, 2, 4, 0.8f, 1.0f, 0.3f, 1.0f, Color.WHITE);
                            engine.addHitParticle(pe.shieldHit, this.zero, (float)Math.random() * 50.0f / 2.0f + 50.0f, 1.0f, (float)Math.random() * 0.1f / 2.0f + 0.1f, Color.WHITE);
                            engine.addHitParticle(pe.shieldHit, this.zero, (float)Math.random() * 50.0f / 4.0f + 25.0f, 1.0f, 0.1f, Color.WHITE);
                            tmp = pe.shieldHit;
                            targetShieldDmgFluxRaido = pe.isLatticeShield ? 0.8f : ship.getShield().getFluxPerPointOfDamage();
                            float dmgOnshield = shieldHitDmg * (targetShieldDmgFluxRaido == 0.0f ? 100.0f : 1.0f / targetShieldDmgFluxRaido);
                            if (dmg <= dmgOnshield) {
                                dmgOnshield = dmg;
                                beamTo = pe.shieldHit;
                                end = true;
                            }
                            engine.applyDamage((CombatEntityAPI)ship, pe.shieldHit, dmgOnshield * 0.5f * beamDmgMutl, damageType, 0.0f, false, false, (Object)source);
                            engine.applyDamage((CombatEntityAPI)ship, pe.shieldHit, dmgOnshield * 0.5f * beamDmgMutl, damageType, 0.0f, false, true, (Object)source);
                            if (end) break;
                            hitShield = true;
                            dmg -= dmgOnshield;
                            for (int j = 0; j < 4; ++j) {
                                float critChance = ship.getFluxTracker().getFluxLevel();
                                if (!(Math.random() < (double)critChance)) continue;
                                if (dmg <= extraHitDmg) {
                                    extraHitDmg = dmg;
                                    beamTo = pe.shieldHit;
                                    end = true;
                                }
                                SimpleEntity ramdon = new SimpleEntity(MathUtils.getRandomPointOnCircumference((Vector2f)pe.shieldHit, (float)MathUtils.getRandomNumberInRange((int)0, (int)1)));
                                engine.spawnEmpArc(source, pe.shieldHit, (CombatEntityAPI)ramdon, (CombatEntityAPI)ramdon, damageType, 0.0f, 0.0f, 0.0f, null, 20.0f, this.arcColor, this.arcFringeColor);
                                engine.applyDamage((CombatEntityAPI)ship, ramdon.getLocation(), extraHitDmg, damageType, 0.0f, false, false, (Object)source);
                                if (end) break;
                                dmg -= extraHitDmg;
                            }
                            if (end) break;
                        }
                        if (pe.hullHit == null || !pe.isLatticeShield && Vector2f.dot((Vector2f)beamDir, (Vector2f)Vector2f.sub((Vector2f)pe.hullHit, (Vector2f)tmp, null)) <= 0.0f) continue;
                        Neutrino_FakeBeamPlugin.renderFakeBeam(tmp, pe.hullHit, 12.0f, 0.1f, 0.01f, 0.01f, this.beamSprite, this.beamColor);
                        Neutrino_ParticlesEffectLib.AddParticlesOnSegment(tmp, pe.hullHit, 5.0f, 2, false, 1.0f, 30.0f, 10.0f, 50.0f, 2, 4, 0.8f, 1.0f, 0.3f, 1.0f, Color.WHITE);
                        engine.addHitParticle(pe.hullHit, this.zero, (float)Math.random() * 50.0f / 2.0f + 50.0f, 1.0f, (float)Math.random() * 0.1f / 2.0f + 0.1f, Color.WHITE);
                        engine.addHitParticle(pe.hullHit, this.zero, (float)Math.random() * 50.0f / 4.0f + 25.0f, 1.0f, 0.1f, Color.WHITE);
                        float dmgOnHull = hullHitDmg;
                        if (hitShield) {
                            dmgOnHull *= 0.1f;
                        }
                        if (dmg <= dmgOnHull) {
                            dmgOnHull = dmg;
                            beamTo = pe.hullHit;
                            end = true;
                        }
                        engine.applyDamage((CombatEntityAPI)ship, pe.hullHit, dmgOnHull * beamDmgMutl, damageType, dmgOnHull, true, false, (Object)source);
                        dmg -= dmgOnHull;
                        if (end) break;
                        float critChance = ship.getFluxTracker().getFluxLevel() * 0.5f + 0.2f;
                        for (int j = 0; j < 4; ++j) {
                            if (!(Math.random() < (double)critChance)) continue;
                            if (dmg <= extraHitDmg) {
                                extraHitDmg = dmg;
                                beamTo = pe.shieldHit;
                                end = true;
                            }
                            engine.spawnEmpArcPierceShields(source, pe.hullHit, (CombatEntityAPI)ship, (CombatEntityAPI)ship, damageType, extraHitDmg, extraHitDmg, 200.0f, null, 15.0f, this.arcColor, this.arcFringeColor);
                            if (end) break;
                            dmg -= extraHitDmg;
                        }
                        if (end) break;
                        if (Vector2f.dot((Vector2f)pe.exit, (Vector2f)beamTo) <= 0.0f) {
                            pe.exit = beamTo;
                            end = true;
                        }
                        float piercingDmg = 50.0f * mult;
                        float piercingEMP = piercingDmg * 0.1f;
                        if (hitShield) {
                            piercingEMP *= 5.0f;
                        }
                        float piercingSubDmg = piercingDmg;
                        if (hitShield) {
                            piercingSubDmg *= 0.1f;
                            piercingEMP *= 0.1f * targetShieldDmgFluxRaido;
                        }
                        Vector2f dir = VectorUtils.getDirectionalVector((Vector2f)pe.hullHit, (Vector2f)pe.exit);
                        dir.scale(15.0f);
                        Vector2f pTmp = new Vector2f((ReadableVector2f)pe.hullHit);
                        while (dmg > 0.0f && Vector2f.dot((Vector2f)dir, (Vector2f)Vector2f.sub((Vector2f)pe.exit, (Vector2f)pTmp, null)) > 0.0f) {
                            if (dmg <= piercingDmg) {
                                piercingDmg = dmg;
                                beamTo = pTmp;
                                end = true;
                            }
                            if (!hitShield && Math.random() < (double)critChance) {
                                ship.getMutableStats().getEffectiveArmorBonus().modifyMult("NeutSilverLanceEffect", 0.0f);
                            }
                            if (Math.random() < 0.05 + (double)critChance * 0.1) {
                                SimpleEntity ramdon = new SimpleEntity(MathUtils.getRandomPointOnCircumference((Vector2f)pTmp, (float)MathUtils.getRandomNumberInRange((int)15, (int)20)));
                                engine.spawnEmpArcPierceShields(source, ramdon.getLocation(), (CombatEntityAPI)ramdon, (CombatEntityAPI)ship, damageType, extraHitDmg, extraHitDmg, 130.0f, null, 20.0f, this.arcColor, this.arcFringeColor);
                                dmg -= extraHitDmg;
                            }
                            engine.applyDamage(pe.entity, pTmp, piercingSubDmg * beamDmgMutl, damageType, piercingEMP, true, false, (Object)source);
                            Vector2f.add((Vector2f)pTmp, (Vector2f)dir, (Vector2f)pTmp);
                            dmg -= piercingDmg;
                            ship.getMutableStats().getEffectiveArmorBonus().unmodify("NeutSilverLanceEffect");
                        }
                        if (end) break;
                        if (ship.isFighter() || !this.PiercedEntities.iterator().hasNext() || CollisionUtils.isPointWithinBounds((Vector2f)beamTo, (CombatEntityAPI)ship)) continue;
                        tmp = pe.exit;
                        engine.applyDamage(pe.entity, tmp, piercingSubDmg * beamDmgMutl, damageType, piercingEMP, true, false, (Object)source);
                        Neutrino_ParticlesEffectLib.AddParticles(10, 1, false, tmp, 5.0f, facing, 30.0f, 30.0f, 200.0f, 3, 5, 0.8f, 1.0f, 0.5f, 2.0f, Color.WHITE);
                    }
                }
                if (!end) {
                    Neutrino_FakeBeamPlugin.renderFakeBeam(tmp, beamTo, 12.0f, 0.1f, 0.01f, 0.01f, this.beamSprite, this.beamColor);
                    Neutrino_ParticlesEffectLib.AddParticlesOnSegment(tmp, beamTo, 5.0f, 2, false, 1.0f, 30.0f, 10.0f, 50.0f, 2, 4, 0.8f, 1.0f, 0.3f, 1.0f, Color.WHITE);
                }
                this.PiercedEntities.clear();
                Global.getSoundPlayer().playSound("neutrino_silverlance_fire", 1.0f, 1.0f, beamForm, this.zero);
                WaveDistortion wave = new WaveDistortion();
                wave.setLocation(beamForm);
                wave.setIntensity(5.0f);
                wave.setLifetime(0.08f);
                wave.setSize(MathUtils.getDistance((Vector2f)beamForm, (Vector2f)beamTo));
                wave.setArc(facing + 180.0f - 2.5f, facing + 180.0f + 2.5f);
                wave.setArcAttenuationWidth(5.0f);
                DistortionShader.addDistortion((DistortionAPI)wave);
                StandardLight light = new StandardLight();
                light.setType(1);
                light.setLocation(beamForm);
                light.setLocation2(beamTo);
                light.setColor(new Color(255, 255, 255, 100));
                light.setSize(25.0f);
                light.setIntensity(1.0f);
                light.fadeOut(0.3f);
                LightShader.addLight((LightAPI)light);
                --this.times;
            }
        }
    }

    public static class SortByDistance
    implements Comparator<PiercedEntity> {
        private final Vector2f location;

        public SortByDistance(Vector2f location) {
            this.location = location;
        }

        @Override
        public int compare(PiercedEntity o1, PiercedEntity o2) {
            return Float.compare(MathUtils.getDistanceSquared((Vector2f)(o1.shieldHit == null ? o1.hullHit : o1.shieldHit), (Vector2f)this.location), MathUtils.getDistanceSquared((Vector2f)(o2.shieldHit == null ? o2.hullHit : o2.shieldHit), (Vector2f)this.location));
        }
    }

    public static class PiercedEntity {
        protected Vector2f shieldHit = null;
        protected Vector2f hullHit = null;
        protected Vector2f exit = null;
        protected CombatEntityAPI entity = null;
        protected boolean isLatticeShield = false;
    }
}

