/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.weapons;

import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.EveryFrameWeaponEffectPlugin;
import com.fs.starfarer.api.combat.WeaponAPI;
import com.fs.starfarer.api.util.IntervalUtil;
import com.fs.starfarer.api.util.Misc;
import data.scripts.util.Neutrino_ParticlesEffectLib;
import java.awt.Color;
import org.lazywizard.lazylib.MathUtils;
import org.lwjgl.util.vector.Vector2f;

public class NeutSilverLanceEveryFrameWeaponEffect
implements EveryFrameWeaponEffectPlugin {
    private float aim = 0.0f;
    private final IntervalUtil interval = new IntervalUtil(0.05f, 0.1f);

    public void advance(float amount, CombatEngineAPI engine, WeaponAPI weapon) {
        if (weapon.getShip().getOriginalOwner() == -1 || weapon.getShip().isHulk()) {
            return;
        }
        if (weapon.isFiring()) {
            float chargeLevel;
            float diff = MathUtils.getShortestRotation((float)this.aim, (float)weapon.getCurrAngle());
            if (Math.abs(diff) > weapon.getTurnRate() * amount) {
                diff = Math.copySign(weapon.getTurnRate() * amount, diff);
            }
            float aimTo = MathUtils.clampAngle((float)(this.aim + diff));
            weapon.setCurrAngle(aimTo);
            float outOfArc = weapon.distanceFromArc(Vector2f.add((Vector2f)weapon.getLocation(), (Vector2f)Misc.getUnitVectorAtDegreeAngle((float)aimTo), null));
            if (outOfArc != 0.0f) {
                float newAngV = Math.abs(weapon.getShip().getAngularVelocity()) < weapon.getTurnRate() ? Math.copySign(weapon.getShip().getAngularVelocity(), outOfArc) : Math.copySign(weapon.getTurnRate(), outOfArc);
                weapon.getShip().setAngularVelocity(newAngV);
            }
            if ((double)(chargeLevel = weapon.getChargeLevel()) > 0.2) {
                this.interval.advance(amount);
                if (this.interval.intervalElapsed()) {
                    Neutrino_ParticlesEffectLib.ParticlesRay(weapon.getLocation(), MathUtils.getPointOnCircumference((Vector2f)weapon.getLocation(), (float)75.0f, (float)this.aim), 0.5f + chargeLevel, 2, false, 3.0f, 0.0f, weapon.getShip().getVelocity(), 0.0f, 50.0f + chargeLevel * 100.0f, 50.0f + chargeLevel * 200.0f, 2, 5, chargeLevel, 1.0f, 0.2f, 1.0f, Color.white, false);
                }
            }
        }
        this.aim = weapon.getCurrAngle();
    }
}

