/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.world;

import com.fs.starfarer.api.EveryFrameScript;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CampaignClockAPI;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.LocationAPI;
import com.fs.starfarer.api.campaign.SectorAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.SpawnPointPlugin;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class BaseSpawnPoint
implements EveryFrameScript,
SpawnPointPlugin {
    protected float daysInterval;
    private int maxFleets;
    private SectorEntityToken anchor;
    private List fleets = new ArrayList();
    private long lastSpawnTime = Long.MIN_VALUE;
    public SectorAPI sector;
    private LocationAPI location;

    public BaseSpawnPoint(SectorAPI sector, LocationAPI location, float daysInterval, int maxFleets, SectorEntityToken anchor) {
        this.daysInterval = daysInterval;
        this.maxFleets = maxFleets;
        this.anchor = anchor;
        this.sector = sector;
        this.location = location;
        this.lastSpawnTime = Global.getSector().getClock().getTimestamp();
    }

    public void advance(SectorAPI sector, LocationAPI location) {
        this.advance(0.0f);
    }

    public void advance(float amount) {
        CampaignClockAPI clock = this.sector.getClock();
        if (clock.getElapsedDaysSince(this.lastSpawnTime) >= this.daysInterval) {
            CampaignFleetAPI fleet;
            this.lastSpawnTime = clock.getTimestamp();
            Iterator iter = this.fleets.iterator();
            while (iter.hasNext()) {
                fleet = (CampaignFleetAPI)iter.next();
                if (fleet.isAlive()) continue;
                iter.remove();
            }
            if (this.fleets.size() < this.maxFleets && (fleet = this.spawnFleet()) != null) {
                this.fleets.add(fleet);
            }
        }
    }

    public boolean isDone() {
        return false;
    }

    public boolean runWhilePaused() {
        return false;
    }

    public float getDaysInterval() {
        return this.daysInterval;
    }

    public int getMaxFleets() {
        return this.maxFleets;
    }

    public SectorEntityToken getAnchor() {
        return this.anchor;
    }

    public List getFleets() {
        return this.fleets;
    }

    public long getLastSpawnTime() {
        return this.lastSpawnTime;
    }

    public SectorAPI getSector() {
        return this.sector;
    }

    public LocationAPI getLocation() {
        return this.location;
    }

    protected abstract CampaignFleetAPI spawnFleet();
}

