/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.world.systems;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.CustomCampaignEntityAPI;
import com.fs.starfarer.api.campaign.JumpPointAPI;
import com.fs.starfarer.api.campaign.OrbitAPI;
import com.fs.starfarer.api.campaign.PlanetAPI;
import com.fs.starfarer.api.campaign.SectorAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import com.fs.starfarer.api.impl.campaign.procgen.NebulaEditor;
import com.fs.starfarer.api.impl.campaign.terrain.BaseTiledTerrain;
import com.fs.starfarer.api.impl.campaign.terrain.HyperspaceTerrainPlugin;
import com.fs.starfarer.api.util.Misc;
import data.scripts.world.NeutrinoAddMarket;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;

public class CoronaAustralis {
    public void generate(SectorAPI sector) {
        StarSystemAPI system = sector.createStarSystem("Corona Australis");
        system.getLocation().set(-15200.0f, -3400.0f);
        HyperspaceTerrainPlugin hyper = (HyperspaceTerrainPlugin)Misc.getHyperspaceTerrain().getPlugin();
        NebulaEditor editor = new NebulaEditor((BaseTiledTerrain)hyper);
        editor.regenNoise();
        editor.clearArc(-15200.0f, -3400.0f, 0.0f, 500.0f, 0.0f, 360.0f);
        system.setBackgroundTextureFilename("graphics/neut/backgrounds/CoronaAustralis.jpg");
        PlanetAPI star = system.initStar("neutronstar", "star_neutron", 48.0f, 400.0f, 10.0f, 5.0f, 5.0f);
        system.setLightColor(new Color(255, 255, 255));
        PlanetAPI p1 = system.addPlanet("is7", (SectorEntityToken)star, "IS7", "rocky_unstable", 10.0f, 150.0f, 4700.0f, 100.0f);
        CustomCampaignEntityAPI relay = system.addCustomEntity("CoronaAustralis_relay", "Data Storage Complex", "comm_relay", "neutrinocorp");
        relay.setCircularOrbit((SectorEntityToken)p1, 90.0f, 650.0f, 80.0f);
        p1.getSpec().setPlanetColor(new Color(255, 215, 190, 255));
        p1.getSpec().setAtmosphereColor(new Color(160, 110, 45, 140));
        p1.getSpec().setCloudColor(new Color(255, 164, 96, 200));
        p1.setCircularOrbitPointingDown((SectorEntityToken)star, 10.0f, 4700.0f, 100.0f);
        p1.getSpec().setTilt(10.0f);
        p1.applySpecChanges();
        system.addAsteroidBelt((SectorEntityToken)p1, 50, 1100.0f, 128.0f, 40.0f, 80.0f);
        system.addRingBand((SectorEntityToken)star, "misc", "rings_dust0", 256.0f, 0, Color.white, 256.0f, 400.0f, 70.0f);
        system.addRingBand((SectorEntityToken)star, "misc", "rings_dust0", 256.0f, 2, Color.white, 256.0f, 475.0f, -60.0f);
        system.addRingBand((SectorEntityToken)star, "misc", "rings_dust0", 256.0f, 1, Color.white, 256.0f, 550.0f, 80.0f);
        system.addRingBand((SectorEntityToken)star, "misc", "rings_dust0", 256.0f, 2, Color.white, 256.0f, 475.0f, -60.0f);
        system.addRingBand((SectorEntityToken)star, "misc", "rings_dust0", 256.0f, 3, Color.white, 256.0f, 375.0f, 50.0f);
        system.addRingBand((SectorEntityToken)star, "misc", "rings_dust0", 256.0f, 2, Color.white, 256.0f, 700.0f, 110.0f);
        system.addRingBand((SectorEntityToken)star, "misc", "rings_dust0", 256.0f, 3, Color.white, 256.0f, 875.0f, -70.0f);
        system.addRingBand((SectorEntityToken)star, "misc", "rings_dust0", 256.0f, 2, Color.white, 256.0f, 950.0f, 90.0f);
        system.addRingBand((SectorEntityToken)star, "misc", "rings_dust0", 256.0f, 3, Color.white, 256.0f, 1025.0f, 110.0f);
        system.addRingBand((SectorEntityToken)star, "misc", "rings_dust0", 256.0f, 1, Color.white, 256.0f, 950.0f, -90.0f);
        system.addRingBand((SectorEntityToken)star, "misc", "rings_dust0", 256.0f, 2, Color.white, 256.0f, 1200.0f, -110.0f);
        system.addRingBand((SectorEntityToken)star, "misc", "rings_dust0", 256.0f, 1, Color.white, 256.0f, 1375.0f, 90.0f);
        system.addRingBand((SectorEntityToken)star, "misc", "rings_dust0", 256.0f, 0, Color.white, 256.0f, 1400.0f, -50.0f);
        system.addRingBand((SectorEntityToken)star, "misc", "rings_dust0", 256.0f, 3, Color.white, 256.0f, 1450.0f, 70.0f);
        system.addRingBand((SectorEntityToken)star, "misc", "rings_dust0", 256.0f, 0, Color.white, 256.0f, 1500.0f, 80.0f);
        system.addAsteroidBelt((SectorEntityToken)star, 50, 500.0f, 200.0f, 10.0f, -35.0f);
        system.addAsteroidBelt((SectorEntityToken)star, 50, 900.0f, 200.0f, 10.0f, 55.0f);
        system.addAsteroidBelt((SectorEntityToken)star, 50, 1200.0f, 200.0f, 10.0f, 45.0f);
        system.addAsteroidBelt((SectorEntityToken)star, 50, 1500.0f, 200.0f, 10.0f, -35.0f);
        system.addRingBand((SectorEntityToken)p1, "misc", "rings_dust0", 256.0f, 2, Color.white, 256.0f, 250.0f, 60.0f);
        system.addRingBand((SectorEntityToken)p1, "misc", "rings_dust0", 256.0f, 1, Color.white, 256.0f, 325.0f, 40.0f);
        system.addRingBand((SectorEntityToken)p1, "misc", "rings_dust0", 256.0f, 2, Color.white, 256.0f, 400.0f, 60.0f);
        system.addRingBand((SectorEntityToken)p1, "misc", "rings_dust0", 256.0f, 3, Color.white, 256.0f, 550.0f, 70.0f);
        system.addRingBand((SectorEntityToken)p1, "misc", "rings_dust0", 256.0f, 3, Color.white, 256.0f, 650.0f, 90.0f);
        system.addRingBand((SectorEntityToken)p1, "misc", "rings_dust0", 256.0f, 2, Color.white, 256.0f, 750.0f, 110.0f);
        system.addAsteroidBelt((SectorEntityToken)p1, 50, 400.0f, 200.0f, 10.0f, -70.0f);
        system.addAsteroidBelt((SectorEntityToken)p1, 50, 800.0f, 200.0f, 10.0f, 90.0f);
        JumpPointAPI jumpPoint = Global.getFactory().createJumpPoint("stalin", "Jump Point Alpha");
        OrbitAPI orbit = Global.getFactory().createCircularOrbit((SectorEntityToken)star, 55.0f, 4700.0f, 100.0f);
        jumpPoint.setOrbit(orbit);
        jumpPoint.setRelatedPlanet((SectorEntityToken)p1);
        jumpPoint.setStandardWormholeToHyperspaceVisual();
        system.addEntity((SectorEntityToken)jumpPoint);
        CustomCampaignEntityAPI NCstation1 = system.addCustomEntity("neut_smalldrill", "Small Extraction Drill", "neutrino_station_smalldrill", "neutrinocorp");
        NCstation1.setCircularOrbitPointingDown((SectorEntityToken)star, 200.0f, 700.0f, 90.0f);
        NCstation1.setCustomDescriptionId("neut_station_smalldrill");
        CustomCampaignEntityAPI NCstation2 = system.addCustomEntity("neut_largeprocessing", "Large Processing Dock", "neutrino_station_largeprocessing", "neutrinocorp");
        NCstation2.setCircularOrbitPointingDown((SectorEntityToken)star, 200.0f, 1750.0f, 90.0f);
        NCstation2.setCustomDescriptionId("neut_station_largeprocessing");
        CustomCampaignEntityAPI NCstation3 = system.addCustomEntity("neut_experimental", "Small Research Station", "neutrino_station_experimental", "neutrinocorp");
        NCstation3.setCircularOrbitPointingDown((SectorEntityToken)p1, 10.0f, 500.0f, 100.0f);
        NCstation3.setCustomDescriptionId("neut_station_experimental");
        MarketAPI NCSM1 = NeutrinoAddMarket.addMarketplace("neutrinocorp", (SectorEntityToken)NCstation1, null, "Small Extraction Drill", 2, new ArrayList<String>(Arrays.asList("neutrino_star_fuel_produce", "ore_complex", "ore_complex", "population_2")), new ArrayList<String>(Arrays.asList("open_market", "black_market", "storage")), 0.3f);
        MarketAPI NCSM2 = NeutrinoAddMarket.addMarketplace("neutrinocorp", (SectorEntityToken)NCstation2, null, "Large Processing Dock", 6, new ArrayList<String>(Arrays.asList("urbanized_polity", "regional_capital", "orbital_station", "military_base", "ore_refining_complex", "light_industrial_complex", "autofac_heavy_industry", "population_5")), new ArrayList<String>(Arrays.asList("open_market", "generic_military", "black_market", "storage")), 0.3f);
        MarketAPI NCSM3 = NeutrinoAddMarket.addMarketplace("neutrinocorp", (SectorEntityToken)NCstation3, null, "Small Research Station", 3, new ArrayList<String>(Arrays.asList("neutrino_planetoid_mining", "neutrino_small_hydroponics", "free_market", "outpost", "military_base", "vice_demand", "population_3")), new ArrayList<String>(Arrays.asList("open_market", "generic_military", "black_market", "storage")), 0.3f);
        system.autogenerateHyperspaceJumpPoints(true, true);
    }
}

