/*
 * Decompiled with CFR 0.152.
 */
package data.scripts.world.systems;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.campaign.PlanetAPI;
import com.fs.starfarer.api.campaign.SectorAPI;
import com.fs.starfarer.api.campaign.SectorEntityToken;
import com.fs.starfarer.api.campaign.StarSystemAPI;
import com.fs.starfarer.api.campaign.econ.MarketAPI;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class Exelion {
    public void generate(SectorAPI sector) {
        Random random = new Random();
        Long seed = sector.getSeedString().hashCode();
        random.setSeed(seed);
        List systems = sector.getStarSystems();
        ArrayList<Object> tagets = new ArrayList<Object>();
        for (StarSystemAPI s : systems) {
            if (!s.isProcgen() || !s.getStar().getSpec().isBlackHole()) continue;
            tagets.add(s);
        }
        while (tagets.size() < 5) {
            int j = random.nextInt(systems.size());
            tagets.add(systems.get(j));
        }
        StarSystemAPI system = (StarSystemAPI)tagets.get(random.nextInt(tagets.size()));
        PlanetAPI star = system.getStar();
        SectorEntityToken NCAbandonedStation = system.addOrbitalStation("neut_exelionabandoned", (SectorEntityToken)star, 200.0f, 2050.0f, 90.0f, "Abandoned Neutrino Facility", "neutral");
        NCAbandonedStation.getMemory().set("$abandonedStation", (Object)true);
        NCAbandonedStation.setSensorProfile(Float.valueOf(600.0f));
        NCAbandonedStation.setDiscoverable(Boolean.valueOf(true));
        MarketAPI market = Global.getFactory().createMarket("exelion_abandoned_station_market", NCAbandonedStation.getName(), 0);
        market.setPrimaryEntity(NCAbandonedStation);
        market.setFactionId(NCAbandonedStation.getFaction().getId());
        market.addCondition("abandoned_station");
        market.addSubmarket("neutrino_abandon");
        NCAbandonedStation.setMarket(market);
        NCAbandonedStation.setCustomDescriptionId("neut_abandoned");
        NCAbandonedStation.setInteractionImage("illustrations", "abandoned_station");
    }
}

