/*
 * Decompiled with CFR 0.152.
 */
package data.shipsystems.scripts;

import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.impl.combat.BaseShipSystemScript;
import com.fs.starfarer.api.plugins.ShipSystemStatsScript;

public class NeutrinoCruiseEngineStats
extends BaseShipSystemScript {
    public void apply(MutableShipStatsAPI stats, String id, ShipSystemStatsScript.State state, float effectLevel) {
        if (state == ShipSystemStatsScript.State.OUT) {
            stats.getMaxSpeed().unmodify(id);
            stats.getMaxTurnRate().unmodify(id);
        } else {
            stats.getMaxSpeed().modifyFlat(id, 140.0f);
            stats.getTurnAcceleration().modifyFlat(id, -4.0f * effectLevel);
            stats.getTurnAcceleration().modifyPercent(id, 50.0f * effectLevel);
            stats.getMaxTurnRate().modifyFlat(id, -6.0f);
            stats.getAcceleration().modifyPercent(id, 66.0f * effectLevel);
            stats.getDeceleration().modifyPercent(id, 66.0f * effectLevel);
        }
    }

    public void unapply(MutableShipStatsAPI stats, String id) {
        stats.getMaxSpeed().unmodify(id);
        stats.getMaxTurnRate().unmodify(id);
        stats.getTurnAcceleration().unmodify(id);
        stats.getAcceleration().unmodify(id);
        stats.getDeceleration().unmodify(id);
    }

    public ShipSystemStatsScript.StatusData getStatusData(int index, ShipSystemStatsScript.State state, float effectLevel) {
        if (index == 0) {
            return new ShipSystemStatsScript.StatusData("cruise control engaged", false);
        }
        if (index == 1) {
            return new ShipSystemStatsScript.StatusData("remember to fasten all loose items", false);
        }
        return null;
    }
}

