/*
 * Decompiled with CFR 0.152.
 */
package data.shipsystems.scripts;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.FluxTrackerAPI;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ShipSystemAPI;
import com.fs.starfarer.api.impl.combat.BaseShipSystemScript;
import com.fs.starfarer.api.plugins.ShipSystemStatsScript;
import data.scripts.plugins.Neutrino_LocalData;
import java.math.BigDecimal;
import java.math.RoundingMode;

public class NeutrinoGuardianShieldStats
extends BaseShipSystemScript {
    private static final String KEY = "Neutrino_LocalData";

    public void apply(MutableShipStatsAPI stats, String id, ShipSystemStatsScript.State state, float effectLevel) {
        ShipAPI sheild;
        stats.getZeroFluxMinimumFluxLevel().modifyMult(id, 0.0f);
        ShipAPI ship = (ShipAPI)stats.getEntity();
        if (ship != null && !ship.getChildModulesCopy().isEmpty() && (sheild = (ShipAPI)ship.getChildModulesCopy().get(0)).isAlive()) {
            sheild.getShield().toggleOn();
        }
    }

    public void unapply(MutableShipStatsAPI stats, String id) {
        ShipAPI sheild;
        stats.getZeroFluxMinimumFluxLevel().unmodify();
        ShipAPI ship = (ShipAPI)stats.getEntity();
        if (ship != null && !ship.getChildModulesCopy().isEmpty() && (sheild = (ShipAPI)ship.getChildModulesCopy().get(0)).isAlive()) {
            sheild.getShield().toggleOff();
        }
    }

    public ShipSystemStatsScript.StatusData getStatusData(int index, ShipSystemStatsScript.State state, float effectLevel) {
        return null;
    }

    public String getInfoText(ShipSystemAPI system, ShipAPI ship) {
        CombatEngineAPI engine = Global.getCombatEngine();
        if (engine == null || ship != engine.getPlayerShip()) {
            return null;
        }
        Neutrino_LocalData.LocalData localData = (Neutrino_LocalData.LocalData)engine.getCustomData().get(KEY);
        if (localData.guardianShieldMap.containsKey(ship)) {
            ShipAPI drone = localData.guardianShieldMap.get(ship);
            if (drone.isAlive()) {
                FluxTrackerAPI shieldFlux = drone.getFluxTracker();
                if (shieldFlux.isOverloaded()) {
                    return "Warning! Shield Core Overloaded!";
                }
                String state = system.isOn() ? "Actived: Flux Capacity At " : "Standby: Flux Capacity At ";
                float fluxLevel = shieldFlux.getFluxLevel();
                BigDecimal b = new BigDecimal(fluxLevel *= 100.0f);
                String fluxLevelS = b.setScale(2, RoundingMode.HALF_UP).toString();
                String data = state + fluxLevelS + "%";
                return data;
            }
            return "Warning! Shield Core Ejected!";
        }
        return null;
    }

    public boolean isUsable(ShipSystemAPI system, ShipAPI ship) {
        CombatEngineAPI engine = Global.getCombatEngine();
        Neutrino_LocalData.LocalData localData = (Neutrino_LocalData.LocalData)engine.getCustomData().get(KEY);
        if (localData.guardianShieldMap.containsKey(ship)) {
            ShipAPI drone = localData.guardianShieldMap.get(ship);
            return drone != null && drone.isAlive();
        }
        return false;
    }
}

