/*
 * Decompiled with CFR 0.152.
 */
package data.shipsystems.scripts;

import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.impl.combat.BaseShipSystemScript;
import com.fs.starfarer.api.plugins.ShipSystemStatsScript;

public class NeutrinoHighEnergyFuryStats
extends BaseShipSystemScript {
    public static final float DAMAGE_BONUS_PERCENT = 25.0f;
    public static final float ROF_BONUS_PERCENT = 25.0f;
    public static final float FLUX_REDUCTION = 15.0f;

    public void apply(MutableShipStatsAPI stats, String id, ShipSystemStatsScript.State state, float effectLevel) {
        float damageBonusPercent = 25.0f * effectLevel;
        stats.getEnergyWeaponDamageMult().modifyPercent(id, damageBonusPercent);
        float ROFBonusPercent = 25.0f * effectLevel;
        stats.getEnergyRoFMult().modifyPercent(id, ROFBonusPercent);
        float fluxReduction = -15.0f * effectLevel;
        stats.getEnergyWeaponFluxCostMod().modifyPercent(id, fluxReduction);
        if (state == ShipSystemStatsScript.State.OUT) {
            stats.getZeroFluxMinimumFluxLevel().unmodify(id);
        } else {
            stats.getZeroFluxMinimumFluxLevel().modifyFlat(id, 1.0f);
        }
    }

    public void unapply(MutableShipStatsAPI stats, String id) {
        stats.getEnergyWeaponDamageMult().unmodify(id);
        stats.getEnergyRoFMult().unmodify(id);
        stats.getEnergyWeaponFluxCostMod().unmodify(id);
        stats.getShieldDamageTakenMult().unmodify(id);
        stats.getZeroFluxMinimumFluxLevel().unmodify(id);
    }

    public ShipSystemStatsScript.StatusData getStatusData(int index, ShipSystemStatsScript.State state, float effectLevel) {
        float damageBonusPercent = 25.0f * effectLevel;
        float ROFBonusPercent = 25.0f * effectLevel;
        float fluxReduction = -15.0f * effectLevel;
        if (index == 0) {
            return new ShipSystemStatsScript.StatusData("+" + (int)damageBonusPercent + "% energy weapon damage and " + (int)ROFBonusPercent + "% rate of fire", false);
        }
        if (index == 1) {
            return new ShipSystemStatsScript.StatusData("" + (int)fluxReduction + "% energy weapon flux cost", false);
        }
        if (index == 2) {
            return new ShipSystemStatsScript.StatusData("enable engine boost", false);
        }
        return null;
    }
}

