/*
 * Decompiled with CFR 0.152.
 */
package data.shipsystems.scripts;

import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ShipSystemAPI;
import com.fs.starfarer.api.impl.combat.BaseShipSystemScript;
import com.fs.starfarer.api.plugins.ShipSystemStatsScript;
import com.fs.starfarer.api.util.IntervalUtil;
import java.awt.Color;
import org.lwjgl.util.vector.Vector2f;

public class NeutrinoPhaseCloakStats
extends BaseShipSystemScript {
    private final Object STATUSKEY1 = new Object();
    private final Object STATUSKEY2 = new Object();
    private final Object JETTER1 = new Object();
    private final Object JETTER2 = new Object();
    private final float SHIP_ALPHA_MULT = 0.2f;
    private final float MAX_TIME_MULT = 3.0f;
    private final IntervalUtil interval = new IntervalUtil(0.1f, 0.1f);

    public void apply(MutableShipStatsAPI stats, String id, ShipSystemStatsScript.State state, float effectLevel) {
        float shipTimeMult;
        ShipSystemAPI cloak;
        ShipAPI ship = null;
        boolean player = false;
        if (stats.getEntity() instanceof ShipAPI) {
            ship = (ShipAPI)stats.getEntity();
            player = ship == Global.getCombatEngine().getPlayerShip();
            id = id + "_" + ship.getId();
            cloak = ship.getPhaseCloak();
            if (cloak == null) {
                cloak = ship.getSystem();
            }
            if (cloak == null) {
                return;
            }
        } else {
            return;
        }
        if (player) {
            this.maintainStatus(ship, state, effectLevel);
        }
        if (Global.getCombatEngine().isPaused()) {
            return;
        }
        if (state == ShipSystemStatsScript.State.IDLE || state == ShipSystemStatsScript.State.COOLDOWN) {
            this.unapply(stats, id);
            return;
        }
        ship.setPhased(true);
        ship.setExtraAlphaMult(1.0f - 0.8f * effectLevel);
        ship.setApplyExtraAlphaToEngines(true);
        float maxTimeMult = this.getMaxTimeMult(stats);
        if (state == ShipSystemStatsScript.State.ACTIVE || state == ShipSystemStatsScript.State.IN) {
            shipTimeMult = 1.0f + (maxTimeMult - 1.0f) * effectLevel;
            ship.getMutableStats().getFighterRefitTimeMult().modifyMult(id, 1.0f / shipTimeMult);
        } else {
            float cooldown = cloak.getCooldownRemaining();
            float cooldownLevel = cooldown / cloak.getCooldown();
            shipTimeMult = Math.min(maxTimeMult, 1.0f + (maxTimeMult - 1.0f) * cooldownLevel);
            ship.getMutableStats().getFighterRefitTimeMult().unmodify(id);
        }
        stats.getTimeMult().modifyMult(id, shipTimeMult);
        if (player) {
            Global.getCombatEngine().getTimeMult().modifyMult(id, 1.0f / shipTimeMult);
        } else {
            Global.getCombatEngine().getTimeMult().unmodify(id);
        }
        ship.setApplyExtraAlphaToEngines(true);
        stats.getFluxDissipation().modifyMult(id, 1.0f - effectLevel * 0.5f);
        this.interval.advance(Global.getCombatEngine().getElapsedInLastFrame());
        ship.setJitter((Object)(this.JETTER1 + ship.toString()), new Color(255, 175, 255, 200), 0.4f, 1, 50.0f);
        ship.setJitterUnder((Object)(this.JETTER1 + ship.toString()), new Color(255, 175, 255, 200), 0.4f, 1, 50.0f);
        if (this.interval.intervalElapsed()) {
            // empty if block
        }
        if (state != ShipSystemStatsScript.State.ACTIVE) {
            float jitterLevel = effectLevel;
            jitterLevel = (float)Math.sqrt(jitterLevel);
            ship.setJitter((Object)(this.JETTER2 + ship.toString()), new Color(255, 175, 255, 100), jitterLevel, 2, 3.0f);
            ship.setJitterUnder((Object)(this.JETTER2 + ship.toString()), new Color(255, 175, 255, 100), jitterLevel, 100, 7.0f);
            Global.getSoundPlayer().playLoop("system_temporalshell_loop", this.STATUSKEY1, 1.0f, 1.0f, ship.getLocation(), new Vector2f(0.0f, 0.0f));
        }
        int alpha = 15;
        float duration = effectLevel * 0.3f;
        Vector2f vel = ship.getVelocity();
        duration *= ship.getVelocity().length() / ship.getMaxSpeedWithoutBoost();
        float length = -1.5f;
        if (!ship.getEngineController().isFlamedOut() && !ship.getEngineController().isFlamingOut()) {
            ship.addAfterimage(new Color(255, 175, 255, alpha), 0.0f, 0.0f, vel.getX() * length, vel.getY() * length, 3.0f, 0.0f, duration, duration, false, true, false);
        }
    }

    public void unapply(MutableShipStatsAPI stats, String id) {
        stats.getFluxDissipation().unmodify(id);
        ShipAPI ship = null;
        if (!(stats.getEntity() instanceof ShipAPI)) {
            return;
        }
        ship = (ShipAPI)stats.getEntity();
        Global.getCombatEngine().getTimeMult().unmodify(id);
        stats.getTimeMult().unmodify(id);
        ship.setPhased(false);
        ship.setExtraAlphaMult(1.0f);
    }

    public ShipSystemStatsScript.StatusData getStatusData(int index, ShipSystemStatsScript.State state, float effectLevel) {
        return null;
    }

    public float getMaxTimeMult(MutableShipStatsAPI stats) {
        return 1.0f + 2.0f * stats.getDynamic().getValue("phase_time_mult");
    }

    private void maintainStatus(ShipAPI playerShip, ShipSystemStatsScript.State state, float effectLevel) {
        ShipSystemAPI cloak = playerShip.getPhaseCloak();
        if (cloak == null) {
            cloak = playerShip.getSystem();
        }
        if (cloak == null) {
            return;
        }
        if (effectLevel > 0.0f) {
            Global.getCombatEngine().maintainStatusForPlayerShip(this.STATUSKEY1, "graphics/neut/icons/hullsys/neutrino_PhaseCloak_StatusIcon.png", "Micro-Phase Actuators", "flux dissipate rate -50%", true);
            Global.getCombatEngine().maintainStatusForPlayerShip(this.STATUSKEY2, cloak.getSpecAPI().getIconSpriteName(), cloak.getDisplayName(), "time flow altered", false);
        }
    }
}

