/*
 * Decompiled with CFR 0.152.
 */
package data.shipsystems.scripts;

import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.impl.combat.BaseShipSystemScript;
import com.fs.starfarer.api.plugins.ShipSystemStatsScript;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;
import org.lwjgl.util.vector.Vector2f;

public class NeutrinoReactionControlStats
extends BaseShipSystemScript {
    Color colorFrom = new Color(120, 165, 200, 255);
    Color colorTo = new Color(235, 113, 113, 185);

    public void apply(MutableShipStatsAPI stats, String id, ShipSystemStatsScript.State state, float effectLevel) {
        if (state == ShipSystemStatsScript.State.OUT) {
            stats.getMaxSpeed().modifyPercent(id, 100.0f * effectLevel);
            stats.getAcceleration().modifyMult(id, 0.0f);
            stats.getDeceleration().modifyMult(id, 0.0f);
            stats.getMaxTurnRate().modifyPercent(id, 100.0f * effectLevel);
            stats.getDeceleration().modifyPercent(id, 100.0f * effectLevel);
        } else if (state == ShipSystemStatsScript.State.IN) {
            stats.getMaxSpeed().modifyFlat(id, stats.getMaxSpeed().base * 6.0f);
            stats.getAcceleration().modifyFlat(id, 60000.0f);
            stats.getDeceleration().modifyFlat(id, 6000.0f);
            stats.getTurnAcceleration().modifyFlat(id, 90.0f);
            stats.getMaxTurnRate().modifyFlat(id, 40.0f);
        } else {
            stats.getMaxSpeed().modifyFlat(id, stats.getMaxSpeed().base * 6.0f);
            stats.getAcceleration().modifyMult(id, 0.0f);
            stats.getDeceleration().modifyMult(id, 0.0f);
            stats.getTurnAcceleration().modifyFlat(id, 90.0f);
            stats.getTurnAcceleration().modifyPercent(id, 200.0f);
            stats.getMaxTurnRate().modifyFlat(id, 40.0f);
            stats.getMaxTurnRate().modifyPercent(id, 100.0f);
        }
        ShipAPI ship = null;
        if (stats.getEntity() instanceof ShipAPI) {
            ship = (ShipAPI)stats.getEntity();
        }
        if (ship != null) {
            Color jetColor = Misc.interpolateColor((Color)this.colorFrom, (Color)this.colorTo, (float)effectLevel);
            ship.setJitter((Object)this, jetColor, effectLevel * 2.0f, 8, 5.0f);
            ship.setJitterUnder((Object)this, jetColor, effectLevel * 2.0f, 40, 7.0f);
            int alpha = 15;
            float duration = effectLevel * 0.3f;
            Vector2f vel = ship.getVelocity();
            duration *= ship.getVelocity().length() / ship.getMaxSpeedWithoutBoost();
            float length = -1.5f;
            if (!ship.getEngineController().isFlamedOut() && !ship.getEngineController().isFlamingOut()) {
                ship.addAfterimage(new Color(jetColor.getRed(), jetColor.getGreen(), jetColor.getBlue(), alpha), 0.0f, 0.0f, vel.getX() * length, vel.getY() * length, 3.0f, 0.0f, duration, duration, true, true, false);
            }
        }
    }

    public void unapply(MutableShipStatsAPI stats, String id) {
        stats.getMaxSpeed().unmodify(id);
        stats.getMaxTurnRate().unmodify(id);
        stats.getTurnAcceleration().unmodify(id);
        stats.getAcceleration().unmodify(id);
        stats.getDeceleration().unmodify(id);
    }

    public ShipSystemStatsScript.StatusData getStatusData(int index, ShipSystemStatsScript.State state, float effectLevel) {
        if (index == 0) {
            return new ShipSystemStatsScript.StatusData("improved maneuverability", false);
        }
        if (index == 1) {
            return new ShipSystemStatsScript.StatusData("increased top speed", false);
        }
        return null;
    }
}

