/*
 * Decompiled with CFR 0.152.
 */
package data.shipsystems.scripts;

import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.impl.combat.BaseShipSystemScript;
import com.fs.starfarer.api.plugins.ShipSystemStatsScript;
import com.fs.starfarer.combat.entities.Ship;

public class NeutrinoSiegeModeStats
extends BaseShipSystemScript {
    public static final float DAMAGE_BONUS_PERCENT = 50.0f;
    public static final float ROF_PENALTY_PERCENT = -40.0f;
    public static final float WEAPON_RANGE_BONUS_MULT = 1.0f;
    public static final float TURN_PENALTY_MULT = 0.95f;
    public static final float PROJECTILE_SPEED_BONUS_PERCENT = 25.0f;
    public static final float BEAM_RANGE_PENALTY_MULT = 0.25f;
    public static final float BEAM_TURN_PENALTY = 0.5f;

    public void apply(MutableShipStatsAPI stats, String id, ShipSystemStatsScript.State state, float effectLevel) {
        float effectLevelSquare = effectLevel * effectLevel;
        if (state == ShipSystemStatsScript.State.OUT) {
            stats.getMaxSpeed().unmodify(id);
            stats.getMaxTurnRate().unmodify(id);
        } else {
            stats.getMaxSpeed().modifyMult(id, 0.01f);
            stats.getMaxTurnRate().modifyMult(id, 0.01f);
        }
        if (state == ShipSystemStatsScript.State.ACTIVE) {
            stats.getEnergyRoFMult().unmodifyMult(id);
            stats.getEnergyRoFMult().modifyPercent(id, -40.0f);
            stats.getWeaponTurnRateBonus().modifyMult(id, 0.95f);
        } else {
            ((Ship)stats.getEntity()).blockCommandForOneFrame(Ship.oo.valueOf((String)"USE_SELECTED_GROUP"));
            ((Ship)stats.getEntity()).setHoldFireOneFrame(true);
        }
        float damageBonusPercent = 50.0f * effectLevelSquare;
        stats.getEnergyWeaponDamageMult().modifyPercent(id, damageBonusPercent);
        float weaponRangePercent = 1.0f + 1.0f * effectLevel;
        stats.getEnergyWeaponRangeBonus().modifyMult(id, weaponRangePercent);
        float projectileSpeedBonus = 25.0f * effectLevelSquare;
        stats.getProjectileSpeedMult().modifyPercent(id, projectileSpeedBonus);
        float beamRangePenalty = 1.0f / (1.0f + 0.25f * effectLevelSquare);
        stats.getBeamWeaponRangeBonus().modifyMult(id, beamRangePenalty);
        float beamTurnMult = 1.0f - 0.5f * effectLevelSquare;
        stats.getBeamWeaponTurnRateBonus().modifyMult(id, beamTurnMult);
    }

    public void unapply(MutableShipStatsAPI stats, String id) {
        stats.getEnergyWeaponDamageMult().unmodify(id);
        stats.getEnergyRoFMult().unmodify(id);
        stats.getEnergyWeaponRangeBonus().unmodify(id);
        stats.getBeamWeaponRangeBonus().unmodify(id);
        stats.getWeaponTurnRateBonus().unmodify(id);
        stats.getBeamWeaponTurnRateBonus().unmodify(id);
        stats.getProjectileSpeedMult().unmodify(id);
        stats.getMaxSpeed().unmodify(id);
        stats.getMaxTurnRate().unmodify(id);
        stats.getTurnAcceleration().unmodify(id);
        stats.getAcceleration().unmodify(id);
        stats.getDeceleration().unmodify(id);
    }

    public ShipSystemStatsScript.StatusData getStatusData(int index, ShipSystemStatsScript.State state, float effectLevel) {
        if (index == 0) {
            return new ShipSystemStatsScript.StatusData("+" + (int)(50.0f * effectLevel) + "% energy weapon damage", false);
        }
        if (index == 1) {
            if (state == ShipSystemStatsScript.State.ACTIVE) {
                return new ShipSystemStatsScript.StatusData((int)(-40.0f * effectLevel) + "% energy weapon rate of fire", true);
            }
            return new ShipSystemStatsScript.StatusData("re-routing weapon energy distribution", true);
        }
        if (index == 2) {
            return new ShipSystemStatsScript.StatusData("+" + (int)(effectLevel * 200.0f) + "% energy projectile weapons range and " + (int)(25.0f * effectLevel) + "% projectile speed", false);
        }
        if (index == 3) {
            return new ShipSystemStatsScript.StatusData("+" + (int)(effectLevel * 50.0f) + "% energy beam weapons range", false);
        }
        if (index == 4) {
            return new ShipSystemStatsScript.StatusData("weapon turn speed greatly slowed", true);
        }
        return null;
    }
}

