/*
 * Decompiled with CFR 0.152.
 */
package com.apmods.myfit.item;

import com.apmods.myfit.command.CheatedStats;
import com.apmods.myfit.item.ItemBase;
import com.apmods.myfit.main.MyFit;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.List;
import java.util.Random;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatBase;
import net.minecraft.stats.StatFileWriter;
import net.minecraft.stats.StatList;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;

public class ItemMyFit
extends ItemBase {
    String texture;
    int armor;
    StatFileWriter statwriter = new StatFileWriter();
    Random rand = new Random();

    public ItemMyFit(String name) {
        super(name);
        this.func_77655_b(name);
        this.func_111206_d("myfit:" + this.func_77658_a().substring(5));
        this.func_77637_a(CreativeTabs.field_78040_i);
    }

    public void func_77622_d(ItemStack itemStack, World world, EntityPlayer player) {
        this.addStats(itemStack, (Entity)player, world);
    }

    public void func_77624_a(ItemStack itemStack, EntityPlayer player, List list, boolean par4) {
        if (itemStack.field_77990_d != null) {
            int walked = itemStack.field_77990_d.func_74762_e("walked") / 100;
            double speed = walked / MyFit.walked;
            int jumps = itemStack.field_77990_d.func_74762_e("jumps");
            double jump = jumps / MyFit.jumps;
            int mobkills = itemStack.field_77990_d.func_74762_e("mobkills");
            double strength = mobkills / MyFit.mobkills;
            int damagetaken = itemStack.field_77990_d.func_74762_e("damagetaken");
            double resistance = damagetaken / MyFit.damagetaken;
            double minutes = itemStack.field_77990_d.func_74762_e("minutes");
            double haste = (int)minutes / MyFit.minutes;
            speed = this.capTest(speed, MyFit.speedCap);
            list.add(EnumChatFormatting.LIGHT_PURPLE + "Speed/Distance Walked: " + speed + "/" + walked + "m");
            jump = this.capTest(jump, MyFit.jumpCap);
            list.add(EnumChatFormatting.DARK_GREEN + "Jump Boost/Jumps: " + jump + "/" + jumps + " Jumps");
            strength = this.capTest(strength, MyFit.strengthCap);
            list.add(EnumChatFormatting.RED + "Strength/Mob Kills: " + strength + "/" + mobkills + " Mobs Killed");
            resistance = this.capTest(resistance, MyFit.resistanceCap);
            list.add(EnumChatFormatting.DARK_AQUA + "Resistance/Damage Taken: " + resistance + "/" + damagetaken + " Damage Taken");
            haste = this.capTest(haste, MyFit.hasteCap);
            list.add(EnumChatFormatting.GOLD + "Haste/Minutes Played: " + haste + "/" + minutes + " Minutes Played");
        }
    }

    public void func_77663_a(ItemStack is, World world, Entity entity, int p_77663_4_, boolean p_77663_5_) {
        super.func_77663_a(is, world, entity, p_77663_4_, p_77663_5_);
        ItemMyFit.updateStats(is, (EntityPlayer)entity, world);
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack itemStack) {
    }

    @Override
    public Item register() {
        GameRegistry.registerItem((Item)this, (String)("myfit_" + this.func_77658_a().substring(5)));
        return this;
    }

    public static void updateStats(ItemStack itemStack, EntityPlayer player, World world) {
        if (itemStack.field_77990_d != null) {
            StatBase statwalk = StatList.field_75945_l;
            StatBase statjump = StatList.field_75953_u;
            StatBase statstrength = StatList.field_75959_z;
            StatBase stathealth = StatList.field_75961_x;
            StatBase stathaste = StatList.field_75948_k;
            if (!world.field_72995_K) {
                itemStack.field_77990_d.func_74768_a("walked", ((EntityPlayerMP)player).func_147099_x().func_77444_a(statwalk) + CheatedStats.ADDWALK);
                itemStack.field_77990_d.func_74768_a("jumps", ((EntityPlayerMP)player).func_147099_x().func_77444_a(statjump) + CheatedStats.ADDJUMP);
                itemStack.field_77990_d.func_74768_a("mobkills", ((EntityPlayerMP)player).func_147099_x().func_77444_a(statstrength) + CheatedStats.ADDMOBKILLS);
                itemStack.field_77990_d.func_74768_a("damagetaken", ((EntityPlayerMP)player).func_147099_x().func_77444_a(stathealth) / 10 + CheatedStats.ADDDAMAGE);
                itemStack.field_77990_d.func_74768_a("minutes", ((EntityPlayerMP)player).func_147099_x().func_77444_a(stathaste) / 1206 + CheatedStats.ADDTIME);
            }
        }
    }

    private void addStats(ItemStack itemStack, Entity player, World world) {
        itemStack.field_77990_d = new NBTTagCompound();
        StatBase statwalk = StatList.field_75945_l;
        StatBase statjump = StatList.field_75953_u;
        StatBase statstrength = StatList.field_75959_z;
        StatBase stathealth = StatList.field_75961_x;
        StatBase stathaste = StatList.field_75948_k;
        if (!world.field_72995_K) {
            itemStack.field_77990_d.func_74768_a("walked", ((EntityPlayerMP)player).func_147099_x().func_77444_a(statwalk));
            itemStack.field_77990_d.func_74768_a("jumps", ((EntityPlayerMP)player).func_147099_x().func_77444_a(statjump));
            itemStack.field_77990_d.func_74768_a("mobkills", ((EntityPlayerMP)player).func_147099_x().func_77444_a(statstrength));
            itemStack.field_77990_d.func_74768_a("damagetaken", ((EntityPlayerMP)player).func_147099_x().func_77444_a(stathealth) / 10);
            itemStack.field_77990_d.func_74780_a("minutes", (double)(((EntityPlayerMP)player).func_147099_x().func_77444_a(stathaste) / 1206));
            itemStack.field_77990_d.func_74757_a("speedOn", true);
            itemStack.field_77990_d.func_74757_a("jumpOn", true);
            itemStack.field_77990_d.func_74757_a("strengthOn", true);
            itemStack.field_77990_d.func_74757_a("resOn", true);
            itemStack.field_77990_d.func_74757_a("hasteOn", true);
        }
    }

    public ItemStack func_77659_a(ItemStack itemStack, World p_77659_2_, EntityPlayer p_77659_3_) {
        super.func_77659_a(itemStack, p_77659_2_, p_77659_3_);
        if (itemStack.field_77990_d != null) {
            ItemMyFit.updateStats(itemStack, p_77659_3_, p_77659_2_);
        } else {
            this.addStats(itemStack, (Entity)p_77659_3_, p_77659_2_);
        }
        return itemStack;
    }

    private boolean isValueBelowCap(int i, int cap) {
        return i <= cap;
    }

    private double capTest(double d, int cap) {
        if (d > (double)cap) {
            return cap;
        }
        return d;
    }

    public int getStat(String stat, ItemStack is) {
        if (is.field_77990_d != null) {
            return is.field_77990_d.func_74762_e(stat);
        }
        return 0;
    }
}

