GLOBAL.require 'screens.shopscreen'
GetPlayer = GLOBAL.GetPlayer
IsHUDPaused = GLOBAL.IsPaused
TheInput = GLOBAL.TheInput
TheFrontEnd = GLOBAL.TheFrontEnd
TheSim = GLOBAL.TheSim
local STRINGS = GLOBAL.STRINGS
local Recipe = GLOBAL.Recipe
local Ingredient = GLOBAL.Ingredient
local RECIPETABS = GLOBAL.RECIPETABS
local TECH = GLOBAL.TECH

PrefabFiles = {"pig_shop", "pig_shop_pigman"}

Assets=
{
Asset("ANIM", "anim/pig_shop.zip"),

Asset("ATLAS", "images/inventoryimages/pig_shop_icon.xml"),
Asset("IMAGE", "images/inventoryimages/pig_shop_icon.tex"),
Asset("IMAGE", "minimap/pig_shop_minimap_icon.tex" ),
Asset("ATLAS", "minimap/pig_shop_minimap_icon.xml" ),
Asset("IMAGE", "images/pig_shop_hud.tex" ),
Asset("ATLAS", "images/pig_shop_hud.xml" ),

}

AddMinimapAtlas("minimap/pig_shop_minimap_icon.xml")

STRINGS.NAMES.PIG_SHOP = "Pig Shop"
STRINGS.RECIPE_DESC.PIG_SHOP = "Hey Piggie!"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.PIG_SHOP = {"I can buy some useful things here"}
STRINGS.CHARACTERS.GENERIC.DESCRIBE.PIG_SHOP_ACTION = "Trade with pigs"

function SpawnShop()
		local minPos, maxPos
		minPos = 6
		maxPos = 12
		
		local pigking = GLOBAL.c_find("pigking")
		
		--_G = GLOBAL
		--if _G.IsDLCEnabled(_G.REIGN_OF_GIANTS) then
		--end
		
		if not pigking then
			pigking = GLOBAL.c_find("pighouse") or GLOBAL.c_find("wildborehouse")
			minPos = 2
			maxPos = 4
		end

		if not pigking then return false end
		
		local x,y,z = pigking.Transform:GetWorldPosition()
		local is = false
		ents = GLOBAL.TheSim:FindEntities(x,y,z,9001)
		for k, v in pairs(ents) do
			if v.prefab == "pig_shop" then
				is = true
			end
		end
		
	
		if pigking and not is then
			local pig_shop = GLOBAL.SpawnPrefab("common/pig_shop")
			
			x = x + math.random(minPos, maxPos)
			z = z + math.random(minPos, maxPos)
			
			pig_shop.Transform:SetPosition(x,y,z)
		end
end

local function spawn_task(inst)
	inst:DoTaskInTime(5, SpawnShop)
end

function SpawnPlayerShop(player)
	local x, y, z = player.Transform:GetWorldPosition()
	local creature = GLOBAL.SpawnPrefab("pig_shop")
	creature.Transform:SetPosition( x, y, z )
end


AddSimPostInit(SpawnShop)
AddPrefabPostInit("pigking", spawn_task)
