local Animable = Class(function(self, inst)
    self.inst = inst    
    self.fxdata = {}
    self.fxlevel = 1
    self.fxchildren = {}
end)

function Animable:AddFX(prefab, offset, followsymbol)
    table.insert(self.fxdata, {prefab=prefab, x = offset.x, y = offset.y, z = offset.z, follow=followsymbol})
end

function Animable:OnRemoveEntity()
	self:KillFX()
end

function Animable:SpawnFX()
    self:KillFX()
    
    if not self.fxdata then
        self.fxdata = { x = 0, y = 0, z = 0, level=self:GetDefaultFXLevel() }
    end
    
    if self.fxdata then
	    for k,v in pairs(self.fxdata) do
			local fx = SpawnPrefab(v.prefab)
			if fx then
				if v.follow then
					local follower = fx.entity:AddFollower()
					follower:FollowSymbol( self.inst.GUID, v.follow, v.x,v.y,v.z)
				else
				    self.inst:AddChild(fx)
				    fx.Transform:SetPosition(v.x, v.y, v.z)
				end
				table.insert(self.fxchildren, fx)
			end
		end
    end
end

function Animable:KillFX()
	for k,v in pairs(self.fxchildren) do
        v:Remove()
		self.fxchildren[k] = nil
	end
end

function Animable:SetAnim(anim, pre_anim)
    if self.fxchildren then
	    for k,v in pairs(self.fxchildren) do
			if pre_anim then
				v.AnimState:PlayAnimation(pre_anim)
				v.AnimState:PushAnimation(anim)
			else
				v.AnimState:PlayAnimation(anim, true)
			end
		end
    end
end

function Animable:OnRemoveFromEntity()
    self:Extinguish()
end

return Animable