require "prefabutil"
require "goodslist"

local assets =
{
	Asset("ANIM", "anim/pig_shop.zip"),
	Asset("SOUND", "sound/pig.fsb"),
}

local prefabs = {"pig_shop"}

local funny_idle_anims = {"idle_creepy", "idle_happy", "idle_scared", "eat", "hungry"}
local idle_anims = {"idle_creepy", "idle_happy"}

local function GetVerb(inst)
	return "Trade with pigs"
end

local function OnActivate(inst)	
	if GetClock():IsNight() then 
		GetPlayer().components.talker:Say("It's too late now!", 5, false)
	else
		GetPlayer().SoundEmitter:PlaySound("dontstarve/HUD/research_available")
		GetPlayer().components.talker:Say("Hey-hey, show me your junk", 5, false)
		TheFrontEnd:PushScreen(SHOPScreen(inst))
		inst.SoundEmitter:PlaySound("dontstarve/pig/oink")
	end
end 

local function getstatus(inst)
end

local function LightsOn(inst)
    inst.Light:Enable(true)
    inst.AnimState:PlayAnimation("night", true)
    inst.SoundEmitter:PlaySound("dontstarve/pig/pighut_lighton")
    inst.lightson = true
end

local function LightsOff(inst)
    inst.Light:Enable(false)
    inst.AnimState:PlayAnimation("day", true)
    inst.SoundEmitter:PlaySound("dontstarve/pig/pighut_lightoff")
    inst.lightson = false
end

local function onfar(inst)
	if GetClock():IsDay() or GetClock():IsDusk() then 
		inst.SoundEmitter:PlaySound("dontstarve/pig/oink")
	end
	local activeScreen = TheFrontEnd:GetActiveScreen()
	
	if (activeScreen ~= nil) and (tostring(activeScreen) == "SHOPScreen") then
		TheFrontEnd:PopScreen()
	end
		
	inst.components.activatable.inactive = true
end

local function OnDay(inst)
	inst.components.animated_parts:SetAnim(idle_anims[math.random(#idle_anims )], "sleep_pst")
    LightsOff(inst)
end

local function OnDusk(inst)
	inst.components.animated_parts:SetAnim(idle_anims[math.random(#idle_anims )])
    LightsOn(inst)
end

local function OnNight(inst)
	inst.components.animated_parts:SetAnim("sleep_loop", "sleep_pre")
    LightsOn(inst)
	onfar(inst)
end

local function randomItemsSorting()
	for k,v in pairs(all_available_items) do
		for i = 0, #all_available_items do
			local savedValue = all_available_items[i]
			local randomIndex = math.random( #all_available_items )
			all_available_items[i] = all_available_items[randomIndex]
			all_available_items[randomIndex] = savedValue
		end
	end
end

local function makeNewItems(inst) 
randomItemsSorting()
inst.goods_for_sale = {}
local i = 0
for k,v in pairs(all_available_items) do
	if (i < 16 and k < #all_available_items-1) then
		local item = SpawnPrefab(v.name)
		if (item ~= nil) then
			if item.components and item.components.inventoryitem then
				inst.goods_for_sale[i] = {}
				inst.goods_for_sale[i].name = v.name
				inst.goods_for_sale[i].item = item
				inst.goods_for_sale[i].stack_amount = v.stack_amount
				inst.goods_for_sale[i].stack_cost = v.stack_cost
				if IsDLCEnabled(CAPY_DLC) then
					inst.goods_for_sale[i].stack_cost = v.stack_cost + 1
				end
				inst.goods_for_sale[i].default_stock = v.default_stock + math.random(0, math.floor(v.default_stock))
				
				i = i+1
			else
				item:Remove()
			end
		end
	end
end

end

local function fn(Sim)
local inst = CreateEntity()
local trans = inst.entity:AddTransform()
local anim = inst.entity:AddAnimState()
inst.entity:AddSoundEmitter()

local light = inst.entity:AddLight()
light:SetFalloff(1)
light:SetIntensity(.5)
light:SetRadius(1)
light:Enable(false)
light:SetColour(180/255, 195/255, 50/255)
	
MakeObstaclePhysics(inst, 0.9)

anim:SetBank("pig_shop")
anim:SetBuild("pig_shop")
anim:PlayAnimation("day", true)

local minimap = inst.entity:AddMiniMapEntity()
minimap:SetIcon("pig_shop_minimap_icon.tex")

inst:AddTag("structure")

inst:AddComponent("inspectable")

inst:AddComponent("playerprox")
inst.components.playerprox:SetDist(3,5)
inst.components.playerprox:SetOnPlayerFar(onfar)
	
inst:AddComponent("activatable")
inst.components.activatable.OnActivate = OnActivate
inst.components.activatable.inactive = true
inst.components.activatable.getverb = GetVerb
inst.components.activatable.quickaction = true
	
inst:AddComponent("animated_parts")
inst.components.animated_parts:AddFX("pig_shop_pigman", Vector3(30, -100, -.1), "new_house")
inst.components.animated_parts:SpawnFX()
inst.components.animated_parts:SetAnim(idle_anims[math.random(#idle_anims )])

inst:ListenForEvent("seasonChange", function() makeNewItems(inst) end, GetWorld() )


inst:DoTaskInTime(math.random(), function() 
	if GetClock():IsDay() then 
		OnDay(inst)
	end
	if GetClock():IsDusk() then 
		OnDusk(inst)
	end
	if GetClock():IsNight() then 
		OnNight(inst)
	end
end)

inst:DoPeriodicTask(15 + 25*math.random(), function() 
	if GetClock():IsDay() or GetClock():IsDusk() then 
		inst.components.animated_parts:SetAnim(idle_anims[math.random(#idle_anims )], funny_idle_anims[math.random( #funny_idle_anims ) ])
		inst.SoundEmitter:PlaySound("dontstarve/pig/oink")
	end
end)
		
inst:ListenForEvent( "nighttime", function()
	OnNight(inst)
end, GetWorld())

inst:ListenForEvent( "dusktime", function()
	OnDusk(inst)
end, GetWorld())

inst:ListenForEvent( "daytime", function()
	OnDay(inst)
end, GetWorld())

makeNewItems(inst)

local function onsave(inst, data)
inst.components.animated_parts:KillFX() 
	if inst.goods_for_sale then
		data.goods_for_sale = {}
		for k,v in pairs(inst.goods_for_sale) do
			data.goods_for_sale[k] = {}
			data.goods_for_sale[k].name = v.name
			data.goods_for_sale[k].item = nil
			data.goods_for_sale[k].stack_amount = v.stack_amount
			data.goods_for_sale[k].stack_cost = v.stack_cost
			data.goods_for_sale[k].default_stock = v.default_stock
		end
	end
end

local function onload(inst, data)
inst.goods_for_sale = inst.goods_for_sale or {}
	if data and data.goods_for_sale then
		for k,v in pairs(data.goods_for_sale) do
			local item = SpawnPrefab(v.name)
			if (item ~= nil) then
				if item.components and item.components.inventoryitem then
					inst.goods_for_sale[k].name = {}
					inst.goods_for_sale[k].name = v.name
					inst.goods_for_sale[k].item = item
					inst.goods_for_sale[k].stack_amount = v.stack_amount
					inst.goods_for_sale[k].stack_cost = v.stack_cost
					inst.goods_for_sale[k].default_stock = v.default_stock
				else
					item:Remove()
				end
			end
		end
	end
end

inst.OnSave = onsave
inst.OnLoad = onload

return inst
end

return Prefab( "common/pig_shop", fn, assets, prefabs),
MakePlacer("common/pig_shop_placer", "pig_shop", "pig_shop", "idle") 