require "util"
local Screen = require "widgets/screen"
local AnimButton = require "widgets/animbutton"
local Button = require "widgets/button"
local ImageButton = require "widgets/imagebutton"
local TextButton = require "widgets/textbutton"
local Menu = require "widgets/menu"
local Grid = require "widgets/grid"
local Text = require "widgets/text"
local Image = require "widgets/image"
local UIAnim = require "widgets/uianim"
local Spinner = require "widgets/spinner"
local NumericSpinner = require "widgets/numericspinner"
local Widget = require "widgets/widget"
local Inv = require "widgets/shop_inventorybar"
local HoverText = require "widgets/shop_hoverer"

local text_font = UIFONT

SHOPScreen = Class(Screen, function(self, inst_entity)
    GetPlayer().components.playercontroller:Enable(true)
	Widget._ctor(self, "SHOPScreen")
	self.inst_entity = inst_entity
    
	self.root = self:AddChild(Widget("ROOT"))
    self.root:SetVAnchor(ANCHOR_MIDDLE)
    self.root:SetHAnchor(ANCHOR_MIDDLE)
    self.root:SetPosition(0,0,0)
    self.root:SetScaleMode(SCALEMODE_PROPORTIONAL)
    
    self.itemspanel = self.root:AddChild( Image( "images/pig_shop_hud.xml", "pig_shop_hud.tex" ) )
	self.itemspanel:SetScale(1,1,1)
	self.itemspanel:SetPosition(0,0,0)
       
    self.inv = self.itemspanel:AddChild(Inv(GetPlayer(), inst_entity))
	self.inv:SetPosition(-135, 190, 0)
	
	self.closebutton = self.itemspanel:AddChild(ImageButton())
	self.closebutton:SetText(STRINGS.UI.OPTIONS.CLOSE)
    self.closebutton:SetPosition(130, -80, 0)
    self.closebutton:SetScale(0.69)
    self.closebutton:SetOnClick( function() self:Accept() end)
	
	self.hover = self:AddChild(HoverText(self))
	self.hover:SetScaleMode(SCALEMODE_PROPORTIONAL)
	self.hover.isFE = true

end)

function SHOPScreen:OnControl(control, down)
    if SHOPScreen._base.OnControl(self, control, down) then return true end
    
    if (control == CONTROL_PAUSE or control == CONTROL_CANCEL) and not down then
		self:Accept()
		return true
    end
end


function SHOPScreen:Accept()
	if (self.inst_entity) then
		self.inst_entity.components.activatable.inactive = true
	end
	GetPlayer().components.playercontroller:Enable(true)
	self.inv:Delete()
	TheFrontEnd:PopScreen()
end

function SHOPScreen:OnUpdate(dt)
	self.hover:Update()
	self.inv:Update(dt)
end


function SHOPScreen:UpdateMenu()
	self.menu:Clear()
	self.menu:AddItem(STRINGS.UI.OPTIONS.CLOSE, function() self:Accept() end)
end

