local Text = require "widgets/text"
local Widget = require "widgets/widget"

local YOFFSETUP = 15
local YOFFSETDOWN = 30
local XOFFSET = 15

local HoverText = Class(Widget, function(self, owner)
    Widget._ctor(self, "HoverText")
	self.owner = owner
	self.inst_entity = owner.inst_entity
    self.isFE = false
    self:SetClickable(false)
    --self:MakeNonClickable()
    self.text = self:AddChild(Text(UIFONT, 24))
	self.text:SetHAlign(ANCHOR_LEFT)
    self.text:SetPosition(0,YOFFSETUP,0)

    self:FollowMouseConstrained()
end)

function HoverText:Update()
	if "PS4" == PLATFORM then
	    return
	end
	    
	if TheFrontEnd.tracking_mouse ~= self.shown then
		if TheFrontEnd.tracking_mouse then
			self:Show()
		else
			self:Hide()
		end
	end
	
	if not self.shown then 
		return 
	end
	
    local str = nil
    if self.isFE == false then 
        str = self.owner.HUD.controls:GetTooltip() or self.owner.components.playercontroller:GetHoverTextOverride()
    else
        str = self.owner:GetTooltip()
    end
 
    if str then
        self.text:SetString(str)
        self.text:Show()
    else
        self.text:Hide()
    end

    local changed = (self.str ~= str)
    self.str = str
    if changed then
        local pos = TheInput:GetScreenPosition()
        self:UpdatePosition(pos.x, pos.y)
    end
end

function HoverText:UpdatePosition(x,y)


	local scale = self:GetScale()
	
    local scr_w, scr_h = TheSim:GetScreenSize()

    local w = 0
    local h = 0

    if self.text and self.str then
        local w0, h0 = self.text:GetRegionSize()
        w = math.max(w, w0)
        h = math.max(h, h0)
    end

	w = w*scale.x
	h = h*scale.y
	
    x = math.max(x, w/2 + XOFFSET)
    x = math.min(x, scr_w - w/2 - XOFFSET)

    y = math.max(y, h/2 + YOFFSETDOWN*scale.y)
    y = math.min(y, scr_h - h/2 - YOFFSETUP*scale.x)

    self:SetPosition(x,y,0)
end

function HoverText:FollowMouseConstrained()
    if not self.followhandler then
        self.followhandler = TheInput:AddMoveHandler(function(x,y) self:UpdatePosition(x,y) end)
        local pos = TheInput:GetScreenPosition()
        self:UpdatePosition(pos.x, pos.y)
    end
end

return HoverText
