require "class"
local InvSlot = require "widgets/shop_invslot"
local Image = require "widgets/image"
local Widget = require "widgets/widget"
local ItemTile = require "widgets/shop_itemtile"
local Text = require "widgets/text"
local ImageButton = require "widgets/imagebutton"

local HUD_ATLAS = "images/hud.xml"
local NUM_COLUMS = 6
local MAX_ROWS = 3
local MAXSLOTS = NUM_COLUMS * MAX_ROWS

local Inv = Class(Widget, function(self, owner, inst_entity)
	Widget._ctor(self, "Inventory")
	
	self.slots = self:AddChild(Widget("SLOTS"))
    self.owner = owner
	self.inst_entity = inst_entity
	self.base_scale = .65
	self.selected_scale = .8
    self:SetScale(self.base_scale)
	self.inv = {} 
   
    self.menu = self:AddChild(Widget("MENU"))
	self.menu:SetPosition(225, -0, 0)

    self.pagetext = self.menu:AddChild(Text(TITLEFONT, 36))
    self.pagetext:SetString("oink! oink! oink! oink!")
	self.pagetext:SetScale(1,1,1)
    self.pagetext:SetColour(1,1,1,1)
	self.pagetext:SetPosition(-100, -170, 0)
	self.pagetext:SetHAlign(ANCHOR_LEFT)
	
	self.rebuild_pending = true
	
end)

function Inv:Rebuild()
	self.slots:KillAllChildren()

    for k,v in pairs(self.inv) do
    	v:Kill()
    end

    self.inv = {}    
    
    local W = 88
    local H = 84
	local xOffset = 10
	local yOffset = 244
    local maxwidth = (W * NUM_COLUMS)
	
	local positions = 0
	if self.inst_entity then
		for k = 0, #self.inst_entity.goods_for_sale do
			if self.inst_entity.goods_for_sale[k] and self.inst_entity.goods_for_sale[k].item and (self.inst_entity.goods_for_sale[k].default_stock > 0) then
				local height = math.floor(positions / NUM_COLUMS) * H
				local slot = InvSlot(k, HUD_ATLAS, "inv_slot.tex", self.owner, self.inst_entity.goods_for_sale)
				self.inv[k] = self.slots:AddChild(slot)
				self.inv[k]:SetTile(ItemTile(self.inst_entity.goods_for_sale[k]))
				
				local remainder = positions % NUM_COLUMS
				local row = math.floor(positions / NUM_COLUMS) * H + yOffset

				local x = W * remainder + xOffset
				slot:SetPosition(x,-row,0)
				positions = positions + 1
			end
		end
	end

	self.rebuild_pending = false
end


function Inv:Update(dt)

	if self.rebuild_pending == true then
		self:Rebuild()
	end
end

function Inv:OnControl(control, down)
	if Inv._base.OnControl(self, control, down) then return true end
	
	if self.open then
		if not down then 
			if control == CONTROL_ACCEPT then
				self.inv[self.active_slot]:Click()
			end
		end
	end
end

function Inv:Refresh()
	
	for k,v in pairs(self.inv) do
		v:SetTile(nil)
	end
	
	if self.inst_entity then 
		for k,v in pairs(self.inst_entity.goods_for_sale) do
			if v.item then
				local tile = ItemTile(v.item, self)
				if (self.inv[k]) then
					self.inv[k]:SetTile(tile)
				end
			end
		end
	end
end

function Inv:Delete()
	if self.inst_entity then 
		for k,v in pairs(self.inst_entity.goods_for_sale) do
			v.item:Remove()
		end
	end
	
	for k,v in pairs(self.inv) do
    	v:Kill()
    end
end

function contains(tab,val)
	for k,v in pairs(tab) do 
		if v == val then 
			return true 
		end
	end

	return false
end

return Inv