local ItemSlot = require "widgets/itemslot"

local InvSlot = Class(ItemSlot, function(self, num, atlas, bgim, owner, container)
    ItemSlot._ctor(self, atlas, bgim, owner)
    self.owner = owner
    self.container = container
    self.num = num
end)

function InvSlot:GetSlotNum()
    if self.tile and self.tile.item then
        return self.tile.item.components.inventoryitem:GetSlotNum()
    end
end

function InvSlot:OnControl(control, down)
    if InvSlot._base.OnControl(self, control, down) then return true end
    if down then
        
        if control == CONTROL_ACCEPT then
            self:Click(false)
        elseif control == CONTROL_SECONDARY then
            self:Click(true)
        else
            return false
        end
        return true
    end


end

function InvSlot:Click(stack_mod)
    local character = GetPlayer()
    local slot_number = self.num
    local container = self.container
    local container_item = container[slot_number]
	local hasemptyslot = true
	local price = container_item.stack_cost
	local amount = container_item.stack_amount
	
	if container_item.default_stock > 0 then
		local money = "goldnugget"
		if IsDLCEnabled(CAPY_DLC) then
			money = "dubloon"
		end
		
		if GetPlayer().components.inventory:Has(money, price)  then
			if container_item then
				GetPlayer().components.inventory:ConsumeByName(money, price)
				container_item.default_stock = container_item.default_stock - 1
				
				for i = 1, amount do
					local loot = SpawnPrefab(container_item.item.prefab)
					if loot then
						if GetPlayer().components.inventory:IsFull() then
							local equipslot = GetPlayer().components.inventory.equipslots
							local backpack_found = 0
							for k,v in pairs(equipslot) do
								if v and v.prefab == "backpack" or v.prefab == "piggyback"	or v.prefab == "krampus_sack" then
									if not v.components.container:IsFull() then
										backpack_found = backpack_found + 1
									end
								end
							end
							if backpack_found == 0 then
								hasemptyslot = false
							end
						end
						if hasemptyslot then
							character.SoundEmitter:PlaySound("dontstarve/HUD/research_available")
							GetPlayer().components.inventory:GiveItem(loot)
						else
							character.SoundEmitter:PlaySound("dontstarve/HUD/click_object")
							GetPlayer().components.talker:Say("I can't take more goods.", 5, false)
							
							local x, y, z = GetPlayer().Transform:GetWorldPosition()
							loot.Transform:SetPosition( x, y, z )	
						end
					end
				end
			  
			end
		else
			character.SoundEmitter:PlaySound("dontstarve/HUD/click_object")
			if IsDLCEnabled(CAPY_DLC) then
				GetPlayer().components.talker:Say("I need more dubloons!", 5, false)
			else
				GetPlayer().components.talker:Say("I need more gold!", 5, false)
			end
		end
	else
		character.SoundEmitter:PlaySound("dontstarve/HUD/click_object")
		GetPlayer().components.talker:Say("He has nothing else", 5, false)
	end
	self:GetParent():GetParent():GetParent():GetParent():GetParent().inv:Rebuild()
end

return InvSlot
