local Text = require "widgets/text"
local Image = require "widgets/image"
local Widget = require "widgets/widget"
local UIAnim = require "widgets/uianim"

local ItemTile = Class(Widget, function(self, goods_data)
    Widget._ctor(self, "ItemTile")
	self.goods_data = goods_data
	
	if self.goods_data.item.components.inventoryitem == nil then
		return
	end
	
    self.image = self:AddChild(Image(self.goods_data.item.components.inventoryitem:GetAtlas(), self.goods_data.item.components.inventoryitem:GetImage()))
    self:SetQuantity(self.goods_data.stack_amount, self.goods_data.default_stock*self.goods_data.stack_amount)

end)

function ItemTile:OnControl(control, down)
    self:UpdateTooltip()
    return false
end

function ItemTile:UpdateTooltip()
	local str = self:GetDescriptionString()
	self:GetParent():GetParent():GetParent().pagetext:SetString(self:GetDataString())
	self:SetTooltip(str)
end

function ItemTile:GetDescriptionString()
    local str = nil
    if self.goods_data.item and self.goods_data.item.components.inventoryitem then

        local adjective = self.goods_data.item:GetAdjective()
        
        if adjective then
            str = adjective .. " " .. self.goods_data.item:GetDisplayName()
        else
            str = self.goods_data.item:GetDisplayName()
        end

    end
   
    return str or ""
end

function ItemTile:GetDataString()
    local item_name = nil
    if self.goods_data.item and self.goods_data.item.components.inventoryitem then

        local adjective = self.goods_data.item:GetAdjective()
        
        if adjective then
            item_name = adjective .. " " .. self.goods_data.item:GetDisplayName()
        else
            item_name = self.goods_data.item:GetDisplayName()
        end

    end
	
	local money = "Gold"
	if IsDLCEnabled(CAPY_DLC) then
		money = "Dubloons"
	end
	
    local str = self.goods_data.stack_cost.." "..money.." for "..self.goods_data.stack_amount.." "..item_name.."\nItems left: x"..self.goods_data.default_stock*self.goods_data.stack_amount
    return str or ""
end

function ItemTile:OnGainFocus()
    self:UpdateTooltip()
end

function ItemTile:SetQuantity(quantity, items_left)
    if not self.quantity then
        self.quantity = self:AddChild(Text(NUMBERFONT, 30))
        self.quantity:SetPosition(-1,0,0)
		self.quantity:SetHAlign(ANCHOR_LEFT)

    end
    self.quantity:SetString("x"..tostring(quantity).."\n["..items_left.."]")
end

function ItemTile:SetPerishPercent(percent)
	if self.goods_data.item.components.perishable and self.item.components.edible then
		self.spoilage:GetAnimState():SetPercent("anim", 1-self.goods_data.item.components.perishable:GetPercent())
	end
end

function ItemTile:SetPercent(percent)
    percent = 0
	if not self.percent then
		self.percent = self:AddChild(Text(NUMBERFONT, 42))
		self.percent:SetPosition(5,-32+15,0)
	end
    local val_to_show = percent*100
    if val_to_show > 0 and val_to_show < 1 then
        val_to_show = 1
    end
	self.percent:SetString(string.format("%2.0f%%", val_to_show))
        
end

function ItemTile:StartDrag()
    self.spoilage:Hide()
    self.bg:Hide( )
    self.image:SetClickable(false)
end



return ItemTile
