local FenshenSaver = Class(function(self, inst)
    self.inst = inst
end,
nil,
{
})

function FenshenSaver:SaveFenshen()
	local followers = self.inst.components.leader.followers
	local fenshen = nil
    for k, v in pairs(followers) do
        if k:HasTag("shadowzhuikong") or k:HasTag("shadowyinkong") then
            fenshen = k
        end
    end	

	if fenshen then
		self.saved_fenshen = fenshen
		self.fenshen_save = fenshen:GetSaveRecord()
		self.saved_fenshen.persists = false
		local fx = SpawnPrefab("spawn_fx_medium")
		if fx ~= nil then
			fx.Transform:SetPosition(fenshen.Transform:GetWorldPosition())
		end
		fenshen.components.colourtweener:StartTween({ 0, 0, 0, 1 }, 13 * FRAMES, fenshen.Remove)
	end
end

function FenshenSaver:OnSave()
	return {fenshen = self.fenshen_save}
end

local function DeleteOnDrop(inst)
	inst:Remove()
end

function FenshenSaver:OnLoad(data)
	if data.fenshen then
		local fenshen = SpawnSaveRecord(data.fenshen)
		fenshen.components.follower:SetLeader(self.inst)
		self.inst.components.sanity.penalty = 0.26
		self.inst:AddTag("HasShadow")
		self.inst:AddTag("notarget")
		self.inst:DoTaskInTime(0, function()
			local fx = SpawnPrefab("spawn_fx_medium")
			if fx ~= nil then
				fx.Transform:SetPosition(fenshen.Transform:GetWorldPosition())
			end
		end)
	end
end

return FenshenSaver