local assets =
{
    Asset("ANIM", "anim/firetooth.zip"),
    Asset("ANIM", "anim/swap_firetooth.zip"),
    Asset("IMAGE", "images/inventoryimages/firetooth.tex"),
    Asset("ATLAS", "images/inventoryimages/firetooth.xml"),
}

local prefabs = {
    "xzfire",
}

local function onattack(inst, attacker, target)
    if inst.components.fueled:IsEmpty() then
        return false
    else
        inst.components.fueled:DoDelta(-TUNING.LARGE_FUEL/25)
    end

    if target ~= nil and
        target:IsValid() and
        not target:IsInLimbo() and
        target.components.hauntable ~= nil and
        not (target.components.inventoryitem ~= nil and target.components.inventoryitem:IsHeld()) and
        not (target:HasTag("haunted") or target:HasTag("catchable")) then
        attacker:PushEvent("haunt", { target = target })
        target.components.hauntable:DoHaunt(attacker)
        return true
    end
end

local function turnon(inst)
    local owner = inst.components.inventoryitem ~= nil and inst.components.inventoryitem.owner or nil
    if inst.components.fueled:IsEmpty() then
        return
    end
    
    if owner ~= nil and inst.components.equippable ~= nil and inst.components.equippable:IsEquipped() then
        if inst.fx == nil then
        inst.fx = SpawnPrefab("xzfire")
            inst.fx.Transform:SetScale(3,3,3)
            inst.fx.AnimState:SetMultColour(1,1,1,0.4)
            inst.fx.entity:SetParent(owner.entity)
            inst.fx.entity:AddFollower()
            inst.fx.Follower:FollowSymbol(owner.GUID, "swap_object", 10, -50, 0)
        end
        --[[if owner._xzfx == nil then
            owner._xzfx = SpawnPrefab("heatrocklight")
            owner._xzfx.entity:SetParent(owner.entity)
            owner._xzfx.Light:SetIntensity(.5)
            owner._xzfx.Light:Enable(true)
        end]]
    end

    if inst.fire == nil then
        inst.fire = SpawnPrefab("xzfire")
        inst.fire.entity:SetParent(inst.entity)
        inst.fire.AnimState:SetMultColour(1,1,1,0.4)
        inst.fire.Transform:SetScale(3,3,3)
        inst.fire.Transform:SetPosition(0,0,0)
    end
end

    local function onequip(inst, owner)
        owner.AnimState:OverrideSymbol("swap_object", "swap_firetooth", "firetooth")
        owner.AnimState:Show("ARM_carry")
        owner.AnimState:Hide("ARM_normal")
        turnon(inst)
    end

    local function onunequip(inst, owner)
        owner.AnimState:Hide("ARM_carry")
        owner.AnimState:Show("ARM_normal")
        if inst.fx ~= nil then
            inst.fx:Remove()
            inst.fx = nil
        end
    end

local function nofuel(inst)
    inst.components.weapon:SetDamage(20)
    if inst.fire ~= nil then
        inst.fire:Remove()
        inst.fire = nil
    end
    if inst.fx ~= nil then
        inst.fx:Remove()
        inst.fx = nil
    end
    --[[
    local owner = inst.components.inventoryitem ~= nil and inst.components.inventoryitem.owner or nil
    if owner ~= nil and owner._xzfx ~= nil then
        owner._xzfx:Remove()
        owner._xzfx = nil
    end]]
end

local function ontakefuel(inst)
    inst.components.weapon:SetDamage(40)
    turnon(inst)
end

    local function simple(name)
        local inst = CreateEntity()

        inst.entity:AddTransform()
        inst.entity:AddAnimState()
        inst.entity:AddNetwork()
        --inst.entity:AddLight()

        MakeInventoryPhysics(inst)

        inst.AnimState:SetBank(name)
        inst.AnimState:SetBuild(name)
        inst.AnimState:PlayAnimation("idle")
        --[[inst.AnimState:SetBloomEffectHandle("shaders/anim.ksh")

        inst.Light:SetFalloff(0.7)
        inst.Light:SetIntensity(.5)
        inst.Light:SetRadius(0.5)
        inst.Light:SetColour(237/255, 237/255, 209/255)
        inst.Light:Enable(true)]]

        inst.entity:SetPristine()

        if not TheWorld.ismastersim then
            return inst
        end

        inst:AddComponent("weapon")

        inst:AddComponent("inspectable")

        inst:AddComponent("fueled")
        inst.components.fueled.fueltype = FUELTYPE.NIGHTMARE
        inst.components.fueled:InitializeFuelLevel(4 * TUNING.LARGE_FUEL)
        inst.components.fueled:SetDepletedFn(nofuel)
        inst.components.fueled:SetTakeFuelFn(ontakefuel)
        inst.components.fueled.accepting = true

        inst:AddComponent("inventoryitem")
        inst.components.inventoryitem.atlasname = "images/inventoryimages/"..name..".xml"
        inst.components.inventoryitem.imagename = name

        inst:AddComponent("equippable")
        inst.components.equippable:SetOnEquip(onequip)
        inst.components.equippable:SetOnUnequip(onunequip)

        MakeHauntableLaunch(inst)

        return inst
    end
local function fn()
        local inst = simple("firetooth")

        if not TheWorld.ismastersim then
            return inst
        end
    inst.components.weapon:SetDamage(TUNING.FIRETOOTH_DAMAGE)
    inst.components.weapon:SetOnAttack(onattack)

    inst.fire = SpawnPrefab("xzfire")
    inst.fire.entity:SetParent(inst.entity)
    inst.fire.AnimState:SetMultColour(1,1,1,0.4)
    inst.fire.Transform:SetScale(3,3,3)
    inst.fire.Transform:SetPosition(0,0,0)

    return inst
end
STRINGS.NAMES.FIRETOOTH= "冥火之牙"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.FIRETOOTH= "灼伤你的灵魂"
return Prefab( "firetooth", fn, assets)