local assets =
{
    Asset("ANIM", "anim/healingseed.zip"),
    Asset("IMAGE", "images/inventoryimages/healingseed.tex"),
    Asset("ATLAS", "images/inventoryimages/healingseed.xml"),
}

local function OnEaten(inst, eater)
    eater.sg:GoToState("refuseeat")
end

local function fn()
    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddNetwork()

    MakeInventoryPhysics(inst)

    inst.AnimState:SetBank("healingseed")
    inst.AnimState:SetBuild("healingseed")
    inst.AnimState:PlayAnimation("idle")

    inst.entity:SetPristine()

    if not TheWorld.ismastersim then
        return inst
    end

    inst:AddComponent("stackable")
    inst.components.stackable.maxsize = TUNING.STACK_SIZE_SMALLITEM

    inst:AddComponent("inspectable")

    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.atlasname = "images/inventoryimages/healingseed.xml"
    inst.components.inventoryitem.imagename = "healingseed"

    inst:AddComponent("edible")
    inst.components.edible:SetOnEatenFn(OnEaten)
    inst.components.edible.foodtype = FOODTYPE.VEGGIE
    inst.components.edible.healthvalue = 30
    inst.components.edible.hungervalue = 0
    inst.components.edible.sanityvalue = 0

    MakeHauntableLaunch(inst)

    return inst
end

STRINGS.NAMES.HEALINGSEED= "草药"
STRINGS.RECIPE_DESC.HEALINGSEED = "这些东西真能拿来治病吗"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.HEALINGSEED= "像火锅底料加两根大葱……呸，苦的！"

return Prefab("healingseed", fn, assets)