local assets =
{
    Asset("ANIM", "anim/memorymetal.zip"),
    Asset("ANIM", "anim/swap_memorymetal.zip"),
    Asset("IMAGE", "images/inventoryimages/memorymetal.tex"),
    Asset("ATLAS", "images/inventoryimages/memorymetal.xml"),
}

local function onequip(inst, owner)
    owner.AnimState:OverrideSymbol("swap_object", "swap_memorymetal", "swap_memorymetal")
    owner.AnimState:OverrideSymbol("whipline", "swap_memorymetal", "memorymetalline")
    owner.AnimState:Show("ARM_carry")
    owner.AnimState:Hide("ARM_normal")
    if not owner:HasTag("yinkong") then return end
    local level = owner.components.exp.levelpoint
    inst.components.weapon:SetRange(4+level/2)
end

local function onunequip(inst, owner)
    owner.AnimState:Hide("ARM_carry")
    owner.AnimState:Show("ARM_normal")
end

local function storeincontainer(inst, container)
    if container ~= nil and container.components.container ~= nil then
        inst:ListenForEvent("onputininventory", inst._oncontainerownerchanged, container)
        inst:ListenForEvent("ondropped", inst._oncontainerownerchanged, container)
        inst._container = container
    end
end

local function unstore(inst)
    if inst._container ~= nil then
        inst:RemoveEventCallback("onputininventory", inst._oncontainerownerchanged, inst._container)
        inst:RemoveEventCallback("ondropped", inst._oncontainerownerchanged, inst._container)
        inst._container = nil
    end
end

local function topocket(inst, owner)
    if inst._container ~= owner then
        unstore(inst)
        storeincontainer(inst, owner)
    end
end

local function toground(inst)
    unstore(inst)
end

local function onattack(inst, attacker, target)
    if not inst.components.fueled:IsEmpty() then
        inst.components.fueled:DoDelta(-1)
    end
    if target ~= nil and target:IsValid() then
        local snap = SpawnPrefab("impact")

        local x, y, z = inst.Transform:GetWorldPosition()
        local x1, y1, z1 = target.Transform:GetWorldPosition()
        local angle = -math.atan2(z1 - z, x1 - x)
        snap.Transform:SetPosition(x1, y1, z1)
        snap.Transform:SetRotation(angle * RADIANS)
    end
end

local function nofuel(inst)
    inst.components.weapon:SetDamage(0)
end

local function ontakefuel(inst)
    inst.components.weapon:SetDamage(40)
end

local function fn()
    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddNetwork()

    MakeInventoryPhysics(inst)

    inst.AnimState:SetBank("memorymetal")
    inst.AnimState:SetBuild("memorymetal")
    inst.AnimState:PlayAnimation("idle")

    inst:AddTag("whip")

    inst.entity:SetPristine()

    if not TheWorld.ismastersim then
        return inst
    end

    inst._container = nil
    
    inst._oncontainerownerchanged = function(container)
        topocket(inst, container)
    end

    inst._oncontainerremoved = function()
        unstore(inst)
    end
        
    inst:AddComponent("chosenowner")
    inst.components.chosenowner:SetOwner("yinkong")

    inst:ListenForEvent("onputininventory", topocket)
    inst:ListenForEvent("ondropped", toground)


    inst:AddComponent("weapon")
    inst.components.weapon:SetDamage(TUNING.WHIP_DAMAGE)
    inst.components.weapon:SetRange(4)
    inst.components.weapon:SetOnAttack(onattack)

    inst:AddComponent("fueled")
    inst.components.fueled.fueltype = "CHEMICAL"
    inst.components.fueled:InitializeFuelLevel(100)
    inst.components.fueled:SetDepletedFn(nofuel)
    inst.components.fueled:SetTakeFuelFn(ontakefuel)
    inst.components.fueled.accepting = true

    inst:AddComponent("inspectable")

    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.atlasname = "images/inventoryimages/memorymetal.xml"
    inst.components.inventoryitem.imagename = "memorymetal"

    inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip(onequip)
    inst.components.equippable:SetOnUnequip(onunequip)

    MakeHauntableLaunch(inst)

    inst.OnLoad = function(inst,data) 
            if inst.components.fueled:IsEmpty() then
                nofuel(inst)
            end
        end

    return inst
end

STRINGS.NAMES.MEMORYMETAL= "记忆金属缠丝(赵樱空)"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.MEMORYMETAL= "警告 限本人使用"
return Prefab("memorymetal", fn, assets)
