local assets =
{
    Asset("ANIM", "anim/memorymetal_z.zip"),
    Asset("ANIM", "anim/jiantou.zip"),
    Asset("ANIM", "anim/swap_memorymetal.zip"),
    Asset("IMAGE", "images/inventoryimages/memorymetal.tex"),
    Asset("ATLAS", "images/inventoryimages/memorymetal.xml"),
}

local function onequip(inst, owner)
    owner.AnimState:OverrideSymbol("swap_object", "swap_memorymetal", "swap_memorymetal")
    owner.AnimState:OverrideSymbol("whipline", "swap_memorymetal", "memorymetalline")
    owner.AnimState:Show("ARM_carry")
    owner.AnimState:Hide("ARM_normal")
    if not owner:HasTag("zhuikong") then return end
    local level = owner.components.exp.levelpoint
    inst.components.weapon:SetRange(4+level/2)
end

local function onunequip(inst, owner)
    owner.AnimState:Hide("ARM_carry")
    owner.AnimState:Show("ARM_normal")
end

local function storeincontainer(inst, container)
    if container ~= nil and container.components.container ~= nil then
        inst:ListenForEvent("onputininventory", inst._oncontainerownerchanged, container)
        inst:ListenForEvent("ondropped", inst._oncontainerownerchanged, container)
        inst._container = container
    end
end

local function unstore(inst)
    if inst._container ~= nil then
        inst:RemoveEventCallback("onputininventory", inst._oncontainerownerchanged, inst._container)
        inst:RemoveEventCallback("ondropped", inst._oncontainerownerchanged, inst._container)
        inst._container = nil
    end
end

local function topocket(inst, owner)
    if inst._container ~= owner then
        unstore(inst)
        storeincontainer(inst, owner)
    end
    if inst.task ~= nil then
        inst.task:Cancel()
        inst.task = nil
    end
    if owner.components.exp and owner.components.exp.levelpoint > 2 then 
        inst.cantrap = true
        --[[]]
        inst.AnimState:SetBank("jiantou")
        inst.AnimState:SetClientsideBuildOverride("zhuikong", "memorymetal_none", "jiantou")
    end
end

local function attackother(inst)
    if inst.components.fueled:IsEmpty() then return end
    local x,y,z = inst.Transform:GetWorldPosition()
    local ents = TheSim:FindEntities(x, y, z, 9, nil, {"wall","zhuikong","flying","ghost","shadow","shadowcreature"})
    for k, v in pairs(ents) do
        if v and v.components.health and not v.components.health:IsDead() then
            v.components.health:DoDelta(-100)
            local snap = SpawnPrefab("impact")
            snap.Transform:SetPosition(v.Transform:GetWorldPosition())
            if v.components.health.maxhealth <= 100 then
                inst.components.fueled:DoDelta(-3)
            elseif v:HasTag("epic") then
                inst.components.fueled:DoDelta(-8)
            else
                inst.components.fueled:DoDelta(-5)
            end
        end
    end
end

local function toground(inst)
    unstore(inst)
    if inst.task == nil and inst.cantrap then
        inst.task = inst:DoPeriodicTask(1, attackother)
        inst.fx = SpawnPrefab("zhuikongcircle")
        inst.fx.entity:SetParent(inst.entity)
    end
end

local function onattack(inst, attacker, target)
    if not inst.components.fueled:IsEmpty() then
        inst.components.fueled:DoDelta(-1)
    end
    if target ~= nil and target:IsValid() then
        local snap = SpawnPrefab("impact")

        local x, y, z = inst.Transform:GetWorldPosition()
        local x1, y1, z1 = target.Transform:GetWorldPosition()
        local angle = -math.atan2(z1 - z, x1 - x)
        snap.Transform:SetPosition(x1, y1, z1)
        snap.Transform:SetRotation(angle * RADIANS)
    end
end

local function nofuel(inst)
    inst.components.weapon:SetDamage(0)
end

local function ontakefuel(inst)
    inst.components.weapon:SetDamage(40)
end

local function onsave(inst, data)
    data.cantrap = inst.cantrap
end

local function onload(inst, data)
    if data then inst.cantrap = data.cantrap or false end
    if not inst.components.inventoryitem:IsHeld() and inst.task == nil and inst.cantrap then
        --[[]]
        inst.AnimState:SetBank("jiantou")
        inst.AnimState:SetClientsideBuildOverride("zhuikong", "memorymetal_none", "jiantou")
        inst.fx = SpawnPrefab("zhuikongcircle")
        inst.fx.entity:SetParent(inst.entity)
        inst.task = inst:DoPeriodicTask(1, attackother)
    end
    if inst.components.fueled:IsEmpty() then
        nofuel(inst)
    end
end

local function circlefn()
    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddNetwork()

    inst.AnimState:SetBank("memorymetal_z")
    inst.AnimState:SetBuild("memorymetal_none")
    inst.AnimState:PlayAnimation("idle")
    inst.AnimState:SetLightOverride(1)
    inst.AnimState:SetOrientation(ANIM_ORIENTATION.OnGround)
    inst.AnimState:SetLayer(LAYER_BACKGROUND)
    inst.AnimState:SetSortOrder(1)
    inst.AnimState:SetAddColour(0, .2, .5, 0)

    inst:AddTag("whip")
    inst.AnimState:SetClientsideBuildOverride("zhuikong", "memorymetal_none", "memorymetal_z")

    inst.entity:SetPristine()

    return inst
end

local function fn()
    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddNetwork()

    MakeInventoryPhysics(inst)

    --inst.Transform:SetScale(1.55, 1.55, 1.55)

    inst.AnimState:SetBank("memorymetal")
    inst.AnimState:SetBuild("memorymetal_none")
    inst.AnimState:PlayAnimation("idle")

    inst:AddTag("whip")
    inst.AnimState:SetClientsideBuildOverride("zhuikong", "memorymetal_none", "memorymetal")

    inst.entity:SetPristine()

    if not TheWorld.ismastersim then
        return inst
    end

    inst._container = nil
    inst.cantrap = false
    
    inst._oncontainerownerchanged = function(container)
        topocket(inst, container)
    end

    inst._oncontainerremoved = function()
        unstore(inst)
    end
        
    inst:AddComponent("chosenowner")
    inst.components.chosenowner:SetOwner("zhuikong")

    inst:ListenForEvent("onputininventory", topocket)
    inst:ListenForEvent("ondropped", toground)


    inst:AddComponent("weapon")
    inst.components.weapon:SetDamage(TUNING.WHIP_DAMAGE)
    inst.components.weapon:SetRange(TUNING.WHIP_RANGE)
    inst.components.weapon:SetOnAttack(onattack)

    inst:AddComponent("inspectable")

    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.atlasname = "images/inventoryimages/memorymetal.xml"
    inst.components.inventoryitem.imagename = "memorymetal"

    inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip(onequip)
    inst.components.equippable:SetOnUnequip(onunequip)

    inst:AddComponent("fueled")
    inst.components.fueled.fueltype = "CHEMICAL"
    inst.components.fueled:InitializeFuelLevel(100)
    inst.components.fueled:SetDepletedFn(nofuel)
    inst.components.fueled:SetTakeFuelFn(ontakefuel)
    inst.components.fueled.accepting = true

    MakeHauntableLaunch(inst)

    inst.OnSave = onsave
    inst.OnLoad = onload

    return inst
end

STRINGS.NAMES.MEMORYMETAL_Z= "记忆金属缠丝(赵缀空)"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.MEMORYMETAL_Z= "警告 限本人使用"
return Prefab("memorymetal_z", fn, assets),
    Prefab("zhuikongcircle", circlefn, assets)
