
local MakePlayerCharacter = require "prefabs/player_common"

local assets = {

        Asset( "ANIM", "anim/player_basic.zip" ),
        Asset( "ANIM", "anim/player_idles_shiver.zip" ),
        Asset( "ANIM", "anim/player_actions.zip" ),
        Asset( "ANIM", "anim/player_actions_axe.zip" ),
        Asset( "ANIM", "anim/player_actions_pickaxe.zip" ),
        Asset( "ANIM", "anim/player_actions_shovel.zip" ),
        Asset( "ANIM", "anim/player_actions_blowdart.zip" ),
        Asset( "ANIM", "anim/player_actions_eat.zip" ),
        Asset( "ANIM", "anim/player_actions_item.zip" ),
        Asset( "ANIM", "anim/player_actions_uniqueitem.zip" ),
        Asset( "ANIM", "anim/player_actions_bugnet.zip" ),
        Asset( "ANIM", "anim/player_actions_fishing.zip" ),
        Asset( "ANIM", "anim/player_actions_boomerang.zip" ),
        Asset( "ANIM", "anim/player_bush_hat.zip" ),
        Asset( "ANIM", "anim/player_attacks.zip" ),
        Asset( "ANIM", "anim/player_idles.zip" ),
        Asset( "ANIM", "anim/player_rebirth.zip" ),
        Asset( "ANIM", "anim/player_jump.zip" ),
        Asset( "ANIM", "anim/player_amulet_resurrect.zip" ),
        Asset( "ANIM", "anim/player_teleport.zip" ),
        Asset( "ANIM", "anim/wilson_fx.zip" ),
        Asset( "ANIM", "anim/player_one_man_band.zip" ),
        Asset( "ANIM", "anim/shadow_hands.zip" ),
        Asset( "SOUND", "sound/sfx.fsb" ),
        Asset( "SOUND", "sound/wilson.fsb" ),
        Asset( "ANIM", "anim/beard.zip" ),

        Asset( "ANIM", "anim/ruikong.zip" ),
        Asset( "ANIM", "anim/ruikong_newyear.zip" ),
        Asset( "ANIM", "anim/ruikongmad.zip"),
        Asset( "ANIM", "anim/ghost_ruikong_build.zip" ),
        Asset( "IMAGE", "images/saveslot_portraits/ruikong.tex" ),
        Asset( "ATLAS", "images/saveslot_portraits/ruikong.xml" ),

        Asset( "IMAGE", "images/selectscreen_portraits/ruikong.tex" ),
        Asset( "ATLAS", "images/selectscreen_portraits/ruikong.xml" ),
        
        Asset( "IMAGE", "images/selectscreen_portraits/ruikong_silho.tex" ),
        Asset( "ATLAS", "images/selectscreen_portraits/ruikong_silho.xml" ),

        Asset( "IMAGE", "bigportraits/ruikong.tex" ),
        Asset( "ATLAS", "bigportraits/ruikong.xml" ),
        
        Asset( "IMAGE", "images/map_icons/ruikong.tex" ),
        Asset( "ATLAS", "images/map_icons/ruikong.xml" ),
        
        Asset( "IMAGE", "images/avatars/avatar_ruikong.tex" ),
        Asset( "ATLAS", "images/avatars/avatar_ruikong.xml" ),
        
        Asset( "IMAGE", "images/avatars/avatar_ghost_ruikong.tex" ),
        Asset( "ATLAS", "images/avatars/avatar_ghost_ruikong.xml" ),
}
local prefabs = {}
local start_inv = {
}

STRINGS.CHARACTERS.GENERIC.DESCRIBE.ESCTEMPLATE = 
{
        GENERIC = "It's Esc!",
        ATTACKER = "That Esc looks shifty...",
        MURDERER = "Murderer!",
        REVIVER = "Esc, friend of ghosts.",
        GHOST = "Esc could use a heart.",
}

local function onkill(inst, data)
    local victim = data.victim
    if victim:HasTag("epic") then
        inst.components.exp:DoDelta(TUNING.EXP_EPIC)
        if victim:HasTag("dragonfly")  or victim:HasTag("toadstool") or victim:HasTag("bee") then
            inst.components.exp:DoDelta(TUNING.EXP_HUGE)
        end
    end
end

local function onbecamehuman(inst)
    if inst.components and inst.components.exp then
        inst.components.exp:ApplyUpgrades()
    end
end

local function onload(inst, data)
    inst:ListenForEvent("ms_respawnedfromghost", onbecamehuman)
    if inst.components and inst.components.exp then
        inst.components.exp:ApplyUpgrades()
    end
end

local function NoHoles(pt)
    return not TheWorld.Map:IsPointNearHole(pt)
end

local function onattack(inst, data)
    local target = data.target
    local owner = data.attacker
    local level = inst.components.exp.levelpoint
    if level < 4 then return end

    if math.random() < 0.5 then
        local pt
        if target ~= nil and target:IsValid() then
            pt = target:GetPosition()
        else
            pt = owner:GetPosition()
            target = nil
        end
        local offset = FindWalkableOffset(pt, math.random() * 2 * PI, 2, 3, false, true, NoHoles)
        if offset ~= nil then
            inst.SoundEmitter:PlaySound("dontstarve/common/shadowTentacleAttack_1")
            inst.SoundEmitter:PlaySound("dontstarve/common/shadowTentacleAttack_2")
            local tentacle = SpawnPrefab("shadowtentacle")
            if tentacle ~= nil then
                tentacle.Transform:SetPosition(pt.x + offset.x, 0, pt.z + offset.z)
                tentacle.components.combat:SetTarget(target)
            end
        end
    end
end

local function HealthRedirect(inst, amount, overtime, cause, ignore_invincible, afflicter, ignore_absorb)
    local level = inst.components.exp.levelpoint
    if level < 4 then return false end
    if ignore_absorb or amount>0 then return false end
    local critical = math.random(1,100)
    if critical >= 50 then
        local fx = SpawnPrefab("ruikong_fx")
        fx.entity:SetParent(inst.entity)
        return true
    else
        return false
    end
end

local function NormalRetargetFn(inst)
    return FindEntity(
        inst,
        TUNING.PIG_TARGET_DIST,
        function(guy)
            return not guy:HasTag("ruikong")
                and inst.components.combat:CanTarget(guy)
        end,
        { "_combat" }, -- see entityreplica.lua
        { "playerghost", "INLIMBO" }
    )
end

local function findfamliy(inst, _leader)
    if _leader.components.exp.levelpoint < 4 then return end
    local sister = FindEntity(_leader, 32, function(guy) return guy:HasTag("zhuikong") or guy:HasTag("yinkong") end)
    if sister == nil then
        _leader.components.sanity:DoDelta(-1)
    elseif sister:HasTag("yinkong") then
        _leader.components.sanity:DoDelta(2)
    else
        _leader.components.sanity:DoDelta(1)
    end
end

local function Onsanitydelta(inst, data)
    local level = inst.components.exp.levelpoint
    if level < 4 then return end
    if data.newpercent <= 0.35 and data.oldpercent > 0.35 then
        local fx = SpawnPrefab("shadow_shield2")
        fx.entity:SetParent(inst.entity)
        inst.AnimState:AddOverrideBuild("ruikongmad")
        inst:AddTag("ruikongmad")
        inst:AddTag("scarytoprey")
        for k, v in pairs(inst.components.leader.followers) do
            if k:HasTag("controled") then
                inst.components.leader:RemoveFollower(k)
                inst.components.sanity.penalty = inst.components.sanity.penalty - TUNING.RUIKONGMKCONSUME
            end
        end
    end
    if data.newpercent > 0.35 and data.oldpercent <= 0.35 then
        local fx = SpawnPrefab("shadow_shield2")
        fx.entity:SetParent(inst.entity)
        inst.AnimState:ClearOverrideBuild("ruikongmad")
        inst:RemoveTag("ruikongmad")
        inst:RemoveTag("scarytoprey")
    end
end

local function AuraFn(inst, observer)
    if observer:HasTag("zhuikong") then
        return TUNING.SANITYAURA_FAMILY/2
    elseif observer:HasTag("yinkong") then
        return TUNING.SANITYAURA_FAMILY
    end
    return 0
end

local common_postinit = function(inst) 
	inst.MiniMapEntity:SetIcon( "ruikong.tex" )
    inst:AddTag("ruikong")
    inst:RemoveTag("scarytoprey")
end

local master_postinit = function(inst)
	inst.soundsname = "wickerbottom"
	inst.components.health:SetMaxHealth(100)
	inst.components.hunger:SetMax(80)
	inst.components.sanity:SetMax(400)

    inst.components.combat.damagemultiplier = 0.75
    inst.components.health.redirect = HealthRedirect
    inst.components.sanity.penalty = 0.25
    inst.components.leader._onfollowerdied = function(follower) 
        inst.components.leader:RemoveFollower(follower)
        if follower:HasTag("controled") then
            inst.components.sanity.penalty = inst.components.sanity.penalty - TUNING.RUIKONGMKCONSUME
        end
    end

    inst:AddComponent("sanityaura")
    inst.components.sanityaura.aurafn = AuraFn

    inst.modskin = "ruikong"
    inst.mapscroll = SpawnPrefab("mapscroll")

    inst:ListenForEvent("killed",onkill)
    inst:ListenForEvent("onhitother",onattack)
    inst:ListenForEvent("sanitydelta",Onsanitydelta)
	inst.OnLoad = onload
end

STRINGS.CHARACTER_TITLES.ruikong= "赵蕊空"
STRINGS.CHARACTER_NAMES.ruikong= "赵蕊空"
STRINGS.CHARACTER_DESCRIPTIONS.ruikong= "*小电灯泡儿\n*精神锁链请按Y键\n*不要让她开四阶"
STRINGS.CHARACTER_QUOTES.ruikong= "……如果到了那个时候。"
STRINGS.CHARACTERS.RUIKONG= require "speech_ruikong"
STRINGS.NAMES.RUIKONG = "赵蕊空"

return MakePlayerCharacter("ruikong", prefabs, assets, common_postinit, master_postinit, start_inv)