local skins = {}
for k,v in pairs(RUIKONGSKINS.RUIKONG) do
	local assets = {}
	for skin,anim in pairs(v.builds) do
		table.insert(assets, anim)
	end
	if SKIN_RARITY_COLORS.ModMade ~= nil then table.insert(skins, AddModCharacterSkin("ruikong", k, v.builds, assets, {"RUIKONG", "CHARACTER"}, v.options)) end
end

return CreatePrefabSkin("ruikong_none", {
	base_prefab = "ruikong",
	skins = {
		normal_skin = "ruikong",
		ghost_skin = "ghost_ruikong_build",
		--druikong_skin = "druikong"
	},
	assets = {
		Asset( "ANIM", "anim/ruikong.zip" ),
		Asset( "ANIM", "anim/ghost_ruikong_build.zip" ),
		--Asset( "ANIM", "anim/druikong.zip" )
	},
	tags = {"RUIKONG", "CHARACTER"},
	skip_item_gen = true,
	skip_giftable_gen = true,
}), unpack(skins)