local assets =
{
    Asset("ANIM", "anim/seedgift.zip"),
    Asset("IMAGE", "images/inventoryimages/seedgift.tex"),
    Asset("ATLAS", "images/inventoryimages/seedgift.xml"),
}

local function pickseeds()
    local total_w = 0
    for k,v in pairs(VEGGIES) do
        total_w = total_w + (v.seed_weight or 1)
    end

    local rnd = math.random()*total_w
    for k,v in pairs(VEGGIES) do
        rnd = rnd - (v.seed_weight or 1)
        if rnd <= 0 then
            return k.."_seeds"
        end
    end

    return "carrot_seeds"
end

local function OnUnwrapped(inst, pos, doer)
    inst:Remove()
end

local function fn()
    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddNetwork()

    MakeInventoryPhysics(inst)

    inst.AnimState:SetBank("seedgift")
    inst.AnimState:SetBuild("seedgift")
    inst.AnimState:PlayAnimation("idle")

    inst.entity:SetPristine()

    if not TheWorld.ismastersim then
        return inst
    end

    inst:AddComponent("inspectable")

    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.atlasname = "images/inventoryimages/seedgift.xml"
    inst.components.inventoryitem.imagename = "seedgift"

    inst:AddComponent("unwrappable")
    inst.components.unwrappable:SetOnUnwrappedFn(OnUnwrapped)

    local items = {}
    for i=1,10,1
    do
        local item = SpawnPrefab(pickseeds())
        if item ~= nil then
            table.insert(items,item)
        end
    end
    if #items > 0 then
        inst.components.unwrappable:WrapItems(items)
        for i, v in ipairs(items) do
            v:Remove()
        end
    end

    MakeHauntableLaunch(inst)

    return inst
end

STRINGS.NAMES.SEEDGIFT = "一包种子"
STRINGS.RECIPE_DESC.SEEDGIFT = "挑选 分类 包好"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.SEEDGIFT = "看脸的时候到了"

return Prefab("seedgift", fn, assets)