require "brains/shadowyinkongbrain"
require "stategraphs/SGshadowyinkong"

local assets = 
{
	Asset("ANIM", "anim/swap_pickaxe.zip"),
	Asset("ANIM", "anim/swap_axe.zip"),
	Asset("ANIM", "anim/swap_yinkongsword.zip"),
    Asset("ANIM", "anim/yinkong_mirror.zip"),
    --Asset( "ANIM", "anim/yinkong.zip" ),
}

local prefabs = 
{

}

local items =
{
	AXE = "swap_axe",
	PICK = "swap_pickaxe",
    SWORD = "swap_yinkongsword"
}

local function ondeath(inst)
    local leader = inst.components.follower.leader
    if leader ~= nil then
        leader.components.sanity.penalty = 0
        leader.components.health:SetMinHealth(0)
        leader:DoTaskInTime(480*5,function(leader)
                leader:RemoveTag("HasShadow")
            end)
    end
end

local function EquipItem(inst, item)
	if item then
	    inst.AnimState:OverrideSymbol("swap_object", item, item)
	    inst.AnimState:Show("ARM_carry") 
	    inst.AnimState:Hide("ARM_normal")
	end
end

local function KeepTarget(isnt, target)
    return target and target:IsValid()
end

local function entitydeathfn(inst, data)
    if data.inst:HasTag("player") then
        inst:DoTaskInTime(math.random(), function() inst.components.health:Kill() end)
    end
end

local function HealthRedirect(inst, amount, overtime, cause, ignore_invincible, afflicter, ignore_absorb)
    if ignore_absorb or amount>0 then return false end
    local critical = math.random(1,100)
    if critical >= 30 then
        local fx = SpawnPrefab("shadow_shield2")
        fx.entity:SetParent(inst.entity)
        return true
    else
        return false
    end
end

local function FindTarget(inst, radius)
    return FindEntity(
        inst,
        SpringCombatMod(radius),
        function(guy)
            return inst.components.combat:CanTarget(guy)
        end,
        { "_combat", "shadowzhuikong" },
        { "monster", "INLIMBO" }
    )
end

local function NormalRetarget(inst)
    return FindTarget(inst, 8)
end

local function fn()
	local inst = CreateEntity()
	local trans = inst.entity:AddTransform()
	local anim = inst.entity:AddAnimState()
	local sound = inst.entity:AddSoundEmitter()
    inst.entity:AddNetwork()

	inst.Transform:SetFourFaced(inst)

	MakeGhostPhysics(inst, 1, .5)

    inst.Transform:SetScale(1.2,1.2,1.2)

	anim:SetBank("wilson")
	anim:SetBuild("yinkong_mirror")
	anim:PlayAnimation("idle")

    inst.AnimState:Hide("ARM_carry")
    inst.AnimState:Hide("HAT")
    inst.AnimState:Hide("HAIR_HAT")
    inst.AnimState:Show("HAIR_NOHAT")
    inst.AnimState:Show("HAIR")
    inst.AnimState:Show("HEAD")
    inst.AnimState:Hide("HEAD_HAT")

    inst:AddTag("scarytoprey")
    inst:AddTag("shadowyinkong")
    inst:AddTag("healthinfo")
    --inst:AddTag("NOCLICK")

    inst.entity:SetPristine()

    if not TheWorld.ismastersim then
        return inst
    end

	inst:AddComponent("locomotor")
    inst.components.locomotor:SetSlowMultiplier( 0.6 )
    inst.components.locomotor.pathcaps = { ignorecreep = true }
    inst.components.locomotor.runspeed = TUNING.SHADOWWAXWELL_SPEED

    inst:AddComponent("combat")
    inst.components.combat.hiteffectsymbol = "torso"
    inst.components.combat:SetKeepTargetFunction(KeepTarget)
    inst.components.combat:SetAttackPeriod(0)
    inst.components.combat:SetRange(2, 3)
    inst.components.combat:SetDefaultDamage(TUNING.SHADOWYINKONG_DAMAGE)
    inst.components.combat:SetRetargetFunction(2, NormalRetarget)

    inst:AddComponent("health")
    inst.components.health:SetMaxHealth(TUNING.SHADOWYINKONG_LIFE)
    inst.components.health:StartRegen(3, 10)
    inst.components.health.redirect = HealthRedirect
    --inst.components.health.nofadeout = true
    inst:ListenForEvent("death", ondeath)

    inst:AddComponent("inspectable")
    inst:AddComponent("colourtweener")

	inst:AddComponent("inventory")
    inst.components.inventory.dropondeath = false

    inst.items = items
    inst.equipfn = EquipItem
    
    inst:ListenForEvent("entity_death", function(world, data) entitydeathfn(inst, data) end, GetWorld())

    inst:AddComponent("follower")

	local brain = require "brains/shadowyinkongbrain"
	inst:SetBrain(brain)
	inst:SetStateGraph("SGshadowyinkong")

	return inst
end

STRINGS.NAMES.SHADOWYINKONG = "副人格"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.SHADOWYINKONG = "副人格樱空"
return Prefab("shadowyinkong", fn, assets, prefabs)