require "brains/shadowzhuikongbrain"
require "stategraphs/SGshadowzhuikong"

local assets = 
{
	--[[Asset("ANIM", "anim/swap_pickaxe.zip"),
	Asset("ANIM", "anim/swap_axe.zip"),
	Asset("ANIM", "anim/swap_zhuikongsword.zip"),
    Asset("ANIM", "anim/zhuikong_mirror.zip"),]]
    Asset( "ANIM", "anim/zhuikong.zip" ),
}

local prefabs = 
{

}

local items =
{
	AXE = "swap_axe",
	PICK = "swap_pickaxe",
    SWORD = "swap_zhuikongsword"
}

local function ondeath(inst)
    local leader = inst.components.follower.leader
    if leader ~= nil then
        leader.components.sanity.penalty = 0.25
        leader.components.health:SetMinHealth(0)
        leader:RemoveTag("HasShadow")
    end
end

local function EquipItem(inst, item)
	if item then
	    inst.AnimState:OverrideSymbol("swap_object", item, item)
	    inst.AnimState:Show("ARM_carry") 
	    inst.AnimState:Hide("ARM_normal")
	end
end

local function KeepTarget(isnt, target)
    return target and target:IsValid()
end

local function entitydeathfn(inst, data)
    if data.inst:HasTag("player") then
        inst:DoTaskInTime(math.random(), function() inst.components.health:Kill() end)
    end
end

local function HealthRedirect(inst, amount, overtime, cause, ignore_invincible, afflicter, ignore_absorb)
    if ignore_absorb or amount>0 then return false end
    local leader = inst.components.follower.leader
    if leader == nil or leader.components.exp.levelpoint<3 then
        return false
    end 
    local critical = math.random(1,100)
    if critical <= 50 then
        local max_tries = 4
        for k = 1, max_tries do
            local x, y, z = inst.Transform:GetWorldPosition()
            local offset = 10
            x = x + math.random(2 * offset) - offset
            z = z + math.random(2 * offset) - offset
            if TheWorld.Map:IsPassableAtPoint(x, y, z) then
                inst.Physics:Teleport(x, y, z)
                break
            end
        end
        return true
    else
        return false
    end
end

local function fn()
	local inst = CreateEntity()
	local trans = inst.entity:AddTransform()
	local anim = inst.entity:AddAnimState()
	local sound = inst.entity:AddSoundEmitter()
    inst.entity:AddNetwork()

	inst.Transform:SetFourFaced(inst)

	MakeGhostPhysics(inst, 1, .5)

	anim:SetBank("wilson")
	anim:SetBuild("zhuikong")
	anim:PlayAnimation("idle")

    inst.AnimState:Hide("ARM_carry")
    inst.AnimState:Hide("HAT")
    inst.AnimState:Hide("HAIR_HAT")
    inst.AnimState:Show("HAIR_NOHAT")
    inst.AnimState:Show("HAIR")
    inst.AnimState:Show("HEAD")
    inst.AnimState:Hide("HEAD_HAT")

    inst:AddTag("scarytoprey")
    inst:AddTag("shadowzhuikong")
    inst:AddTag("healthinfo")
    inst:AddTag("character")
    --inst:AddTag("NOCLICK")

    inst.entity:SetPristine()

    if not TheWorld.ismastersim then
        return inst
    end

	inst:AddComponent("locomotor")
    inst.components.locomotor:SetSlowMultiplier( 0.6 )
    inst.components.locomotor.pathcaps = { ignorecreep = true }
    inst.components.locomotor.runspeed = TUNING.SHADOWWAXWELL_SPEED

    inst:AddComponent("combat")
    inst.components.combat.hiteffectsymbol = "torso"
    inst.components.combat:SetKeepTargetFunction(KeepTarget)
    inst.components.combat:SetAttackPeriod(0)
    inst.components.combat:SetRange(2, 3)
    inst.components.combat:SetDefaultDamage(0)

    inst:AddComponent("knownlocations")

    inst:AddComponent("health")
    inst.components.health:SetMaxHealth(1)
    inst.components.health.redirect = HealthRedirect
    --inst.components.health.nofadeout = true
    inst:ListenForEvent("death", ondeath)

    inst:AddComponent("inspectable")
    inst:AddComponent("colourtweener")

	inst:AddComponent("inventory")
    inst.components.inventory.dropondeath = false

    inst.items = items
    inst.equipfn = EquipItem
    
    inst:ListenForEvent("entity_death", function(world, data) entitydeathfn(inst, data) end, GetWorld())

    inst:AddComponent("follower")

	local brain = require "brains/shadowzhuikongbrain"
	--inst:SetStateGraph("SGshadowzhuikong")
    --local brain = require "brains/shadowwaxwellbrain"
    inst:SetBrain(brain)
    inst:SetStateGraph("SGshadowwaxwell")

	return inst
end

STRINGS.NAMES.SHADOWZHUIKONG = "赵缀空?"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.SHADOWZHUIKONG = "看起来好像失了智"
return Prefab("shadowzhuikong", fn, assets, prefabs)