local assets =
{
   Asset("ANIM", "anim/xzfire.zip"),
}

local MAX_LIGHT_FRAME = 6

local function kill_fx(inst)
    inst:DoTaskInTime(0, inst.Remove)
end

local function fn()
    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddNetwork()
    inst.entity:AddLight()

    inst.AnimState:SetBank("xzfire")
    inst.AnimState:SetBuild("xzfire")
    inst.AnimState:PlayAnimation("level1")
    inst.AnimState:PushAnimation("level1", true)
    inst.AnimState:SetBloomEffectHandle("shaders/anim.ksh")
        
    inst.Light:SetFalloff(0.7)
    inst.Light:SetIntensity(.5)
    inst.Light:SetRadius(0.5)
    inst.Light:SetColour(237/255, 237/255, 209/255)
    inst.Light:Enable(true)

    inst.entity:SetPristine()

    inst.kill_fx = kill_fx

    return inst
end

return Prefab("xzfire", fn, assets)
