
local MakePlayerCharacter = require "prefabs/player_common"


local assets = {

        Asset( "ANIM", "anim/player_basic.zip" ),
        Asset( "ANIM", "anim/player_idles_shiver.zip" ),
        Asset( "ANIM", "anim/player_actions.zip" ),
        Asset( "ANIM", "anim/player_actions_axe.zip" ),
        Asset( "ANIM", "anim/player_actions_pickaxe.zip" ),
        Asset( "ANIM", "anim/player_actions_shovel.zip" ),
        Asset( "ANIM", "anim/player_actions_blowdart.zip" ),
        Asset( "ANIM", "anim/player_actions_eat.zip" ),
        Asset( "ANIM", "anim/player_actions_item.zip" ),
        Asset( "ANIM", "anim/player_actions_uniqueitem.zip" ),
        Asset( "ANIM", "anim/player_actions_bugnet.zip" ),
        Asset( "ANIM", "anim/player_actions_fishing.zip" ),
        Asset( "ANIM", "anim/player_actions_boomerang.zip" ),
        Asset( "ANIM", "anim/player_bush_hat.zip" ),
        Asset( "ANIM", "anim/player_attacks.zip" ),
        Asset( "ANIM", "anim/player_idles.zip" ),
        Asset( "ANIM", "anim/player_rebirth.zip" ),
        Asset( "ANIM", "anim/player_jump.zip" ),
        Asset( "ANIM", "anim/player_amulet_resurrect.zip" ),
        Asset( "ANIM", "anim/player_teleport.zip" ),
        Asset( "ANIM", "anim/wilson_fx.zip" ),
        Asset( "ANIM", "anim/player_one_man_band.zip" ),
        Asset( "ANIM", "anim/shadow_hands.zip" ),
        Asset( "SOUND", "sound/sfx.fsb" ),
        Asset( "SOUND", "sound/wilson.fsb" ),
        Asset( "ANIM", "anim/beard.zip" ),

        Asset( "ANIM", "anim/yinkong.zip" ),
        Asset( "ANIM", "anim/yinkong_newyear.zip" ),
        Asset( "ANIM", "anim/ghost_yinkong_build.zip" ),
        Asset( "IMAGE", "images/saveslot_portraits/yinkong.tex" ),
        Asset( "ATLAS", "images/saveslot_portraits/yinkong.xml" ),

        Asset( "IMAGE", "images/selectscreen_portraits/yinkong.tex" ),
        Asset( "ATLAS", "images/selectscreen_portraits/yinkong.xml" ),
        
        Asset( "IMAGE", "images/selectscreen_portraits/yinkong_silho.tex" ),
        Asset( "ATLAS", "images/selectscreen_portraits/yinkong_silho.xml" ),

        Asset( "IMAGE", "bigportraits/yinkong.tex" ),
        Asset( "ATLAS", "bigportraits/yinkong.xml" ),
        
        Asset( "IMAGE", "images/map_icons/yinkong.tex" ),
        Asset( "ATLAS", "images/map_icons/yinkong.xml" ),
        
        Asset( "IMAGE", "images/avatars/avatar_yinkong.tex" ),
        Asset( "ATLAS", "images/avatars/avatar_yinkong.xml" ),

        Asset( "IMAGE", "images/avatars/avatar_ghost_yinkong.tex" ),
        Asset( "ATLAS", "images/avatars/avatar_ghost_yinkong.xml" ),
}
local prefabs = {}
local start_inv = {
        "firetooth",
        "memorymetal",
}

STRINGS.CHARACTERS.GENERIC.DESCRIBE.ESCTEMPLATE = 
{
        GENERIC = "It's Esc!",
        ATTACKER = "That Esc looks shifty...",
        MURDERER = "Murderer!",
        REVIVER = "Esc, friend of ghosts.",
        GHOST = "Esc could use a heart.",
}

local function onbecamehuman(inst)
    if inst.components and inst.components.exp then
        inst.components.exp:ApplyUpgrades()
    end
end

local function onload(inst, data)
    inst:ListenForEvent("ms_respawnedfromghost", onbecamehuman)
    if inst.components and inst.components.exp then
        inst.components.exp:ApplyUpgrades()
    end
end

local function onsave(inst, data)
    local followers = inst.components.leader.followers
    for k, v in pairs(followers) do
        if k:HasTag("shadowyinkong") then
            k.components.health:Kill()
        end
    end
end

local function onkill(inst, data)
    local victim = data.victim
    inst.components.sanity:DoDelta(5)
    if victim:HasTag("epic") then
        inst.components.exp:DoDelta(TUNING.EXP_EPIC)
        if victim:HasTag("dragonfly")  or victim:HasTag("toadstool") or victim:HasTag("bee") then
            inst.components.exp:DoDelta(TUNING.EXP_HUGE)
        end
    end
end

local function OnHealthDelta(inst, data)
    if data.newpercent < 0.01 and inst.components.health.minhealth > 0 then
        inst:DoTaskInTime(0.5,function()
            inst.components.health:SetPercent(0.5)
            local followers = inst.components.leader.followers
            for k, v in pairs(followers) do
                if k:HasTag("shadowyinkong") then
                    k.components.health:Kill()
                end
            end
        end)        
    end
end

local function onattack(inst, data)
    if not inst:HasTag("yinkong_destory") then return end
    local victim = data.target
    local item = data.weapon
    if item and item.components.weapon and 
        math.random() < 0.2 and
        victim and victim.components.health and not victim.components.health:IsDead() and 
        victim.components.health.absorb ~= 0 then
        local amount = item.components.weapon.damage * inst.components.combat.damagemultiplier * victim.components.health.absorb
        victim.components.health:DoDelta(-amount, nil, nil, nil, nil, true)
        SpawnPrefab("explode_small").Transform:SetPosition(victim.Transform:GetWorldPosition())
    end
end

local function AuraFn(inst, observer)
    if observer:HasTag("zhuikong") or observer:HasTag("ruikong") then
        return TUNING.SANITYAURA_FAMILY
    end
    return 0
end

local common_postinit = function(inst) 
	inst.MiniMapEntity:SetIcon( "yinkong.tex" )
        inst:AddTag("yinkong")
end

local master_postinit = function(inst)
	inst.soundsname = "winona"
	inst.components.health:SetMaxHealth(150)
	inst.components.hunger:SetMax(120)
	inst.components.sanity:SetMax(200)

    inst.components.sanity.night_drain_mult = 0.8
    inst.components.sanity.neg_aura_mult = 0.8

    inst:AddComponent("sanityaura")
    inst.components.sanityaura.aurafn = AuraFn

	inst.components.combat.damagemultiplier = 1.2
    inst.components.eater.ignoresspoilage = true
    inst.modskin = "yinkong"
    inst:ListenForEvent("killed",onkill)
    inst:ListenForEvent("healthdelta", OnHealthDelta)
    inst:ListenForEvent("onattackother", onattack)
    inst.OnLoad = onload
    inst.OnSave = onsave

end

STRINGS.CHARACTER_TITLES.yinkong= "赵樱空"
STRINGS.CHARACTER_NAMES.yinkong= "赵樱空"
STRINGS.CHARACTER_DESCRIPTIONS.yinkong= "*主人格主导\n*珍视同伴"
STRINGS.CHARACTER_QUOTES.yinkong= "我们说好要一起长大的……"
STRINGS.CHARACTERS.YINKONG= require "speech_yinkong"
STRINGS.NAMES.YINKONG = "赵樱空"

return MakePlayerCharacter("yinkong", prefabs, assets, common_postinit, master_postinit, start_inv)